/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.util.List;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.ResourceBundleELResolver;
import javax.servlet.jsp.el.ImplicitObjectELResolver;
import javax.servlet.jsp.el.ScopedAttributeELResolver;

public class JasperELResolver
extends CompositeELResolver {
    private int size;
    private ELResolver[] resolvers;
    private final int appResolversSize;

    public JasperELResolver(List<ELResolver> list) {
        this.appResolversSize = list.size();
        this.resolvers = new ELResolver[this.appResolversSize + 7];
        this.size = 0;
        this.add((ELResolver)new ImplicitObjectELResolver());
        for (ELResolver eLResolver : list) {
            this.add(eLResolver);
        }
        this.add((ELResolver)new MapELResolver());
        this.add((ELResolver)new ResourceBundleELResolver());
        this.add((ELResolver)new ListELResolver());
        this.add((ELResolver)new ArrayELResolver());
        this.add((ELResolver)new BeanELResolver());
        this.add((ELResolver)new ScopedAttributeELResolver());
    }

    public synchronized void add(ELResolver eLResolver) {
        super.add(eLResolver);
        if (this.resolvers.length > this.size) {
            this.resolvers[this.size] = eLResolver;
        } else {
            ELResolver[] eLResolverArray = new ELResolver[this.size + 1];
            System.arraycopy(this.resolvers, 0, eLResolverArray, 0, this.size);
            eLResolverArray[this.size] = eLResolver;
            this.resolvers = eLResolverArray;
        }
        ++this.size;
    }

    public Object getValue(ELContext eLContext, Object object, Object object2) throws NullPointerException, PropertyNotFoundException, ELException {
        int n;
        int n2;
        eLContext.setPropertyResolved(false);
        Object object3 = null;
        if (object == null) {
            n2 = 1 + this.appResolversSize;
            for (int i = 0; i < n2; ++i) {
                object3 = this.resolvers[i].getValue(eLContext, object, object2);
                if (!eLContext.isPropertyResolved()) continue;
                return object3;
            }
            n = n2 + 5;
        } else {
            n = 1;
        }
        for (n2 = n; n2 < this.size; ++n2) {
            object3 = this.resolvers[n2].getValue(eLContext, object, object2);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        return null;
    }

    public Object invoke(ELContext eLContext, Object object, Object object2, Class<?>[] classArray, Object[] objectArray) {
        int n;
        String string = JasperELResolver.coerceToString(object2);
        if (string.length() == 0) {
            throw new ELException((Throwable)new NoSuchMethodException());
        }
        eLContext.setPropertyResolved(false);
        Object object3 = null;
        int n2 = 1 + this.appResolversSize;
        for (n = 1; n < n2; ++n) {
            object3 = this.resolvers[n].invoke(eLContext, object, (Object)string, (Class[])classArray, objectArray);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        for (n = n2 += 4; n < this.size; ++n) {
            object3 = this.resolvers[n].invoke(eLContext, object, (Object)string, (Class[])classArray, objectArray);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        return null;
    }

    private static final String coerceToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        return object.toString();
    }
}

