/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.catalina.Session;
import org.apache.catalina.manager.util.SessionUtils;

public class JspHelper {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int HIGHEST_SPECIAL = 62;
    private static final char[][] specialCharactersRepresentation = new char[63][];

    private JspHelper() {
    }

    public static String guessDisplayLocaleFromSession(Session session) {
        return JspHelper.localeToString(SessionUtils.guessLocaleFromSession(session));
    }

    private static String localeToString(Locale locale) {
        if (locale != null) {
            return JspHelper.escapeXml(locale.toString());
        }
        return "";
    }

    public static String guessDisplayUserFromSession(Session session) {
        Object object = SessionUtils.guessUserFromSession(session);
        return JspHelper.escapeXml(object);
    }

    public static String getDisplayCreationTimeForSession(Session session) {
        try {
            if (session.getCreationTime() == 0L) {
                return "";
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
            return simpleDateFormat.format(new Date(session.getCreationTime()));
        }
        catch (IllegalStateException illegalStateException) {
            return "";
        }
    }

    public static String getDisplayLastAccessedTimeForSession(Session session) {
        try {
            if (session.getLastAccessedTime() == 0L) {
                return "";
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
            return simpleDateFormat.format(new Date(session.getLastAccessedTime()));
        }
        catch (IllegalStateException illegalStateException) {
            return "";
        }
    }

    public static String getDisplayUsedTimeForSession(Session session) {
        try {
            if (session.getCreationTime() == 0L) {
                return "";
            }
        }
        catch (IllegalStateException illegalStateException) {
            return "";
        }
        return JspHelper.secondsToTimeString(SessionUtils.getUsedTimeForSession(session) / 1000L);
    }

    public static String getDisplayTTLForSession(Session session) {
        try {
            if (session.getCreationTime() == 0L) {
                return "";
            }
        }
        catch (IllegalStateException illegalStateException) {
            return "";
        }
        return JspHelper.secondsToTimeString(SessionUtils.getTTLForSession(session) / 1000L);
    }

    public static String getDisplayInactiveTimeForSession(Session session) {
        try {
            if (session.getCreationTime() == 0L) {
                return "";
            }
        }
        catch (IllegalStateException illegalStateException) {
            return "";
        }
        return JspHelper.secondsToTimeString(SessionUtils.getInactiveTimeForSession(session) / 1000L);
    }

    public static String secondsToTimeString(long l) {
        StringBuilder stringBuilder = new StringBuilder(9);
        if (l < 0L) {
            stringBuilder.append('-');
            l = -l;
        }
        long l2 = l;
        long l3 = l2 / 3600L;
        long l4 = (l2 %= 3600L) / 60L;
        long l5 = l2 %= 60L;
        if (l3 < 10L) {
            stringBuilder.append('0');
        }
        stringBuilder.append(l3);
        stringBuilder.append(':');
        if (l4 < 10L) {
            stringBuilder.append('0');
        }
        stringBuilder.append(l4);
        stringBuilder.append(':');
        if (l5 < 10L) {
            stringBuilder.append('0');
        }
        stringBuilder.append(l5);
        return stringBuilder.toString();
    }

    public static String escapeXml(Object object) {
        String string = null;
        try {
            string = object == null ? null : object.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JspHelper.escapeXml(string);
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return "";
        }
        int n = 0;
        int n2 = string.length();
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n2; ++i) {
            char[] cArray2;
            char c = cArray[i];
            if (c > '>' || (cArray2 = specialCharactersRepresentation[c]) == null) continue;
            if (n == 0) {
                stringBuilder = new StringBuilder(n2 + 5);
            }
            if (n < i) {
                stringBuilder.append(cArray, n, i - n);
            }
            n = i + 1;
            stringBuilder.append(cArray2);
        }
        if (n == 0) {
            return string;
        }
        if (n < n2) {
            stringBuilder.append(cArray, n, n2 - n);
        }
        return stringBuilder.toString();
    }

    public static String formatNumber(long l) {
        return NumberFormat.getNumberInstance().format(l);
    }

    static {
        JspHelper.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        JspHelper.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        JspHelper.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        JspHelper.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        JspHelper.specialCharactersRepresentation[39] = "&#039;".toCharArray();
    }
}

