/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.ui.jdbc.LiveJDBCView;
import org.openide.util.Lookup;

public class LiveJDBCViewUpdater {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private CCTHandler handler;
    private final LiveJDBCView jdbcView;
    private final ProfilerClient client;
    private volatile boolean paused;
    private volatile boolean forceRefresh;

    public LiveJDBCViewUpdater(LiveJDBCView liveJDBCView, ProfilerClient profilerClient) {
        this.jdbcView = liveJDBCView;
        this.client = profilerClient;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public void setForceRefresh(boolean bl) {
        this.forceRefresh = bl;
    }

    public void update() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.handler == null) {
            this.handler = CCTHandler.registerUpdater(this);
        }
        if (this.forceRefresh || !this.paused && this.jdbcView.getLastUpdate() + 1400L < System.currentTimeMillis()) {
            this.client.forceObtainedResultsDump(true);
        }
    }

    public void cleanup() {
        if (this.handler != null) {
            this.handler.unregisterUpdater(this);
        }
        this.handler = null;
    }

    private void updateData() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.forceRefresh && (this.paused || this.jdbcView.getLastUpdate() + 900L > System.currentTimeMillis())) {
            return;
        }
        JdbcResultsSnapshot jdbcResultsSnapshot = this.client.getStatus().getInstrMethodClasses() == null ? null : this.client.getJdbcProfilingResultsSnapshot(false);
        this.jdbcView.setData(jdbcResultsSnapshot);
        this.forceRefresh = false;
    }

    private void resetData() {
        this.jdbcView.resetData();
    }

    public static class CCTHandler
    implements JdbcCCTProvider.Listener {
        private final List<LiveJDBCViewUpdater> updaters = new ArrayList<LiveJDBCViewUpdater>();

        public static CCTHandler registerUpdater(LiveJDBCViewUpdater liveJDBCViewUpdater) {
            CCTHandler cCTHandler = (CCTHandler)Lookup.getDefault().lookup(CCTHandler.class);
            if (cCTHandler.updaters.isEmpty()) {
                Collection collection = Lookup.getDefault().lookupAll(JdbcCCTProvider.class);
                assert (!collection.isEmpty());
                for (JdbcCCTProvider jdbcCCTProvider : collection) {
                    jdbcCCTProvider.addListener((CCTProvider.Listener)cCTHandler);
                }
            }
            cCTHandler.updaters.add(liveJDBCViewUpdater);
            return cCTHandler;
        }

        public void unregisterUpdater(LiveJDBCViewUpdater liveJDBCViewUpdater) {
            this.updaters.remove(liveJDBCViewUpdater);
            if (this.updaters.isEmpty()) {
                Collection collection = Lookup.getDefault().lookupAll(JdbcCCTProvider.class);
                assert (!collection.isEmpty());
                for (JdbcCCTProvider jdbcCCTProvider : collection) {
                    jdbcCCTProvider.removeListener((CCTProvider.Listener)this);
                }
            }
        }

        public final void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean bl) {
            if (!bl) {
                for (LiveJDBCViewUpdater liveJDBCViewUpdater : this.updaters) {
                    try {
                        liveJDBCViewUpdater.updateData();
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                        Logger.getLogger(LiveJDBCView.class.getName()).log(Level.FINE, null, targetAppOrVMTerminated);
                    }
                }
            }
        }

        public final void cctReset() {
            for (LiveJDBCViewUpdater liveJDBCViewUpdater : this.updaters) {
                liveJDBCViewUpdater.resetData();
            }
        }
    }
}

