/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WsSession;

class FutureToSendHandler
implements Future<Void>,
SendHandler {
    private static final StringManager sm = StringManager.getManager(FutureToSendHandler.class);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final WsSession wsSession;
    private volatile AtomicReference<SendResult> result = new AtomicReference<Object>(null);

    public FutureToSendHandler(WsSession wsSession) {
        this.wsSession = wsSession;
    }

    public void onResult(SendResult sendResult) {
        this.result.compareAndSet(null, sendResult);
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        try {
            this.wsSession.registerFuture(this);
            this.latch.await();
        }
        finally {
            this.wsSession.unregisterFuture(this);
        }
        if (this.result.get().getException() != null) {
            throw new ExecutionException(this.result.get().getException());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean bl = false;
        try {
            this.wsSession.registerFuture(this);
            bl = this.latch.await(l, timeUnit);
        }
        finally {
            this.wsSession.unregisterFuture(this);
        }
        if (!bl) {
            throw new TimeoutException(sm.getString("futureToSendHandler.timeout", new Object[]{l, timeUnit.toString().toLowerCase()}));
        }
        if (this.result.get().getException() != null) {
            throw new ExecutionException(this.result.get().getException());
        }
        return null;
    }
}

