/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.GSSRealm;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.realm.RealmBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class CombinedRealm
extends RealmBase {
    private static final Log log = LogFactory.getLog(CombinedRealm.class);
    protected List<Realm> realms = new LinkedList<Realm>();
    protected static final String name = "CombinedRealm";

    public void addRealm(Realm realm) {
        this.realms.add(realm);
        if (log.isDebugEnabled()) {
            sm.getString("combinedRealm.addRealm", new Object[]{realm.getInfo(), Integer.toString(this.realms.size())});
        }
    }

    public ObjectName[] getRealms() {
        ObjectName[] objectNameArray = new ObjectName[this.realms.size()];
        for (Realm realm : this.realms) {
            if (!(realm instanceof RealmBase)) continue;
            objectNameArray[this.realms.indexOf((Object)realm)] = ((RealmBase)realm).getObjectName();
        }
        return objectNameArray;
    }

    @Override
    public Principal authenticate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Principal principal = null;
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", new Object[]{string, realm.getInfo()}));
            }
            if ((principal = realm.authenticate(string, string2, string3, string4, string5, string6, string7, string8)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", new Object[]{string, realm.getInfo()}));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSuccess", new Object[]{string, realm.getInfo()}));
            break;
        }
        return principal;
    }

    @Override
    public Principal authenticate(String string) {
        Principal principal = null;
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", new Object[]{string, realm.getClass().getName()}));
            }
            if ((principal = realm.authenticate(string)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", new Object[]{string, realm.getClass().getName()}));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSuccess", new Object[]{string, realm.getClass().getName()}));
            break;
        }
        return principal;
    }

    @Override
    public Principal authenticate(String string, String string2) {
        Principal principal = null;
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", new Object[]{string, realm.getInfo()}));
            }
            if ((principal = realm.authenticate(string, string2)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", new Object[]{string, realm.getInfo()}));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSuccess", new Object[]{string, realm.getInfo()}));
            break;
        }
        return principal;
    }

    @Override
    public void setContainer(Container container) {
        for (Realm realm : this.realms) {
            if (realm instanceof RealmBase) {
                ((RealmBase)realm).setRealmPath(this.getRealmPath() + "/realm" + this.realms.indexOf(realm));
            }
            realm.setContainer(container);
        }
        super.setContainer(container);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        Iterator<Realm> iterator = this.realms.iterator();
        while (iterator.hasNext()) {
            Realm realm = iterator.next();
            if (!(realm instanceof Lifecycle)) continue;
            try {
                ((Lifecycle)((Object)realm)).start();
            }
            catch (LifecycleException lifecycleException) {
                iterator.remove();
                log.error((Object)sm.getString("combinedRealm.realmStartFail", new Object[]{realm.getInfo()}), (Throwable)lifecycleException);
            }
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        for (Realm realm : this.realms) {
            if (!(realm instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)realm)).stop();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        for (Realm realm : this.realms) {
            if (!(realm instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)realm)).destroy();
        }
        super.destroyInternal();
    }

    @Override
    public void backgroundProcess() {
        super.backgroundProcess();
        for (Realm realm : this.realms) {
            realm.backgroundProcess();
        }
    }

    @Override
    public Principal authenticate(X509Certificate[] x509CertificateArray) {
        Principal principal = null;
        String string = null;
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            string = x509CertificateArray[0].getSubjectDN().getName();
        }
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", new Object[]{string, realm.getInfo()}));
            }
            if ((principal = realm.authenticate(x509CertificateArray)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", new Object[]{string, realm.getInfo()}));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSuccess", new Object[]{string, realm.getInfo()}));
            break;
        }
        return principal;
    }

    @Override
    public Principal authenticate(GSSContext gSSContext, boolean bl) {
        if (gSSContext.isEstablished()) {
            Principal principal = null;
            GSSName gSSName = null;
            try {
                gSSName = gSSContext.getSrcName();
            }
            catch (GSSException gSSException) {
                log.warn((Object)sm.getString("realmBase.gssNameFail"), (Throwable)gSSException);
                return null;
            }
            for (Realm realm : this.realms) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("combinedRealm.authStart", new Object[]{gSSName, realm.getInfo()}));
                }
                if ((principal = realm.authenticate(gSSContext, bl)) == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("combinedRealm.authFail", new Object[]{gSSName, realm.getInfo()}));
                    continue;
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)sm.getString("combinedRealm.authSuccess", new Object[]{gSSName, realm.getInfo()}));
                break;
            }
            return principal;
        }
        return null;
    }

    @Override
    public Principal authenticate(GSSName gSSName, GSSCredential gSSCredential) {
        Principal principal = null;
        for (Realm realm : this.realms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("combinedRealm.authStart", new Object[]{gSSName, realm.getClass().getName()}));
            }
            if (!(realm instanceof GSSRealm)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", new Object[]{gSSName, realm.getClass().getName()}));
                continue;
            }
            principal = ((GSSRealm)realm).authenticate(gSSName, gSSCredential);
            if (principal == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("combinedRealm.authFail", new Object[]{gSSName, realm.getClass().getName()}));
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)sm.getString("combinedRealm.authSuccess", new Object[]{gSSName, realm.getClass().getName()}));
            break;
        }
        return principal;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String string) {
        for (Realm realm : this.realms) {
            if (!realm.hasRole(wrapper, principal, string)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    protected String getPassword(String string) {
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(sm.getString("combinedRealm.getPassword"));
        log.error((Object)sm.getString("combinedRealm.unexpectedMethod"), (Throwable)unsupportedOperationException);
        throw unsupportedOperationException;
    }

    @Override
    protected Principal getPrincipal(String string) {
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(sm.getString("combinedRealm.getPrincipal"));
        log.error((Object)sm.getString("combinedRealm.unexpectedMethod"), (Throwable)unsupportedOperationException);
        throw unsupportedOperationException;
    }
}

