/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.StoreManager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class PersistentValve
extends ValveBase {
    private static final ClassLoader MY_CLASSLOADER = PersistentValve.class.getClassLoader();
    private volatile boolean clBindRequired;
    protected Pattern filter = null;

    public PersistentValve() {
        super(true);
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.clBindRequired = container instanceof Engine || container instanceof Host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block27: {
            Object object;
            Object object2;
            if (this.isRequestWithoutSession(request.getDecodedRequestURI())) {
                this.getNext().invoke(request, response);
                return;
            }
            Context context = request.getContext();
            if (context == null) {
                response.sendError(500, sm.getString("standardHost.noContext"));
                return;
            }
            String string = request.getRequestedSessionId();
            Manager manager = context.getManager();
            if (string != null && manager instanceof StoreManager && (object2 = ((StoreManager)((Object)manager)).getStore()) != null) {
                object = null;
                try {
                    object = object2.load(string);
                }
                catch (Exception exception) {
                    this.container.getLogger().error((Object)"deserializeError");
                }
                if (object != null) {
                    if (!object.isValid() || this.isSessionStale((Session)object, System.currentTimeMillis())) {
                        if (this.container.getLogger().isDebugEnabled()) {
                            this.container.getLogger().debug((Object)"session swapped in is invalid or expired");
                        }
                        object.expire();
                        object2.remove(string);
                    } else {
                        object.setManager(manager);
                        manager.add((Session)object);
                        object.access();
                        object.endAccess();
                    }
                }
            }
            if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().debug((Object)("sessionId: " + string));
            }
            this.getNext().invoke(request, response);
            if (!request.isAsync()) {
                try {
                    object2 = request.getSessionInternal(false);
                }
                catch (Exception exception) {
                    object2 = null;
                }
                object = null;
                if (object2 != null) {
                    object = object2.getIdInternal();
                }
                if (this.container.getLogger().isDebugEnabled()) {
                    this.container.getLogger().debug((Object)("newsessionId: " + (String)object));
                }
                if (object != null) {
                    try {
                        this.bind(context);
                        if (manager instanceof StoreManager) {
                            Session session = manager.findSession((String)object);
                            Store store = ((StoreManager)((Object)manager)).getStore();
                            boolean bl = false;
                            if (session != null) {
                                Session session2 = session;
                                synchronized (session2) {
                                    if (store != null && session.isValid() && !this.isSessionStale(session, System.currentTimeMillis())) {
                                        store.save(session);
                                        ((StoreManager)((Object)manager)).removeSuper(session);
                                        session.recycle();
                                        bl = true;
                                    }
                                }
                            }
                            if (!bl && this.container.getLogger().isDebugEnabled()) {
                                this.container.getLogger().debug((Object)("newsessionId store: " + store + " session: " + session + " valid: " + (session == null ? "N/A" : Boolean.toString(session.isValid())) + " stale: " + this.isSessionStale(session, System.currentTimeMillis())));
                            }
                            break block27;
                        }
                        if (this.container.getLogger().isDebugEnabled()) {
                            this.container.getLogger().debug((Object)("newsessionId Manager: " + manager));
                        }
                    }
                    finally {
                        this.unbind(context);
                    }
                }
            }
        }
    }

    protected boolean isSessionStale(Session session, long l) {
        int n;
        int n2;
        return session != null && (n2 = session.getMaxInactiveInterval()) >= 0 && (n = (int)(session.getIdleTimeInternal() / 1000L)) >= n2;
    }

    private void bind(Context context) {
        if (this.clBindRequired) {
            context.bind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    private void unbind(Context context) {
        if (this.clBindRequired) {
            context.unbind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    protected boolean isRequestWithoutSession(String string) {
        Pattern pattern = this.filter;
        return pattern != null && pattern.matcher(string).matches();
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.toString();
    }

    public void setFilter(String string) {
        if (string == null || string.length() == 0) {
            this.filter = null;
        } else {
            try {
                this.filter = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.container.getLogger().error((Object)sm.getString("persistentValve.filter.failure", new Object[]{string}), (Throwable)patternSyntaxException);
            }
        }
    }
}

