/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.impl.MultiRowTabDisplayer;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.SingleRowTabTable;
import org.netbeans.swing.tabcontrol.TabDataModel;

public class RowPerProjectTabDisplayer
extends MultiRowTabDisplayer
implements ChangeListener {
    public RowPerProjectTabDisplayer(TabDataModel tabDataModel, int n) {
        super(tabDataModel, n);
    }

    @Override
    void initRows() {
        int n = ProjectSupport.getDefault().getOpenProjects().length;
        if (n > 1) {
            ++n;
        }
        for (int i = 0; i < n; ++i) {
            this.addRowTable();
        }
    }

    private void adjustRows(int n) {
        int n2 = n;
        if (n2 > 1) {
            ++n2;
        }
        while (n2 < this.rowTables.size() && this.rowTables.size() > 1) {
            this.removeTable();
        }
        while (n2 > this.rowTables.size()) {
            this.addRowTable();
        }
        this.layoutManager.invalidate();
    }

    private void removeTable() {
        if (this.rowTables.size() < 2) {
            return;
        }
        SingleRowTabTable singleRowTabTable = (SingleRowTabTable)this.rowTables.get(this.rowTables.size() - 1);
        singleRowTabTable.removeMouseWheelListener(this);
        singleRowTabTable.removeMouseListener(this.controller);
        singleRowTabTable.removeMouseListener(this.closeHandler);
        singleRowTabTable.removeMouseMotionListener(this.closeHandler);
        singleRowTabTable.getSelectionModel().removeListSelectionListener(this);
        singleRowTabTable.getColumnModel().getSelectionModel().removeListSelectionListener(this);
        this.rowTables.remove(singleRowTabTable);
        this.rowPanel.remove(singleRowTabTable);
    }

    @Override
    public void addNotify() {
        ProjectSupport.getDefault().addChangeListener(this);
        super.addNotify();
        this.layoutManager.invalidate();
    }

    @Override
    public void removeNotify() {
        ProjectSupport.getDefault().removeChangeListener(this);
        super.removeNotify();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        final int n = ProjectSupport.getDefault().getOpenProjects().length;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RowPerProjectTabDisplayer.this.adjustRows(n);
            }
        });
    }
}

