/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.util.Locale;
import java.util.Map;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.util.Contract;

public class LocalizableStringValue
implements StringValue {
    private Map<Object, String> lookup;
    private Locale locale;

    public LocalizableStringValue(Map<Object, String> lookup) {
        this(lookup, null);
    }

    public LocalizableStringValue(Map<Object, String> lookup, Locale locale) {
        this.lookup = Contract.asNotNull(lookup, "map must not be null");
        this.setLocale(locale);
    }

    @Override
    public String getString(Object value) {
        String text;
        String key = this.lookup.get(value);
        if (key != null && (text = UIManagerExt.getString(key, this.getLocale())) != null) {
            return text;
        }
        return StringValues.TO_STRING_UI.getString(value);
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }
}

