/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.request;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.Nullable;

public class StatsHttpResponse {
    private final HttpResponse myResponse;
    private final int myCode;

    public StatsHttpResponse(@Nullable HttpResponse response, int code) {
        this.myResponse = response;
        this.myCode = code;
    }

    public int getStatusCode() {
        return this.myCode;
    }

    @Nullable
    public Long lastModified() {
        if (this.myResponse == null) {
            return null;
        }
        Header[] headers = this.myResponse.getHeaders("Last-Modified");
        return Stream.of(headers).map(header -> header.getValue()).filter(Objects::nonNull).map(value -> DateUtils.parseDate((String)value).getTime()).max(Long::compareTo).orElse(null);
    }

    @Nullable
    public String readAsString() throws IOException {
        HttpEntity entity = this.myResponse != null ? this.myResponse.getEntity() : null;
        return entity != null ? EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8) : null;
    }

    @Nullable
    public InputStream read() throws IOException {
        HttpEntity entity = this.myResponse != null ? this.myResponse.getEntity() : null;
        return entity != null ? entity.getContent() : null;
    }
}

