/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDeprecatedElementInspection
extends XmlSuppressableInspectionTool {
    @Language(value="RegExp")
    public String regexp = "(?i)deprecated.*";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlDeprecatedElementInspection.$$$reportNull$$$0(0);
        }
        final Pattern pattern = Pattern.compile(this.regexp);
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                ASTNode nameNode;
                if (XmlDeprecatedElementInspection.checkDeprecated((PsiMetaData)tag.getDescriptor(), pattern) && (nameNode = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode())) != null) {
                    holder.registerProblem(nameNode.getPsi(), XmlAnalysisBundle.message((String)"the.tag.is.marked.as.deprecated", (Object[])new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (XmlDeprecatedElementInspection.checkDeprecated((PsiMetaData)attribute.getDescriptor(), pattern)) {
                    holder.registerProblem((PsiElement)attribute.getNameElement(), XmlAnalysisBundle.message((String)"the.attribute.is.marked.as.deprecated", (Object[])new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new OptionsPanel(this).myPanel;
    }

    private static boolean checkDeprecated(@Nullable PsiMetaData metaData, Pattern pattern) {
        if (metaData == null) {
            return false;
        }
        PsiElement declaration = metaData.getDeclaration();
        if (!(declaration instanceof XmlTag)) {
            return false;
        }
        XmlComment comment = XmlUtil.findPreviousComment(declaration);
        if (comment != null && pattern.matcher(comment.getCommentText().trim()).matches()) {
            return true;
        }
        XmlTag tag = (XmlTag)declaration;
        return XmlDeprecatedElementInspection.checkTag((XmlTag)ArrayUtil.getFirstElement((Object[])tag.findSubTags("annotation", tag.getNamespace())), pattern);
    }

    private static boolean checkTag(XmlTag tag, Pattern pattern) {
        if (tag == null) {
            return false;
        }
        if ("documentation".equals(tag.getLocalName())) {
            String text = tag.getValue().getTrimmedText();
            return pattern.matcher(text).matches();
        }
        for (XmlTag subTag : tag.getSubTags()) {
            if (!XmlDeprecatedElementInspection.checkTag(subTag, pattern)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlDeprecatedElementInspection", "buildVisitor"));
    }

    public static class OptionsPanel {
        private JTextField myTextField;
        private JPanel myPanel;

        public OptionsPanel(XmlDeprecatedElementInspection inspection) {
            this.$$$setupUI$$$();
            this.myTextField.setText(inspection.regexp);
            this.myTextField.addActionListener(e -> {
                inspection.regexp = this.myTextField.getText();
            });
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myTextField = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Regexp:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }
    }
}

