/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\r\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFile;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "equals", "", "other", "", "getName", "getPath", "getPresentableName", "Lorg/jetbrains/annotations/NotNull;", "getPresentablePath", "intellij.vcs.github"})
public final class GHPRDiffVirtualFile
extends GHPRVirtualFile {
    @NotNull
    public String getName() {
        return "" + '#' + this.getPullRequest().getNumber() + ".diff";
    }

    @NotNull
    public String getPresentableName() {
        String string = GithubBundle.message("pull.request.diff.editor.title", this.getPullRequest().getNumber());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"pu\u2026tle\", pullRequest.number)");
        return string;
    }

    @NotNull
    public String getPath() {
        return GHPRVirtualFileSystem.Companion.getPath(this.getFileManagerId(), this.getProject(), this.getRepository(), this.getPullRequest(), true);
    }

    @NotNull
    public String getPresentablePath() {
        return this.getRepository().toUrl() + "/pulls/" + this.getPullRequest().getNumber() + ".diff";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRDiffVirtualFile)) {
            return false;
        }
        return super.equals(other);
    }

    public GHPRDiffVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkParameterIsNotNull((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)pullRequest, (String)"pullRequest");
        super(fileManagerId, project, repository, pullRequest);
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
        this.setWritable(false);
    }
}

