/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.ui.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountCombobox;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u0012*\u0010\n\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\r0\u000b\u00a2\u0006\u0002\u0010\u000fJ\b\u0010!\u001a\u00020\"H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$H\u0014J\u0006\u0010%\u001a\u00020\u0006J\u0006\u0010&\u001a\u00020\tJ\b\u0010'\u001a\u00020\tH\u0014J\b\u0010(\u001a\u00020\tH\u0014J\b\u0010)\u001a\u00020\u001fH\u0016J\u0006\u0010*\u001a\u00020\tJ\u0006\u0010+\u001a\u00020\tJ\u0006\u0010,\u001a\u00020\u000eJ\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0006H\u0002J\u000e\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020\tR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubShareDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "accounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "defaultAccount", "existingRemotes", "", "accountInformationSupplier", "Lkotlin/Function2;", "Ljava/awt/Component;", "Lkotlin/Pair;", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/util/Set;Lkotlin/jvm/functions/Function2;)V", "GITHUB_REPO_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "accountInformationLoadingError", "Lcom/intellij/openapi/ui/ValidationInfo;", "accountSelector", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountCombobox;", "descriptionTextArea", "Ljavax/swing/JTextArea;", "existingRemoteValidator", "Lorg/jetbrains/plugins/github/ui/util/DialogValidationUtils$RecordUniqueValidator;", "existingRepoValidator", "privateCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "remoteTextField", "Lcom/intellij/ui/components/JBTextField;", "repositoryTextField", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "doValidateAll", "", "getAccount", "getDescription", "getDimensionServiceKey", "getHelpId", "getPreferredFocusedComponent", "getRemoteName", "getRepositoryName", "isPrivate", "switchAccount", "", "account", "testSetRepositoryName", "name", "intellij.vcs.github"})
public final class GithubShareDialog
extends DialogWrapper {
    private final Pattern GITHUB_REPO_PATTERN;
    private final JBTextField repositoryTextField;
    private final JBCheckBox privateCheckBox;
    private final JBTextField remoteTextField;
    private final JTextArea descriptionTextArea;
    private final GithubAccountCombobox accountSelector;
    private final DialogValidationUtils.RecordUniqueValidator existingRepoValidator;
    private final DialogValidationUtils.RecordUniqueValidator existingRemoteValidator;
    private ValidationInfo accountInformationLoadingError;
    private final Function2<GithubAccount, Component, Pair<Boolean, Set<String>>> accountInformationSupplier;

    private final void switchAccount(GithubAccount account) {
        try {
            this.accountInformationLoadingError = null;
            Window window = this.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
            Object object = this.accountInformationSupplier.invoke((Object)account, (Object)window);
            boolean bl = false;
            boolean bl2 = false;
            Pair it = (Pair)object;
            boolean bl3 = false;
            this.privateCheckBox.setEnabled(((Boolean)it.getFirst()).booleanValue());
            if (!((Boolean)it.getFirst()).booleanValue()) {
                this.privateCheckBox.setToolTipText(GithubBundle.message("share.error.private.repos.not.supported", new Object[0]));
            } else {
                this.privateCheckBox.setToolTipText((String)null);
            }
            this.existingRepoValidator.setRecords((Set)it.getSecond());
        }
        catch (Exception e) {
            String errorText = GithubBundle.message("share.dialog.account.info.load.error.prefix", account) + (e instanceof ProcessCanceledException ? GithubBundle.message("share.dialog.account.info.load.process.canceled", new Object[0]) : e.getMessage());
            this.accountInformationLoadingError = new ValidationInfo(errorText);
            this.privateCheckBox.setEnabled(false);
            this.privateCheckBox.setToolTipText((String)null);
            this.existingRepoValidator.setRecords(SetsKt.emptySet());
            this.startTrackingValidation();
        }
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)GithubBundle.message("share.dialog.repo.name", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GithubShareDialog this$0;
            {
                this.this$0 = githubShareDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Row this_$iv = $this$row;
                boolean isVerticalFlow$iv = false;
                boolean isFullWidth$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                boolean bl = false;
                Cell.invoke$default((Cell)$this$cell, (JComponent)((JComponent)GithubShareDialog.access$getRepositoryTextField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$cell.getGrowX(), $this$cell.getPushX()}, null, null, (int)6, null);
                Cell.invoke$default((Cell)$this$cell, (JComponent)((JComponent)GithubShareDialog.access$getPrivateCheckBox$p(this.this$0)), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }), (int)2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)GithubBundle.message("share.dialog.remote", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GithubShareDialog this$0;
            {
                this.this$0 = githubShareDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)GithubShareDialog.access$getRemoteTextField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getGrowX(), $this$row.getPushX()}, null, null, (int)6, null);
            }
        }), (int)2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)GithubBundle.message("share.dialog.description", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GithubShareDialog this$0;
            {
                this.this$0 = githubShareDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                $this$row.scrollPane((Component)GithubShareDialog.access$getDescriptionTextArea$p(this.this$0));
            }
        }), (int)2, null);
        if (this.accountSelector.isEnabled()) {
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)GithubBundle.message("share.dialog.share.by", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ GithubShareDialog this$0;
                {
                    this.this$0 = githubShareDialog;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                    Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)((Object)GithubShareDialog.access$getAccountSelector$p(this.this$0))), (CCFlags[])new CCFlags[]{$this$row.getGrowX(), $this$row.getPushX()}, null, null, (int)6, null);
                }
            }), (int)2, null);
        }
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        return panel$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void $this$mapNotNullTo$iv$iv;
        Function0 repositoryNamePatternMatchValidator2 = (Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubShareDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return !GithubShareDialog.access$getGITHUB_REPO_PATTERN$p(this.this$0).matcher(GithubShareDialog.access$getRepositoryTextField$p(this.this$0).getText()).matches() ? new ValidationInfo(GithubBundle.message("share.validation.invalid.repo.name", new Object[0]), (JComponent)GithubShareDialog.access$getRepositoryTextField$p(this.this$0)) : null;
            }
            {
                this.this$0 = githubShareDialog;
                super(0);
            }
        };
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])new Function0[]{(Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubShareDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return GithubShareDialog.access$getAccountInformationLoadingError$p(this.this$0);
            }
            {
                this.this$0 = githubShareDialog;
                super(0);
            }
        }, DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubShareDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                JTextField jTextField = (JTextField)GithubShareDialog.access$getRepositoryTextField$p(this.this$0);
                String string = GithubBundle.message("share.validation.no.repo.name", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"sh\u2026validation.no.repo.name\")");
                return DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
            }
            {
                this.this$0 = githubShareDialog;
                super(0);
            }
        }, repositoryNamePatternMatchValidator2, this.existingRepoValidator), DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubShareDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                JTextField jTextField = (JTextField)GithubShareDialog.access$getRemoteTextField$p(this.this$0);
                String string = GithubBundle.message("share.validation.no.remote.name", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"sh\u2026lidation.no.remote.name\")");
                return DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
            }
            {
                this.this$0 = githubShareDialog;
                super(0);
            }
        }, this.existingRemoteValidator)});
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo validationInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Function0 it = (Function0)element$iv$iv;
            boolean bl2 = false;
            if ((ValidationInfo)it.invoke() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ValidationInfo it$iv$iv = validationInfo;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected String getHelpId() {
        return "github.share";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.ShareDialog";
    }

    @NotNull
    public JBTextField getPreferredFocusedComponent() {
        return this.repositoryTextField;
    }

    @NotNull
    public final String getRepositoryName() {
        String string = this.repositoryTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repositoryTextField.text");
        return string;
    }

    @NotNull
    public final String getRemoteName() {
        String string = this.remoteTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remoteTextField.text");
        return string;
    }

    public final boolean isPrivate() {
        return this.privateCheckBox.isSelected();
    }

    @NotNull
    public final String getDescription() {
        String string = this.descriptionTextArea.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptionTextArea.text");
        return string;
    }

    @NotNull
    public final GithubAccount getAccount() {
        Object object = this.accountSelector.getSelectedItem();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.github.authentication.accounts.GithubAccount");
        }
        return (GithubAccount)object;
    }

    public final void testSetRepositoryName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.repositoryTextField.setText(name);
    }

    public GithubShareDialog(@NotNull Project project, @NotNull Set<? extends GithubAccount> accounts, @Nullable GithubAccount defaultAccount, @NotNull Set<String> existingRemotes, @NotNull Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>> accountInformationSupplier) {
        DialogValidationUtils.RecordUniqueValidator recordUniqueValidator;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
        Intrinsics.checkParameterIsNotNull(existingRemotes, (String)"existingRemotes");
        Intrinsics.checkParameterIsNotNull(accountInformationSupplier, (String)"accountInformationSupplier");
        super(project);
        this.accountInformationSupplier = accountInformationSupplier;
        this.GITHUB_REPO_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");
        this.repositoryTextField = new JBTextField(project.getName());
        this.privateCheckBox = new JBCheckBox(GithubBundle.message("share.dialog.private", new Object[0]), false);
        this.remoteTextField = new JBTextField(existingRemotes.isEmpty() ? "origin" : "github");
        this.descriptionTextArea = new JTextArea();
        this.accountSelector = new GithubAccountCombobox(accounts, defaultAccount, (Function1<? super GithubAccount, Unit>)((Function1)new Function1<GithubAccount, Unit>(this){
            final /* synthetic */ GithubShareDialog this$0;

            public final void invoke(@NotNull GithubAccount it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GithubShareDialog.access$switchAccount(this.this$0, it);
            }
            {
                this.this$0 = githubShareDialog;
                super(1);
            }
        }));
        JTextField jTextField = (JTextField)this.repositoryTextField;
        String string = GithubBundle.message("share.error.repo.with.selected.name.exists", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"sh\u2026th.selected.name.exists\")");
        this.existingRepoValidator = new DialogValidationUtils.RecordUniqueValidator(jTextField, string);
        JTextField jTextField2 = (JTextField)this.remoteTextField;
        String string2 = GithubBundle.message("share.error.remote.with.selected.name.exists", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GithubBundle.message(\"sh\u2026th.selected.name.exists\")");
        DialogValidationUtils.RecordUniqueValidator recordUniqueValidator2 = new DialogValidationUtils.RecordUniqueValidator(jTextField2, string2);
        GithubShareDialog githubShareDialog = this;
        boolean bl = false;
        boolean bl2 = false;
        DialogValidationUtils.RecordUniqueValidator $this$apply = recordUniqueValidator2;
        boolean bl3 = false;
        $this$apply.setRecords(existingRemotes);
        githubShareDialog.existingRemoteValidator = recordUniqueValidator = recordUniqueValidator2;
        this.setTitle(GithubBundle.message("share.on.github", new Object[0]));
        this.setOKButtonText(GithubBundle.message("share.button", new Object[0]));
        this.init();
        DialogUtils.invokeLaterAfterDialogShown((DialogWrapper)this, (Runnable)new Runnable(){

            @Override
            public final void run() {
                Object object = accountSelector.getSelectedItem();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.github.authentication.accounts.GithubAccount");
                }
                this.switchAccount((GithubAccount)object);
            }
        });
    }

    public static final /* synthetic */ JBTextField access$getRepositoryTextField$p(GithubShareDialog $this) {
        return $this.repositoryTextField;
    }

    public static final /* synthetic */ JBCheckBox access$getPrivateCheckBox$p(GithubShareDialog $this) {
        return $this.privateCheckBox;
    }

    public static final /* synthetic */ JBTextField access$getRemoteTextField$p(GithubShareDialog $this) {
        return $this.remoteTextField;
    }

    public static final /* synthetic */ JTextArea access$getDescriptionTextArea$p(GithubShareDialog $this) {
        return $this.descriptionTextArea;
    }

    public static final /* synthetic */ Pattern access$getGITHUB_REPO_PATTERN$p(GithubShareDialog $this) {
        return $this.GITHUB_REPO_PATTERN;
    }

    public static final /* synthetic */ ValidationInfo access$getAccountInformationLoadingError$p(GithubShareDialog $this) {
        return $this.accountInformationLoadingError;
    }

    public static final /* synthetic */ void access$setAccountInformationLoadingError$p(GithubShareDialog $this, ValidationInfo validationInfo) {
        $this.accountInformationLoadingError = validationInfo;
    }
}

