/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.util.GithubSettings;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "", "()V", "findRemote", "Lgit4idea/repo/GitRemote;", "repository", "Lgit4idea/repo/GitRepository;", "httpUrl", "", "sshUrl", "getRemoteUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "user", "repo", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "Companion", "intellij.vcs.github"})
public final class GithubGitHelper {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)repoPath, (String)"repoPath");
        return this.getRemoteUrl(server, repoPath.getOwner(), repoPath.getRepository());
    }

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull String user, @NotNull String repo) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        GithubSettings githubSettings = GithubSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubSettings, (String)"GithubSettings.getInstance()");
        if (githubSettings.isCloneGitUsingSsh()) {
            String string2;
            String string3;
            StringBuilder stringBuilder;
            int n;
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder().append("git@").append(server.getHost()).append(':');
            String string5 = server.getSuffix();
            if (string5 != null) {
                string4 = string5;
                n = 1;
                stringBuilder = stringBuilder2;
                boolean bl = false;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string3 = string7;
                stringBuilder2 = stringBuilder;
                string2 = string3;
            } else {
                string2 = null;
            }
            string4 = string2;
            stringBuilder = stringBuilder2;
            n = 0;
            String string8 = string4;
            if (string8 == null) {
                string8 = "";
            }
            string3 = string8;
            string = stringBuilder.append(string3).append('/').append(user).append('/').append(repo).append(".git").toString();
        } else {
            String string9 = server.getSuffix();
            StringBuilder stringBuilder = new StringBuilder().append("https://").append(server.getHost());
            boolean bl = false;
            String string10 = string9;
            if (string10 == null) {
                string10 = "";
            }
            String string11 = string10;
            string = stringBuilder.append(string11).append('/').append(user).append('/').append(repo).append(".git").toString();
        }
        return string;
    }

    @Nullable
    public final GitRemote findRemote(@NotNull GitRepository repository, @Nullable String httpUrl, @Nullable String sshUrl) {
        Object v2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            Collection collection = repository.getRemotes();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"repository.remotes");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                GitRemote it = (GitRemote)t;
                boolean bl3 = false;
                GitRemote gitRemote = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote, (String)"it");
                if (!(gitRemote.getFirstUrl() != null && (Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)httpUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)Intrinsics.stringPlus((String)httpUrl, (Object)".git")) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)sshUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)Intrinsics.stringPlus((String)sshUrl, (Object)".git"))))) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @JvmStatic
    @Nullable
    public static final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        return Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @NotNull
    public static final GithubGitHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper$Companion;", "", "()V", "findGitRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
            GitRepository repository;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepositoryManager, (String)"GitUtil.getRepositoryManager(project)");
            GitRepositoryManager manager = gitRepositoryManager;
            List list2 = manager.getRepositories();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"manager.repositories");
            List repositories = list2;
            if (repositories.size() == 0) {
                return null;
            }
            if (repositories.size() == 1) {
                return (GitRepository)repositories.get(0);
            }
            if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
                return repository;
            }
            return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
        }

        public static /* synthetic */ GitRepository findGitRepository$default(Companion companion, Project project, VirtualFile virtualFile, int n, Object object) {
            if ((n & 2) != 0) {
                virtualFile = null;
            }
            return companion.findGitRepository(project, virtualFile);
        }

        @JvmStatic
        @NotNull
        public final GithubGitHelper getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(GithubGitHelper.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (GithubGitHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

