/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMissingFilesAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        List files;
        if (e == null) {
            AbstractMissingFilesAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (files = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY)) != null && !files.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractMissingFilesAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        List files = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        if (files == null) {
            return;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action = () -> {
            ArrayList allExceptions = new ArrayList();
            ChangesUtil.processFilePathsByVcs((Project)project, (Collection)files, (vcs, items) -> {
                List<VcsException> exceptions = this.processFiles(vcs, files);
                if (exceptions != null) {
                    allExceptions.addAll(exceptions);
                }
            });
            for (FilePath file : files) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
            }
            ChangesViewManager.getInstance(project).scheduleRefresh();
            if (allExceptions.size() > 0) {
                AbstractVcsHelper.getInstance((Project)project).showErrors(allExceptions, "VCS Errors");
            }
        };
        if (this.synchronously()) {
            action.run();
        } else {
            progressManager.runProcessWithProgressSynchronously(action, this.getName(), true, project);
        }
    }

    protected abstract boolean synchronously();

    protected abstract String getName();

    protected abstract List<VcsException> processFiles(AbstractVcs var1, List<FilePath> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/AbstractMissingFilesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

