/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.AbstractChangeListAction;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.actions.RemoveChangeListAction$WhenMappings;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0002J,\u0010\u0014\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u001e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RemoveChangeListAction;", "Lcom/intellij/openapi/vcs/changes/actions/AbstractChangeListAction;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "askNewDefaultChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "project", "Lcom/intellij/openapi/project/Project;", "lists", "", "remainingLists", "canRemoveChangeLists", "", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "confirmAllChangeListsRemoval", "pendingLists", "toAsk", "confirmChangeListRemoval", "deleteLists", "", "update", "intellij.platform.vcs.impl"})
public final class RemoveChangeListAction
extends AbstractChangeListAction {
    private final Logger LOG;

    public void update(@NotNull AnActionEvent e) {
        boolean hasChanges;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object[] changeListsArray = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        Object object = changeListsArray;
        if (changeListsArray == null || (object = ArraysKt.asList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object changeLists = object;
        boolean enabled = this.canRemoveChangeLists(e.getProject(), (List<? extends ChangeList>)changeLists);
        AbstractChangeListAction.updateEnabledAndVisible$default(this, e, enabled, false, 4, null);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        Presentation presentation2 = presentation;
        presentation2.setText(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.text.template", (Object[])new Object[]{changeLists.size()}));
        boolean bl = hasChanges = !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        if (hasChanges) {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = (Iterable)changeLists;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ChangeList it = (ChangeList)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof LocalChangeList && ((LocalChangeList)it).isDefault())) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            boolean containsActiveChangelist = bl2;
            presentation2.setDescription(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.description.template", (Object[])new Object[]{changeLists.size(), containsActiveChangelist ? "another" : "default"}));
        } else {
            presentation2.setDescription((String)null);
        }
    }

    private final boolean canRemoveChangeLists(Project project, List<? extends ChangeList> lists) {
        if (project == null || lists.isEmpty()) {
            return false;
        }
        for (ChangeList changeList : lists) {
            if (!(changeList instanceof LocalChangeList)) {
                return false;
            }
            if (!((LocalChangeList)changeList).isReadOnly()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        Object object2 = e.getRequiredData(VcsDataKeys.CHANGE_LISTS);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"e.getRequiredData(VcsDataKeys.CHANGE_LISTS)");
        ChangeList[] selectedLists = (ChangeList[])object2;
        List<ChangeList> list = Arrays.asList(Arrays.copyOf(selectedLists, selectedLists.length));
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<com.intellij.openapi.vcs.changes.LocalChangeList>");
        }
        this.deleteLists(project, (Collection<? extends LocalChangeList>)list);
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteLists(Project project, Collection<? extends LocalChangeList> lists) {
        boolean activeChangelistSelected;
        List pendingLists;
        List toAsk;
        List toRemove;
        ChangeListManagerEx manager;
        block23: {
            boolean bl;
            void $this$mapNotNullTo$iv$iv;
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            if (changeListManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ChangeListManagerEx");
            }
            manager = (ChangeListManagerEx)changeListManager;
            boolean bl2 = false;
            toRemove = new ArrayList();
            boolean bl3 = false;
            toAsk = new ArrayList();
            Iterable $this$mapNotNull$iv = lists;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                LocalChangeList localChangeList;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                LocalChangeList it = (LocalChangeList)element$iv$iv;
                boolean bl5 = false;
                if (manager.getChangeList(it.getId()) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                LocalChangeList it$iv$iv = localChangeList;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterator iterator3 = ((List)destination$iv$iv).iterator();
            while (iterator3.hasNext()) {
                LocalChangeList list;
                LocalChangeList localChangeList = list = (LocalChangeList)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"list");
                switch (RemoveChangeListAction$WhenMappings.$EnumSwitchMapping$0[ChangeListRemoveConfirmation.INSTANCE.checkCanDeleteChangelist(project, localChangeList, true).ordinal()]) {
                    case 1: {
                        toAsk.add(list);
                        break;
                    }
                    case 2: {
                        toRemove.add(list);
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
            }
            pendingLists = CollectionsKt.plus((Collection)toAsk, (Iterable)toRemove);
            Iterable $this$any$iv = pendingLists;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl9 = false;
                    if (!it.isDefault()) continue;
                    bl = true;
                    break block23;
                }
                bl = activeChangelistSelected = false;
            }
        }
        if (activeChangelistSelected) {
            List list = manager.getChangeLists();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"manager.changeLists");
            List remainingLists = CollectionsKt.toList((Iterable)CollectionsKt.subtract((Iterable)list, (Iterable)pendingLists));
            if (remainingLists.isEmpty()) {
                if (!this.confirmAllChangeListsRemoval(project, pendingLists, toAsk)) {
                    return;
                }
                LocalChangeList defaultList = manager.getChangeList(LocalChangeList.getDefaultName());
                if (defaultList == null) {
                    defaultList = manager.addChangeList(LocalChangeList.getDefaultName(), null);
                } else {
                    manager.editComment(defaultList.getName(), null);
                    manager.editChangeListData(defaultList.getName(), null);
                }
                LocalChangeList localChangeList = defaultList;
                if (localChangeList == null) {
                    Intrinsics.throwNpe();
                }
                manager.setDefaultChangeList(localChangeList);
                toRemove.addAll(toAsk);
                toRemove.remove(defaultList);
            } else {
                LocalChangeList localChangeList = this.askNewDefaultChangeList(project, toAsk, remainingLists);
                if (localChangeList == null) {
                    return;
                }
                LocalChangeList newDefault = localChangeList;
                manager.setDefaultChangeList(newDefault);
                toRemove.addAll(toAsk);
                if (toRemove.remove(newDefault)) {
                    this.LOG.error("New default changelist should be selected among remaining");
                }
            }
        } else if (this.confirmChangeListRemoval(project, toAsk)) {
            toRemove.addAll(toAsk);
        }
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalChangeList it = (LocalChangeList)element$iv;
            boolean bl = false;
            manager.removeChangeList(it.getName());
        }
    }

    private final boolean confirmChangeListRemoval(Project project, List<? extends LocalChangeList> lists) {
        boolean haveNoChanges;
        block4: {
            boolean bl;
            Iterable $this$all$iv = lists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl2 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block4;
                }
                bl = haveNoChanges = true;
            }
        }
        if (haveNoChanges) {
            return true;
        }
        String string = lists.size() == 1 ? VcsBundle.message((String)"changes.removechangelist.warning.text", (Object[])new Object[]{((LocalChangeList)CollectionsKt.single(lists)).getName()}) : VcsBundle.message((String)"changes.removechangelist.multiple.warning.text", (Object[])new Object[]{lists.size()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (lists.size == 1)\n   \u2026arning.text\", lists.size)");
        String message = string;
        return Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private final boolean confirmAllChangeListsRemoval(Project project, List<? extends LocalChangeList> pendingLists, List<? extends LocalChangeList> toAsk) {
        boolean haveNoChanges;
        block6: {
            boolean bl;
            if (pendingLists.size() == 1) {
                return true;
            }
            if (toAsk.isEmpty()) {
                return true;
            }
            Iterable $this$all$iv = pendingLists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl2 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block6;
                }
                bl = haveNoChanges = true;
            }
        }
        if (haveNoChanges) {
            return true;
        }
        String string = VcsBundle.message((String)"changes.removechangelist.all.lists.warning.text", (Object[])new Object[]{pendingLists.size()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VcsBundle.message(\"chang\u2026text\", pendingLists.size)");
        String message = string;
        return Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final LocalChangeList askNewDefaultChangeList(Project project, List<? extends LocalChangeList> lists, List<? extends LocalChangeList> remainingLists) {
        void $this$mapTo$iv$iv;
        boolean haveNoChanges;
        Object element$iv2;
        block8: {
            boolean bl;
            Collection collection = remainingLists;
            boolean bl2 = false;
            boolean bl3 = !collection.isEmpty();
            bl2 = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl3) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $this$all$iv = lists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv2;
                    boolean bl6 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block8;
                }
                bl = haveNoChanges = true;
            }
        }
        if (remainingLists.size() == 1 && haveNoChanges) {
            return (LocalChangeList)CollectionsKt.single(remainingLists);
        }
        Iterable $this$map$iv = remainingLists;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalChangeList localChangeList = (LocalChangeList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] remainingListsNames = objectArray;
        String string = haveNoChanges ? VcsBundle.message((String)"changes.remove.active.empty.prompt", (Object[])new Object[0]) : VcsBundle.message((String)"changes.remove.active.prompt", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (haveNoChanges)\n     \u2026es.remove.active.prompt\")");
        String message = string;
        int nameIndex = Messages.showChooseDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.remove.active.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])remainingListsNames, (String)((String)ArraysKt.first((Object[])remainingListsNames)));
        if (nameIndex < 0) {
            return null;
        }
        return remainingLists.get(nameIndex);
    }

    public RemoveChangeListAction() {
        Logger logger;
        RemoveChangeListAction removeChangeListAction = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(RemoveChangeListAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        removeChangeListAction.LOG = logger = logger2;
    }
}

