/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffChangeUi;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalTrackerDiffUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedLocalChangeListDiffViewer
extends UnifiedDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest myLocalRequest;
    private final boolean myAllowExcludeChangesFromCommit;
    private final LocalTrackerDiffUtil.LocalTrackerActionProvider myTrackerActionProvider;
    private LocalTrackerDiffUtil.ExcludeAllCheckboxPanel myExcludeAllCheckboxPanel;

    public UnifiedLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        if (context == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(0);
        }
        if (localRequest == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (DiffRequest)localRequest.getRequest());
        this.myLocalRequest = localRequest;
        this.myAllowExcludeChangesFromCommit = DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder[])new UserDataHolder[]{context});
        this.myTrackerActionProvider = new MyLocalTrackerActionProvider(this, localRequest, this.myAllowExcludeChangesFromCommit);
        this.myExcludeAllCheckboxPanel.init(this.myLocalRequest, this.myAllowExcludeChangesFromCommit);
        LocalTrackerDiffUtil.installTrackerListener((DiffViewerBase)this, this.myLocalRequest);
    }

    @Nullable
    protected JComponent createTitles() {
        JComponent titles = super.createTitles();
        this.myExcludeAllCheckboxPanel = new LocalTrackerDiffUtil.ExcludeAllCheckboxPanel((DiffViewerBase)this, this.getEditor());
        BorderLayoutPanel titleWithCheckbox = JBUI.Panels.simplePanel();
        if (titles != null) {
            titleWithCheckbox.addToCenter((Component)titles);
        }
        titleWithCheckbox.addToLeft((Component)this.myExcludeAllCheckboxPanel);
        return titleWithCheckbox;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(super.createEditorPopupActions());
        group.addAll(LocalTrackerDiffUtil.createTrackerActions(this.myTrackerActionProvider));
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected UnifiedDiffChangeUi createUi(@NotNull UnifiedDiffChange change) {
        if (change == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(3);
        }
        if (change instanceof MyUnifiedDiffChange) {
            return new MyUnifiedDiffChangeUi(this, (MyUnifiedDiffChange)change);
        }
        UnifiedDiffChangeUi unifiedDiffChangeUi = super.createUi(change);
        if (unifiedDiffChangeUi == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(4);
        }
        return unifiedDiffChangeUi;
    }

    @NotNull
    private Runnable superComputeDifferences(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(5);
        }
        Runnable runnable = super.computeDifferences(indicator);
        if (runnable == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(7);
        }
        Document document1 = this.getContent1().getDocument();
        Document document2 = this.getContent2().getDocument();
        Runnable runnable = LocalTrackerDiffUtil.computeDifferences(this.myLocalRequest.getLineStatusTracker(), document1, document2, this.myLocalRequest.getChangelistId(), (TwosideTextDiffProvider)this.myTextDiffProvider, indicator, new MyLocalTrackerDiffHandler(document1, document2, indicator));
        if (runnable == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(8);
        }
        return runnable;
    }

    protected void onAfterRediff() {
        super.onAfterRediff();
        this.myExcludeAllCheckboxPanel.refresh();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRequest";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "superComputeDifferences";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDifferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUi";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "superComputeDifferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeDifferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLocalTrackerActionProvider
    extends LocalTrackerDiffUtil.LocalTrackerActionProvider {
        @NotNull
        private final UnifiedLocalChangeListDiffViewer myViewer;

        private MyLocalTrackerActionProvider(@NotNull UnifiedLocalChangeListDiffViewer viewer, @NotNull LocalChangeListDiffRequest localRequest, boolean allowExcludeChangesFromCommit) {
            if (viewer == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(0);
            }
            if (localRequest == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(1);
            }
            super((DiffViewerBase)viewer, localRequest, allowExcludeChangesFromCommit);
            this.myViewer = viewer;
        }

        @Override
        @Nullable
        public List<LocalTrackerDiffUtil.LocalTrackerChange> getSelectedTrackerChanges(@NotNull AnActionEvent e) {
            if (e == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(2);
            }
            if (!this.myViewer.isContentGood()) {
                return null;
            }
            return StreamEx.of((Collection)this.myViewer.getSelectedChanges()).select(MyUnifiedDiffChange.class).map(it -> new LocalTrackerDiffUtil.LocalTrackerChange(this.myViewer.transferLineFromOneside(Side.RIGHT, it.getLine1()), this.myViewer.transferLineFromOneside(Side.RIGHT, it.getLine2()), ((MyUnifiedDiffChange)it).myChangelistId, ((MyUnifiedDiffChange)it).myIsExcludedFromCommit)).toList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRequest";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyLocalTrackerActionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedTrackerChanges";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyUnifiedDiffChangeUi
    extends UnifiedDiffChangeUi {
        private MyUnifiedDiffChangeUi(@NotNull UnifiedLocalChangeListDiffViewer viewer, @NotNull MyUnifiedDiffChange change) {
            if (viewer == null) {
                MyUnifiedDiffChangeUi.$$$reportNull$$$0(0);
            }
            if (change == null) {
                MyUnifiedDiffChangeUi.$$$reportNull$$$0(1);
            }
            super((UnifiedDiffViewer)viewer, (UnifiedDiffChange)change);
        }

        @NotNull
        private UnifiedLocalChangeListDiffViewer getViewer() {
            UnifiedLocalChangeListDiffViewer unifiedLocalChangeListDiffViewer = (UnifiedLocalChangeListDiffViewer)this.myViewer;
            if (unifiedLocalChangeListDiffViewer == null) {
                MyUnifiedDiffChangeUi.$$$reportNull$$$0(2);
            }
            return unifiedLocalChangeListDiffViewer;
        }

        @NotNull
        private MyUnifiedDiffChange getChange() {
            MyUnifiedDiffChange myUnifiedDiffChange = (MyUnifiedDiffChange)this.myChange;
            if (myUnifiedDiffChange == null) {
                MyUnifiedDiffChangeUi.$$$reportNull$$$0(3);
            }
            return myUnifiedDiffChange;
        }

        protected void doInstallActionHighlighters() {
            if (this.getViewer().myAllowExcludeChangesFromCommit) {
                ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createExcludeOperation());
            }
            super.doInstallActionHighlighters();
        }

        @Nullable
        private DiffGutterOperation createExcludeOperation() {
            if (!this.getChange().isFromActiveChangelist()) {
                return null;
            }
            return this.createOperation(() -> {
                final boolean isExcludedFromCommit = this.getChange().isExcludedFromCommit();
                Icon icon2 = isExcludedFromCommit ? AllIcons.Diff.GutterCheckBox : AllIcons.Diff.GutterCheckBoxSelected;
                return new DiffGutterRenderer(icon2, DiffBundle.message((String)"action.presentation.diff.include.into.commit.text", (Object[])new Object[0])){

                    protected void handleMouseClick() {
                        if (!this.getViewer().isContentGood()) {
                            return;
                        }
                        int line = myViewer.transferLineFromOneside(Side.RIGHT, myChange.getLine1());
                        LocalTrackerDiffUtil.toggleRangeAtLine(this.getViewer().myTrackerActionProvider, line, isExcludedFromCommit);
                    }
                };
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedDiffChangeUi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedDiffChangeUi";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyUnifiedDiffChange
    extends UnifiedDiffChange {
        @NotNull
        private final String myChangelistId;
        private final boolean myIsFromActiveChangelist;
        private final boolean myIsExcludedFromCommit;

        private MyUnifiedDiffChange(int blockStart, int insertedStart, int blockEnd, @NotNull LineFragment lineFragment, boolean isExcluded, boolean isSkipped, @NotNull String changelistId, boolean isFromActiveChangelist, boolean isExcludedFromCommit) {
            if (lineFragment == null) {
                MyUnifiedDiffChange.$$$reportNull$$$0(0);
            }
            if (changelistId == null) {
                MyUnifiedDiffChange.$$$reportNull$$$0(1);
            }
            super(blockStart, insertedStart, blockEnd, lineFragment, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsFromActiveChangelist = isFromActiveChangelist;
            this.myIsExcludedFromCommit = isExcludedFromCommit;
        }

        @NotNull
        public String getChangelistId() {
            String string = this.myChangelistId;
            if (string == null) {
                MyUnifiedDiffChange.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isFromActiveChangelist() {
            return this.myIsFromActiveChangelist;
        }

        public boolean isExcludedFromCommit() {
            return this.myIsExcludedFromCommit;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineFragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changelistId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedDiffChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedDiffChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangelistId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyUnifiedFragmentBuilder
    extends UnifiedFragmentBuilder {
        @NotNull
        private final List<LocalTrackerDiffUtil.LineFragmentData> myFragmentsData;

        MyUnifiedFragmentBuilder(@NotNull List<? extends LineFragment> fragments, @NotNull List<LocalTrackerDiffUtil.LineFragmentData> fragmentsData, @NotNull Document document1, Document document2) {
            if (fragments == null) {
                MyUnifiedFragmentBuilder.$$$reportNull$$$0(0);
            }
            if (fragmentsData == null) {
                MyUnifiedFragmentBuilder.$$$reportNull$$$0(1);
            }
            if (document1 == null) {
                MyUnifiedFragmentBuilder.$$$reportNull$$$0(2);
            }
            if (document2 == null) {
                MyUnifiedFragmentBuilder.$$$reportNull$$$0(3);
            }
            super(fragments, document1, document2, UnifiedLocalChangeListDiffViewer.this.myMasterSide);
            this.myFragmentsData = fragmentsData;
        }

        @NotNull
        protected UnifiedDiffChange createDiffChange(int blockStart, int insertedStart, int blockEnd, int fragmentIndex) {
            LineFragment fragment = (LineFragment)this.myFragments.get(fragmentIndex);
            LocalTrackerDiffUtil.LineFragmentData data = this.myFragmentsData.get(fragmentIndex);
            boolean isSkipped = data.isSkipped();
            boolean isExcluded = data.isExcluded(UnifiedLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit);
            return new MyUnifiedDiffChange(blockStart, insertedStart, blockEnd, fragment, isExcluded, isSkipped, data.getChangelistId(), data.isFromActiveChangelist(), data.isExcludedFromCommit());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragmentsData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedFragmentBuilder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyLocalTrackerDiffHandler
    implements LocalTrackerDiffUtil.LocalTrackerDiffHandler {
        @NotNull
        private final Document myDocument1;
        @NotNull
        private final Document myDocument2;
        @NotNull
        private final ProgressIndicator myIndicator;

        private MyLocalTrackerDiffHandler(@NotNull Document document1, @NotNull Document document2, ProgressIndicator indicator) {
            if (document1 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(0);
            }
            if (document2 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(2);
            }
            this.myDocument1 = document1;
            this.myDocument2 = document2;
            this.myIndicator = indicator;
        }

        @Override
        @NotNull
        public Runnable done(boolean isContentsEqual, CharSequence @NotNull [] texts, @NotNull List<? extends LineFragment> fragments, @NotNull List<LocalTrackerDiffUtil.LineFragmentData> fragmentsData) {
            if (fragments == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(3);
            }
            if (fragmentsData == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(4);
            }
            if (texts == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(5);
            }
            UnifiedFragmentBuilder builder = (UnifiedFragmentBuilder)ReadAction.compute(() -> {
                this.myIndicator.checkCanceled();
                return new MyUnifiedFragmentBuilder(fragments, fragmentsData, this.myDocument1, this.myDocument2).exec();
            });
            Runnable runnable = UnifiedLocalChangeListDiffViewer.this.apply(builder, texts, this.myIndicator);
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(6);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable retryLater() {
            UnifiedLocalChangeListDiffViewer.this.scheduleRediff();
            throw new ProcessCanceledException();
        }

        @Override
        @NotNull
        public Runnable fallback() {
            Runnable runnable = UnifiedLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(7);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable fallbackWithProgress() {
            Runnable callback2 = UnifiedLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            Runnable runnable = () -> {
                callback2.run();
                UnifiedLocalChangeListDiffViewer.this.getStatusPanel().setBusy(true);
            };
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(8);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable error() {
            Runnable runnable = UnifiedLocalChangeListDiffViewer.this.applyErrorNotification();
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(9);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragmentsData";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "texts";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyLocalTrackerDiffHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyLocalTrackerDiffHandler";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fallback";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fallbackWithProgress";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

