/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.VcsAwareCheckoutListener;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeCheckoutListener
implements CheckoutProvider.Listener {
    private final Project myProject;
    private boolean myFoundProject;
    private Path myFirstDirectory;
    private VcsKey myVcsKey;

    public CompositeCheckoutListener(@NotNull Project project) {
        if (project == null) {
            CompositeCheckoutListener.$$$reportNull$$$0(0);
        }
        this.myFoundProject = false;
        this.myProject = project;
    }

    public void directoryCheckedOut(@NotNull File directory, VcsKey vcs) {
        if (directory == null) {
            CompositeCheckoutListener.$$$reportNull$$$0(1);
        }
        this.myVcsKey = vcs;
        if (!this.myFoundProject && directory.isDirectory()) {
            if (this.myFirstDirectory == null) {
                this.myFirstDirectory = directory.toPath();
            }
            this.notifyCheckoutListeners(directory.toPath(), false);
        }
    }

    private void notifyCheckoutListeners(@NotNull Path directory, boolean checkoutCompleted) {
        Project project;
        if (directory == null) {
            CompositeCheckoutListener.$$$reportNull$$$0(2);
        }
        ExtensionPointName epName = checkoutCompleted ? CheckoutListener.COMPLETED_EP_NAME : CheckoutListener.EP_NAME;
        List listeners = epName.getExtensionList();
        for (CheckoutListener listener2 : listeners) {
            this.myFoundProject = listener2.processCheckedOutDirectory(this.myProject, directory);
            if (!this.myFoundProject) continue;
            break;
        }
        if (!checkoutCompleted) {
            VcsAwareCheckoutListener extension;
            boolean processingCompleted;
            Iterator iterator = VcsAwareCheckoutListener.EP_NAME.getExtensionList().iterator();
            while (iterator.hasNext() && !(processingCompleted = (extension = (VcsAwareCheckoutListener)iterator.next()).processCheckedOutDirectory(this.myProject, directory, this.myVcsKey))) {
            }
        }
        if ((project = CompositeCheckoutListener.findProjectByBaseDirLocation(directory)) != null) {
            for (CheckoutListener listener3 : listeners) {
                listener3.processOpenedProject(project);
            }
        }
    }

    public void checkoutCompleted() {
        if (!this.myFoundProject && this.myFirstDirectory != null) {
            this.notifyCheckoutListeners(this.myFirstDirectory, true);
        }
    }

    @Nullable
    static Project findProjectByBaseDirLocation(@NotNull Path directory) {
        if (directory == null) {
            CompositeCheckoutListener.$$$reportNull$$$0(3);
        }
        return (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), project -> {
            String baseDir = project.getBasePath();
            return baseDir != null && FileUtil.pathsEqual((String)baseDir, (String)directory.toString());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/checkout/CompositeCheckoutListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "directoryCheckedOut";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyCheckoutListeners";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findProjectByBaseDirLocation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

