/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.google.common.collect.Multiset;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsFreezingProcess;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictFileStatusProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager$restoreTrackersForPartiallyChangedFiles$;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager$startListenForEditors$;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.PartialLineStatusTrackerManagerState;
import com.intellij.openapi.vcs.impl.Result;
import com.intellij.openapi.vcs.impl.SingleThreadLoader;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.impl.VcsFileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u0000 `2\u00020\u00012\u00020\u0002:\u0014_`abcdefghijklmnopqrB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0014H\u0016J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0012\u0010)\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\fH\u0002J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0000\u00a2\u0006\u0002\b/J\b\u00100\u001a\u00020#H\u0016J\u001e\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u0001022\u0006\u0010'\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\fH\u0002J\b\u00103\u001a\u00020#H\u0002J\u0016\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u0001022\u0006\u0010+\u001a\u00020\fH\u0016J\u0016\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u0001022\u0006\u00105\u001a\u00020\u0014H\u0016J\u0010\u00106\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003020-J\b\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\fH\u0002J\u0010\u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020<H\u0016J\u001a\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020?2\b\u00105\u001a\u0004\u0018\u00010\u0014H\u0002J\u0015\u0010@\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bAJ\u0018\u0010B\u001a\u00020#2\u0006\u0010+\u001a\u00020\f2\u0006\u0010C\u001a\u00020DH\u0007J\b\u0010E\u001a\u00020#H\u0002J\u0010\u0010F\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0014\u0010G\u001a\u00020#2\n\u0010H\u001a\u0006\u0012\u0002\b\u00030IH\u0002J\u0010\u0010J\u001a\u00020#2\u0006\u0010K\u001a\u00020!H\u0002J\u0006\u0010L\u001a\u00020#J\u0010\u0010M\u001a\u00020#2\u0006\u0010+\u001a\u00020\fH\u0002J\u0018\u0010N\u001a\u00020#2\u0006\u0010+\u001a\u00020\f2\u0006\u0010O\u001a\u00020\u0007H\u0016J\u0018\u0010P\u001a\u00020#2\u0006\u0010+\u001a\u00020\f2\u0006\u0010O\u001a\u00020\u0007H\u0016J\u0010\u0010Q\u001a\u00020#2\u0006\u0010K\u001a\u00020!H\u0002J\u0006\u0010R\u001a\u00020#J\u0016\u0010S\u001a\u00020#2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00150-H\u0002J\u001a\u0010U\u001a\u00020\u001a2\b\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020WH\u0002J\b\u0010Y\u001a\u00020#H\u0002J\b\u0010Z\u001a\u00020#H\u0002J\u0010\u0010[\u001a\u00020#2\u0006\u0010K\u001a\u00020!H\u0002J\b\u0010\\\u001a\u00020#H\u0002J\u0006\u0010]\u001a\u00020#J\u001a\u0010^\u001a\u00020#2\u0006\u0010>\u001a\u00020?2\b\u0010+\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010^\u001a\u00020#2\u0006\u0010>\u001a\u00020?2\b\u00105\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00180\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020!0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOCK", "", "clmFreezeCounter", "", "documentsInDefaultChangeList", "Ljava/util/HashSet;", "Lcom/intellij/openapi/editor/Document;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "fileStatesAwaitingRefresh", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "filesWithDamagedInactiveRanges", "forcedDocuments", "Lcom/google/common/collect/Multiset;", "isDisposed", "", "loader", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "partialChangeListsEnabled", "trackers", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "addTrackerListener", "", "listener", "disposable", "arePartialChangelistsEnabled", "virtualFile", "canCreatePartialTrackerFor", "canGetBaseRevisionFor", "checkIfTrackerCanBeReleased", "document", "collectPartiallyChangedFilesStates", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$FullState;", "collectPartiallyChangedFilesStates$intellij_platform_vcs_impl", "dispose", "doInstallTracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "expireInactiveRangesDamagedNotifications", "getLineStatusTracker", "file", "getTrackers", "getTrackingMode", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "installTracker", "invokeAfterUpdate", "task", "Ljava/lang/Runnable;", "log", "message", "", "notifyInactiveRangesDamaged", "notifyInactiveRangesDamaged$intellij_platform_vcs_impl", "offerTrackerContent", "text", "", "onEverythingChanged", "onFileChanged", "refreshTracker", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "registerTrackerInCLM", "data", "releaseAllTrackers", "releaseTracker", "releaseTrackerFor", "requester", "requestTrackerFor", "reregisterTrackerInCLM", "resetExcludedFromCommitMarkers", "restoreTrackersForPartiallyChangedFiles", "trackerStates", "shouldBeUpdated", "oldInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "newInfo", "showInactiveRangesDamagedNotification", "startListenForEditors", "unregisterTrackerInCLM", "updateTrackingModes", "waitUntilBaseContentsLoaded", "warn", "CheckinFactory", "Companion", "ContentInfo", "InactiveRangesDamagedNotification", "Listener", "ListenerAdapter", "MyApplicationListener", "MyBaseRevisionLoader", "MyChangeListListener", "MyCommandListener", "MyDocumentListener", "MyEditorFactoryListener", "MyFileStatusListener", "MyFreezeListener", "MyLineStatusTrackerSettingListener", "MyStartupActivity", "MyVirtualFileListener", "RefreshData", "RefreshRequest", "TrackerData", "intellij.platform.vcs.impl"})
public final class LineStatusTrackerManager
implements LineStatusTrackerManagerI,
Disposable {
    private final Object LOCK;
    private boolean isDisposed;
    private final HashMap<Document, TrackerData> trackers;
    private final HashMap<Document, Multiset<Object>> forcedDocuments;
    private final EventDispatcher<Listener> eventDispatcher;
    private boolean partialChangeListsEnabled;
    private final HashSet<Document> documentsInDefaultChangeList;
    private int clmFreezeCounter;
    private final HashSet<VirtualFile> filesWithDamagedInactiveRanges;
    private final HashMap<VirtualFile, ChangelistsLocalLineStatusTracker.State> fileStatesAwaitingRefresh;
    private final SingleThreadLoader<RefreshRequest, RefreshData> loader;
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    private final void startListenForEditors() {
        Application app$iv;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection busConnection = messageBusConnection;
        busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, (Object)new MyLineStatusTrackerSettingListener());
        busConnection.subscribe(VcsFreezingProcess.Listener.TOPIC, (Object)new MyFreezeListener());
        busConnection.subscribe(CommandListener.TOPIC, (Object)new MyCommandListener());
        busConnection.subscribe(ChangeListListener.TOPIC, (Object)new MyChangeListListener());
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyVirtualFileListener());
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application2 = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"app");
        if (application2.isDispatchThread()) {
            boolean bl = false;
            if (!this.project.isDisposed()) {
                ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)this);
                FileStatusManager.getInstance((Project)this.project).addFileStatusListener((FileStatusListener)new MyFileStatusListener(), (Disposable)this);
                EditorFactory editorFactory = EditorFactory.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
                editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this);
                new MyEditorFactoryListener().install(this);
                this.onEverythingChanged();
                Project $this$service$iv = this.project;
                boolean $i$f$service = false;
                Object object = $this$service$iv.getService(PartialLineStatusTrackerManagerState.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
                List<ChangelistsLocalLineStatusTracker.State> states = ((PartialLineStatusTrackerManagerState)object).getStatesAndClear$intellij_platform_vcs_impl();
                Collection collection = states;
                boolean bl2 = false;
                if (!collection.isEmpty()) {
                    ChangeListManager.getInstance((Project)this.project).invokeAfterUpdate(new Runnable(states, this){
                        final /* synthetic */ List $states;
                        final /* synthetic */ LineStatusTrackerManager this$0;
                        {
                            this.$states = list;
                            this.this$0 = lineStatusTrackerManager;
                        }

                        public final void run() {
                            LineStatusTrackerManager.access$restoreTrackersForPartiallyChangedFiles(this.this$0, this.$states);
                        }
                    }, InvokeAfterUpdateMode.SILENT, null, null);
                }
            }
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ LineStatusTrackerManager this$0;
                {
                    this.this$0 = lineStatusTrackerManager;
                }

                public final void run() {
                    boolean bl = false;
                    if (!LineStatusTrackerManager.access$getProject$p(this.this$0).isDisposed()) {
                        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)this.this$0.new MyApplicationListener(), (Disposable)this.this$0);
                        FileStatusManager.getInstance((Project)LineStatusTrackerManager.access$getProject$p(this.this$0)).addFileStatusListener((FileStatusListener)this.this$0.new MyFileStatusListener(), (Disposable)this.this$0);
                        EditorFactory editorFactory = EditorFactory.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
                        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this.this$0.new MyDocumentListener(), (Disposable)this.this$0);
                        this.this$0.new MyEditorFactoryListener().install(this.this$0);
                        LineStatusTrackerManager.access$onEverythingChanged(this.this$0);
                        Project $this$service$iv = LineStatusTrackerManager.access$getProject$p(this.this$0);
                        boolean $i$f$service = false;
                        Object object = $this$service$iv.getService(PartialLineStatusTrackerManagerState.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
                        List<ChangelistsLocalLineStatusTracker.State> states = ((PartialLineStatusTrackerManagerState)object).getStatesAndClear$intellij_platform_vcs_impl();
                        Collection collection = states;
                        boolean bl2 = false;
                        if (!collection.isEmpty()) {
                            ChangeListManager.getInstance((Project)LineStatusTrackerManager.access$getProject$p(this.this$0)).invokeAfterUpdate(new Runnable(states, this){
                                final /* synthetic */ List $states;
                                final /* synthetic */ startListenForEditors$$inlined$runInEdt$1 this$0;
                                {
                                    this.$states = list;
                                    this.this$0 = var2_2;
                                }

                                public final void run() {
                                    LineStatusTrackerManager.access$restoreTrackersForPartiallyChangedFiles(this.this$0.this$0, this.$states);
                                }
                            }, InvokeAfterUpdateMode.SILENT, null, null);
                        }
                    }
                }
            }, ModalityState.defaultModalityState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void dispose() {
        this.isDisposed = true;
        Disposer.dispose((Disposable)this.loader);
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Map map2 = this.forcedDocuments;
            boolean bl4 = false;
            Iterator<Object> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl5 = false;
                map2 = (Document)entry2.getKey();
                entry2 = entry;
                bl5 = false;
                Multiset multiset2 = (Multiset)entry2.getValue();
                for (Object requester : multiset2.elementSet()) {
                    void document;
                    this.warn("Tracker is being held on dispose by " + requester, (Document)document);
                }
            }
            this.forcedDocuments.clear();
            iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                TrackerData data;
                TrackerData trackerData = data = (TrackerData)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)trackerData, (String)"data");
                this.unregisterTrackerInCLM(trackerData);
                data.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            TrackerData trackerData = this.trackers.get(document);
            LineStatusTracker lineStatusTracker = trackerData != null ? trackerData.getTracker() : null;
            return lineStatusTracker;
        }
    }

    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026ment(file) ?: return null");
        Document document2 = document;
        return this.getLineStatusTracker(document2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)requester, (String)"requester");
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Multiset<Object> multiset2 = this.forcedDocuments.computeIfAbsent(document, requestTrackerFor.1.multiset.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(multiset2, (String)"forcedDocuments.computeI\u2026hMultiset.create<Any>() }");
            Multiset<Object> multiset3 = multiset2;
            multiset3.add(requester);
            if (this.trackers.get(document) == null) {
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
                VirtualFile virtualFile2 = virtualFile;
                this.installTracker(virtualFile2, document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)requester, (String)"requester");
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Multiset<Object> multiset2 = this.forcedDocuments.get(document);
            if (multiset2 == null || !multiset2.contains(requester)) {
                this.warn("Tracker release underflow by " + requester, document);
                return;
            }
            multiset2.remove(requester);
            if (multiset2.isEmpty()) {
                this.forcedDocuments.remove(document);
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void invokeAfterUpdate(@NotNull Runnable task2) {
        Intrinsics.checkParameterIsNotNull((Object)task2, (String)"task");
        this.loader.addAfterUpdateRunnable(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<LineStatusTracker<?>> getTrackers() {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl3 = false;
            Collection<TrackerData> collection = this.trackers.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"trackers.values");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                LocalLineStatusTracker<?> localLineStatusTracker = it.getTracker();
                collection2.add(localLineStatusTracker);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    public final void addTrackerListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIfTrackerCanBeReleased(Document document) {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            TrackerData trackerData = this.trackers.get(document);
            if (trackerData == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)trackerData, (String)"trackers[document] ?: return");
            TrackerData data = trackerData;
            if (this.forcedDocuments.containsKey(document)) {
                return;
            }
            if (data.getTracker() instanceof ChangelistsLocalLineStatusTracker) {
                boolean hasPartialChanges = ((ChangelistsLocalLineStatusTracker)data.getTracker()).hasPartialState$intellij_platform_vcs_impl();
                if (hasPartialChanges) {
                    this.log("checkIfTrackerCanBeReleased - hasPartialChanges", data.getTracker().getVirtualFile());
                    return;
                }
                boolean isLoading = this.loader.hasRequest(new RefreshRequest(document));
                if (isLoading) {
                    this.log("checkIfTrackerCanBeReleased - isLoading", data.getTracker().getVirtualFile());
                    return;
                }
            }
            this.releaseTracker(document);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onEverythingChanged() {
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onEverythingChanged", null);
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (TrackerData data : this.trackers.values()) {
                files.add(data.getTracker().getVirtualFile());
            }
            for (Document document : this.forcedDocuments.keySet()) {
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                if (file == null) continue;
                files.add(file);
            }
            Iterator<TrackerData> iterator = files.iterator();
            while (iterator.hasNext()) {
                VirtualFile file;
                VirtualFile virtualFile = file = (VirtualFile)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                this.onFileChanged(virtualFile);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onFileChanged(VirtualFile virtualFile) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026nt(virtualFile) ?: return");
        Document document2 = document;
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            LocalLineStatusTracker<?> tracker;
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onFileChanged", virtualFile);
            TrackerData trackerData = this.trackers.get(document2);
            LocalLineStatusTracker<Object> localLineStatusTracker = tracker = trackerData != null ? trackerData.getTracker() : null;
            if (tracker == null) {
                if (this.forcedDocuments.containsKey(document2)) {
                    this.installTracker(virtualFile, document2);
                }
            } else {
                boolean isPartialTracker;
                boolean isPartialTrackerExpected = this.canCreatePartialTrackerFor(virtualFile);
                if (isPartialTrackerExpected == (isPartialTracker = tracker instanceof ChangelistsLocalLineStatusTracker)) {
                    this.refreshTracker(tracker);
                } else {
                    this.releaseTracker(document2);
                    this.installTracker(virtualFile, document2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"VcsUtil.getFilePath(tracker.virtualFile)");
        FilePath filePath2 = filePath;
        if (data.getClmFilePath() != null) {
            LOG.error("[registerTrackerInCLM] tracker already registered");
            return;
        }
        ChangeListManagerImpl.getInstanceImpl(this.project).registerChangeTracker(filePath2, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data.setClmFilePath(filePath2);
    }

    private final void unregisterTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath filePath = data.getClmFilePath();
        if (filePath == null) {
            LOG.error("[unregisterTrackerInCLM] tracker is not registered");
            return;
        }
        ChangeListManagerImpl.getInstanceImpl(this.project).unregisterChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data.setClmFilePath(null);
        FilePath filePath2 = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath2, (String)"VcsUtil.getFilePath(tracker.virtualFile)");
        FilePath actualFilePath = filePath2;
        if (Intrinsics.areEqual((Object)filePath, (Object)actualFilePath) ^ true) {
            LOG.error("[unregisterTrackerInCLM] unexpected file path: expected: " + filePath + ", actual: " + actualFilePath);
        }
    }

    private final void reregisterTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath oldFilePath = data.getClmFilePath();
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"VcsUtil.getFilePath(tracker.virtualFile)");
        FilePath newFilePath = filePath;
        if (oldFilePath == null) {
            LOG.error("[reregisterTrackerInCLM] tracker is not registered");
            return;
        }
        if (Intrinsics.areEqual((Object)oldFilePath, (Object)newFilePath) ^ true) {
            ChangeListManagerImpl.getInstanceImpl(this.project).unregisterChangeTracker(oldFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            ChangeListManagerImpl.getInstanceImpl(this.project).registerChangeTracker(newFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            data.setClmFilePath(newFilePath);
        }
    }

    private final boolean canGetBaseRevisionFor(VirtualFile virtualFile) {
        if (this.isDisposed) {
            return false;
        }
        if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
            return false;
        }
        boolean $i$f$runReadAction = false;
        if (((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(virtualFile){
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            {
                this.$virtualFile$inlined = virtualFile;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final T compute() {
                boolean bl;
                boolean bl2 = false;
                if (this.$virtualFile$inlined.isValid()) {
                    FileType fileType = this.$virtualFile$inlined.getFileType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"virtualFile.fileType");
                    if (!fileType.isBinary() && !FileUtilRt.isTooLarge((long)this.$virtualFile$inlined.getLength())) {
                        bl = false;
                        return (T)Boolean.valueOf(bl);
                    }
                }
                bl = true;
                return (T)Boolean.valueOf(bl);
            }
        })).booleanValue()) {
            return false;
        }
        if (!VcsFileStatusProvider.getInstance(this.project).isSupported(virtualFile)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        return !Intrinsics.areEqual((Object)status, (Object)FileStatus.ADDED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.DELETED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.UNKNOWN) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED);
    }

    private final boolean canCreatePartialTrackerFor(VirtualFile virtualFile) {
        if (!this.arePartialChangelistsEnabled(virtualFile)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        if (Intrinsics.areEqual((Object)status, (Object)FileStatus.MODIFIED) ^ true && Intrinsics.areEqual((Object)status, (Object)ChangelistConflictFileStatusProvider.MODIFIED_OUTSIDE) ^ true && Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED) ^ true) {
            return false;
        }
        Change change = ChangeListManager.getInstance((Project)this.project).getChange(virtualFile);
        return change != null && Intrinsics.areEqual(change.getClass(), Change.class) && (change.getType() == Change.Type.MODIFICATION || change.getType() == Change.Type.MOVED) && change.getAfterRevision() instanceof CurrentContentRevision;
    }

    @Override
    public boolean arePartialChangelistsEnabled(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        if (!this.partialChangeListsEnabled) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)this.project, (VirtualFile)virtualFile);
        return vcs != null && vcs.arePartialChangelistsSupported();
    }

    private final void installTracker(VirtualFile virtualFile, Document document) {
        if (!this.canGetBaseRevisionFor(virtualFile)) {
            return;
        }
        this.doInstallTracker(virtualFile, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LineStatusTracker<?> doInstallTracker(VirtualFile virtualFile, Document document) {
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            block7: {
                block6: {
                    boolean bl3 = false;
                    if (!this.isDisposed) break block6;
                    LineStatusTracker<?> lineStatusTracker = null;
                    return lineStatusTracker;
                }
                if (this.trackers.get(document) == null) break block7;
                LineStatusTracker<?> lineStatusTracker = null;
                return lineStatusTracker;
            }
            LocalLineStatusTracker tracker = this.canCreatePartialTrackerFor(virtualFile) ? (LocalLineStatusTracker)ChangelistsLocalLineStatusTracker.Companion.createTracker(this.project, document, virtualFile, this.getTrackingMode()) : (LocalLineStatusTracker)SimpleLocalLineStatusTracker.Companion.createTracker(this.project, document, virtualFile, this.getTrackingMode());
            TrackerData data = new TrackerData(tracker, null, null, 6, null);
            TrackerData replacedData = this.trackers.put(document, data);
            LOG.assertTrue(replacedData == null);
            this.registerTrackerInCLM(data);
            this.refreshTracker(tracker);
            ((Listener)this.eventDispatcher.getMulticaster()).onTrackerAdded(tracker);
            if (this.clmFreezeCounter > 0) {
                tracker.freeze$intellij_platform_vcs_impl();
            }
            this.log("Tracker installed", virtualFile);
            LineStatusTracker lineStatusTracker = tracker;
            return lineStatusTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseTracker(Document document) {
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            TrackerData trackerData = this.trackers.remove(document);
            if (trackerData == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)trackerData, (String)"trackers.remove(document) ?: return");
            TrackerData data = trackerData;
            ((Listener)this.eventDispatcher.getMulticaster()).onTrackerRemoved((LineStatusTracker)data.getTracker());
            this.unregisterTrackerInCLM(data);
            data.getTracker().release();
            this.log("Tracker released", data.getTracker().getVirtualFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateTrackingModes() {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            LocalLineStatusTracker.Mode mode = this.getTrackingMode();
            Collection<TrackerData> collection = this.trackers.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"trackers.values");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                LocalLineStatusTracker<?> localLineStatusTracker = it.getTracker();
                collection2.add(localLineStatusTracker);
            }
            List trackers2 = (List)destination$iv$iv;
            for (LocalLineStatusTracker tracker : trackers2) {
                boolean isPartialTracker;
                Document document = tracker.getDocument();
                VirtualFile virtualFile = tracker.getVirtualFile();
                boolean isPartialTrackerExpected = this.canCreatePartialTrackerFor(virtualFile);
                if (isPartialTrackerExpected == (isPartialTracker = tracker instanceof ChangelistsLocalLineStatusTracker)) {
                    tracker.setMode(mode);
                    continue;
                }
                this.releaseTracker(document);
                this.installTracker(virtualFile, document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final LocalLineStatusTracker.Mode getTrackingMode() {
        VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
        return new LocalLineStatusTracker.Mode(settings.SHOW_LST_GUTTER_MARKERS, settings.SHOW_LST_ERROR_STRIPE_MARKERS, settings.SHOW_WHITESPACES_IN_LST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshTracker(LocalLineStatusTracker<?> tracker) {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            this.loader.scheduleRefresh(new RefreshRequest(tracker.getDocument()));
            this.log("Refresh queued", tracker.getVirtualFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final void offerTrackerContent(@NotNull Document document, @NotNull CharSequence text2) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        LocalLineStatusTracker<?> tracker = null;
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            TrackerData data = this.trackers.get(document);
            if (data == null || data.getContentInfo() != null) {
                return;
            }
            tracker = data.getTracker();
            Unit unit = Unit.INSTANCE;
        }
        tracker.setBaseRevision(text2);
        this.log("Offered content", FileDocumentManager.getInstance().getFile(document));
    }

    private final boolean shouldBeUpdated(ContentInfo oldInfo, ContentInfo newInfo) {
        if (oldInfo == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)oldInfo.getRevision(), (Object)newInfo.getRevision()) && Intrinsics.areEqual((Object)oldInfo.getRevision(), (Object)VcsRevisionNumber.NULL) ^ true) {
            return Intrinsics.areEqual((Object)oldInfo.getCharset(), (Object)newInfo.getCharset()) ^ true;
        }
        return true;
    }

    private final void log(String message, VirtualFile file) {
        if (LOG.isDebugEnabled()) {
            if (file != null) {
                LOG.debug(message + "; file: " + file.getPath());
            } else {
                LOG.debug(message);
            }
        }
    }

    private final void warn(String message, Document document) {
        VirtualFile virtualFile;
        Document document2 = document;
        if (document2 != null) {
            Document document3 = document2;
            boolean bl = false;
            boolean bl2 = false;
            Document it = document3;
            boolean bl3 = false;
            virtualFile = FileDocumentManager.getInstance().getFile(it);
        } else {
            virtualFile = null;
        }
        VirtualFile file = virtualFile;
        this.warn(message, file);
    }

    private final void warn(String message, VirtualFile file) {
        if (file != null) {
            LOG.warn(message + "; file: " + file.getPath());
        } else {
            LOG.warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetExcludedFromCommitMarkers() {
        ApplicationManager.getApplication().assertIsWriteThread();
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = false;
            List documents = new ArrayList();
            for (TrackerData data : this.trackers.values()) {
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) continue;
                ((ChangelistsLocalLineStatusTracker)tracker).resetExcludedFromCommitMarkers$intellij_platform_vcs_impl();
                documents.add(tracker.getDocument());
            }
            for (Document document : documents) {
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ChangelistsLocalLineStatusTracker.FullState> collectPartiallyChangedFilesStates$intellij_platform_vcs_impl() {
        ApplicationManager.getApplication().assertIsWriteThread();
        boolean bl = false;
        List result2 = new ArrayList();
        Object object = this.LOCK;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            for (TrackerData data : this.trackers.values()) {
                boolean hasPartialChanges;
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker) || !(hasPartialChanges = ((ChangelistsLocalLineStatusTracker)tracker).getAffectedChangeListsIds().size() > 1)) continue;
                result2.add(((ChangelistsLocalLineStatusTracker)tracker).storeTrackerState$intellij_platform_vcs_impl());
            }
            Unit unit = Unit.INSTANCE;
        }
        return result2;
    }

    private final void restoreTrackersForPartiallyChangedFiles(List<? extends ChangelistsLocalLineStatusTracker.State> trackerStates) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, trackerStates){
            final /* synthetic */ LineStatusTrackerManager this$0;
            final /* synthetic */ List $trackerStates$inlined;
            {
                this.this$0 = lineStatusTrackerManager;
                this.$trackerStates$inlined = list;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                boolean bl = false;
                Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0);
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (object) {
                    boolean bl4 = false;
                    for (ChangelistsLocalLineStatusTracker.State state : this.$trackerStates$inlined) {
                        boolean stateRestored;
                        LocalLineStatusTracker<?> oldTracker;
                        TrackerData oldData;
                        Document document;
                        VirtualFile virtualFile = state.getVirtualFile();
                        if (FileDocumentManager.getInstance().getDocument(virtualFile) == null) {
                            continue;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026(virtualFile) ?: continue");
                        if (!LineStatusTrackerManager.access$canCreatePartialTrackerFor(this.this$0, virtualFile)) continue;
                        TrackerData trackerData = oldData = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0).get(document);
                        LocalLineStatusTracker<Object> localLineStatusTracker = oldTracker = trackerData != null ? trackerData.getTracker() : null;
                        if (oldTracker instanceof ChangelistsLocalLineStatusTracker) {
                            boolean stateRestored2;
                            boolean bl5 = stateRestored2 = state instanceof ChangelistsLocalLineStatusTracker.FullState && ((ChangelistsLocalLineStatusTracker)oldTracker).restoreState$intellij_platform_vcs_impl(state);
                            if (stateRestored2) {
                                LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, full restored", virtualFile);
                                continue;
                            }
                            boolean isLoading = LineStatusTrackerManager.access$getLoader$p(this.this$0).hasRequest(new RefreshRequest(document));
                            if (isLoading) {
                                LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0).put(state.getVirtualFile(), state);
                                LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, restore scheduled", virtualFile);
                                continue;
                            }
                            ((ChangelistsLocalLineStatusTracker)oldTracker).restoreState$intellij_platform_vcs_impl(state);
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, restored", virtualFile);
                            continue;
                        }
                        ChangelistsLocalLineStatusTracker tracker = ChangelistsLocalLineStatusTracker.Companion.createTracker(LineStatusTrackerManager.access$getProject$p(this.this$0), document, virtualFile, LineStatusTrackerManager.access$getTrackingMode(this.this$0));
                        TrackerData data = new TrackerData(tracker, null, null, 6, null);
                        TrackerData replacedData = LineStatusTrackerManager.access$getTrackers$p(this.this$0).put(document, data);
                        LineStatusTrackerManager.access$getLOG$cp().assertTrue(Intrinsics.areEqual((Object)replacedData, (Object)oldData));
                        if (oldTracker != null) {
                            ((Listener)LineStatusTrackerManager.access$getEventDispatcher$p(this.this$0).getMulticaster()).onTrackerRemoved(tracker);
                            LineStatusTrackerManager.access$unregisterTrackerInCLM(this.this$0, oldData);
                            oldTracker.release();
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: removed existing", virtualFile);
                        }
                        LineStatusTrackerManager.access$registerTrackerInCLM(this.this$0, data);
                        LineStatusTrackerManager.access$refreshTracker(this.this$0, tracker);
                        ((Listener)LineStatusTrackerManager.access$getEventDispatcher$p(this.this$0).getMulticaster()).onTrackerAdded(tracker);
                        boolean bl6 = stateRestored = state instanceof ChangelistsLocalLineStatusTracker.FullState && tracker.restoreState$intellij_platform_vcs_impl(state);
                        if (stateRestored) {
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: created, full restored", virtualFile);
                            continue;
                        }
                        LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0).put(state.getVirtualFile(), state);
                        LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: created, restore scheduled", virtualFile);
                    }
                    LineStatusTrackerManager.access$getLoader$p(this.this$0).addAfterUpdateRunnable(new Runnable(this){
                        final /* synthetic */ restoreTrackersForPartiallyChangedFiles$$inlined$runWriteAction$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.this$0);
                            boolean bl = false;
                            boolean bl2 = false;
                            synchronized (object) {
                                boolean bl3 = false;
                                LineStatusTrackerManager.access$log(this.this$0.this$0, "Tracker restore: finished", null);
                                LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0.this$0).clear();
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void notifyInactiveRangesDamaged$intellij_platform_vcs_impl(@NotNull VirtualFile virtualFile) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
                ApplicationManager.getApplication().assertIsWriteThread();
                if (this.filesWithDamagedInactiveRanges.contains(virtualFile)) break block2;
                FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)this.project);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManagerEx, (String)"FileEditorManagerEx.getInstanceEx(project)");
                if (!Intrinsics.areEqual((Object)virtualFile, (Object)fileEditorManagerEx.getCurrentFile())) break block3;
            }
            return;
        }
        this.filesWithDamagedInactiveRanges.add(virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    private final void showInactiveRangesDamagedNotification() {
        InactiveRangesDamagedNotification lastNotification;
        int n;
        InactiveRangesDamagedNotification[] currentNotifications;
        block4: {
            InactiveRangesDamagedNotification inactiveRangesDamagedNotification;
            currentNotifications = (InactiveRangesDamagedNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)currentNotifications, (String)"currentNotifications");
            InactiveRangesDamagedNotification[] $this$lastOrNull$iv = currentNotifications;
            boolean $i$f$lastOrNull = false;
            int n2 = $this$lastOrNull$iv.length;
            --n2;
            n = 0;
            while (n2 >= 0) {
                void index$iv;
                InactiveRangesDamagedNotification element$iv;
                InactiveRangesDamagedNotification it = element$iv = $this$lastOrNull$iv[index$iv];
                boolean bl = false;
                InactiveRangesDamagedNotification inactiveRangesDamagedNotification2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)inactiveRangesDamagedNotification2), (String)"it");
                if (!inactiveRangesDamagedNotification2.isExpired()) {
                    inactiveRangesDamagedNotification = element$iv;
                    break block4;
                }
                --index$iv;
            }
            inactiveRangesDamagedNotification = lastNotification = null;
        }
        if (lastNotification != null) {
            this.filesWithDamagedInactiveRanges.addAll((Collection<VirtualFile>)lastNotification.getVirtualFiles());
        }
        InactiveRangesDamagedNotification[] $this$forEach$iv = currentNotifications;
        boolean $i$f$forEach = false;
        InactiveRangesDamagedNotification[] inactiveRangesDamagedNotificationArray = $this$forEach$iv;
        n = inactiveRangesDamagedNotificationArray.length;
        for (int i = 0; i < n; ++i) {
            InactiveRangesDamagedNotification element$iv;
            InactiveRangesDamagedNotification it = element$iv = inactiveRangesDamagedNotificationArray[i];
            boolean bl = false;
            it.expire();
        }
        Set files = CollectionsKt.toSet((Iterable)this.filesWithDamagedInactiveRanges);
        this.filesWithDamagedInactiveRanges.clear();
        new InactiveRangesDamagedNotification(this.project, files).notify(this.project);
    }

    private final void expireInactiveRangesDamagedNotifications() {
        this.filesWithDamagedInactiveRanges.clear();
        InactiveRangesDamagedNotification[] currentNotifications = (InactiveRangesDamagedNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)currentNotifications, (String)"currentNotifications");
        InactiveRangesDamagedNotification[] $this$forEach$iv = currentNotifications;
        boolean $i$f$forEach = false;
        InactiveRangesDamagedNotification[] inactiveRangesDamagedNotificationArray = $this$forEach$iv;
        int n = inactiveRangesDamagedNotificationArray.length;
        for (int i = 0; i < n; ++i) {
            InactiveRangesDamagedNotification element$iv;
            InactiveRangesDamagedNotification it = element$iv = inactiveRangesDamagedNotificationArray[i];
            boolean bl = false;
            it.expire();
        }
    }

    public final void waitUntilBaseContentsLoaded() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        boolean bl = application.isUnitTestMode();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
        if (application2.isDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.loader.addAfterUpdateRunnable(new Runnable(semaphore){
            final /* synthetic */ Semaphore $semaphore;

            public final void run() {
                this.$semaphore.up();
            }
            {
                this.$semaphore = semaphore;
            }
        });
        long start2 = System.currentTimeMillis();
        do {
            Application application3 = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application3, (String)"ApplicationManager.getApplication()");
            if (application3.isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            if (!semaphore.waitFor(10L)) continue;
            return;
        } while (System.currentTimeMillis() - start2 <= (long)10000);
        this.loader.dumpInternalState();
        System.err.println(ThreadDumper.dumpThreadsToString());
        throw (Throwable)new IllegalStateException("Couldn't await base contents");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseAllTrackers() {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.forcedDocuments.clear();
            Iterator<TrackerData> iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                TrackerData data;
                TrackerData trackerData = data = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)trackerData, (String)"data");
                this.unregisterTrackerInCLM(trackerData);
                data.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public LineStatusTrackerManager(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.LOCK = new Object();
        this.trackers = new HashMap();
        this.forcedDocuments = new HashMap();
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(Listener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS;
        this.documentsInDefaultChangeList = new HashSet();
        this.filesWithDamagedInactiveRanges = new HashSet();
        this.fileStatesAwaitingRefresh = new HashMap();
        this.loader = new MyBaseRevisionLoader();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LineStatusTrackerManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(LineS\u2026ackerManager::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setDisposed$p(LineStatusTrackerManager $this, boolean bl) {
        $this.isDisposed = bl;
    }

    public static final /* synthetic */ void access$reregisterTrackerInCLM(LineStatusTrackerManager $this, TrackerData data) {
        $this.reregisterTrackerInCLM(data);
    }

    public static final /* synthetic */ void access$releaseTracker(LineStatusTrackerManager $this, Document document) {
        $this.releaseTracker(document);
    }

    public static final /* synthetic */ void access$restoreTrackersForPartiallyChangedFiles(LineStatusTrackerManager $this, List trackerStates) {
        $this.restoreTrackersForPartiallyChangedFiles(trackerStates);
    }

    public static final /* synthetic */ SingleThreadLoader access$getLoader$p(LineStatusTrackerManager $this) {
        return $this.loader;
    }

    public static final /* synthetic */ LocalLineStatusTracker.Mode access$getTrackingMode(LineStatusTrackerManager $this) {
        return $this.getTrackingMode();
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(LineStatusTrackerManager $this) {
        return $this.eventDispatcher;
    }

    public static final /* synthetic */ void access$unregisterTrackerInCLM(LineStatusTrackerManager $this, TrackerData data) {
        $this.unregisterTrackerInCLM(data);
    }

    public static final /* synthetic */ void access$registerTrackerInCLM(LineStatusTrackerManager $this, TrackerData data) {
        $this.registerTrackerInCLM(data);
    }

    public static final /* synthetic */ void access$refreshTracker(LineStatusTrackerManager $this, LocalLineStatusTracker tracker) {
        $this.refreshTracker(tracker);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "()V", "getOrder", "", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class MyStartupActivity
    implements VcsStartupActivity {
        @Override
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Companion.getInstanceImpl(project).startListenForEditors();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.OTHER_INITIALIZATION.getOrder();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ListenerAdapter;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "()V", "intellij.platform.vcs.impl"})
    public static class ListenerAdapter
    implements Listener {
        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            Listener.DefaultImpls.onTrackerAdded(this, tracker);
        }

        @Override
        public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            Listener.DefaultImpls.onTrackerRemoved(this, tracker);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "Ljava/util/EventListener;", "onTrackerAdded", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "onTrackerRemoved", "intellij.platform.vcs.impl"})
    public static interface Listener
    extends EventListener {
        public void onTrackerAdded(@NotNull LineStatusTracker<?> var1);

        public void onTrackerRemoved(@NotNull LineStatusTracker<?> var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onTrackerAdded(Listener $this, @NotNull LineStatusTracker<?> tracker) {
                Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            }

            public static void onTrackerRemoved(Listener $this, @NotNull LineStatusTracker<?> tracker) {
                Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "handleCanceled", "", "document", "Lcom/intellij/openapi/editor/Document;", "handleError", "handleResult", "request", "result", "Lcom/intellij/openapi/vcs/impl/Result;", "handleSuccess", "refreshData", "loadRequest", "intellij.platform.vcs.impl"})
    private final class MyBaseRevisionLoader
    extends SingleThreadLoader<RefreshRequest, RefreshData> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Result<RefreshData> loadRequest(@NotNull RefreshRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            if (LineStatusTrackerManager.this.isDisposed) {
                return new Result.Canceled();
            }
            Document document = request.getDocument();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            LineStatusTrackerManager.this.log("Loading started", virtualFile);
            if (virtualFile == null || !virtualFile.isValid()) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not valid", virtualFile);
                return new Result.Error();
            }
            if (!LineStatusTrackerManager.this.canGetBaseRevisionFor(virtualFile)) {
                LineStatusTrackerManager.this.log("Loading error: cant get base revision", virtualFile);
                return new Result.Error();
            }
            VcsBaseContentProvider.BaseContent baseContent = VcsFileStatusProvider.getInstance(LineStatusTrackerManager.this.project).getBaseRevision(virtualFile);
            if (baseContent == null) {
                LineStatusTrackerManager.this.log("Loading error: base revision not found", virtualFile);
                return new Result.Error();
            }
            VcsRevisionNumber vcsRevisionNumber = baseContent.getRevisionNumber();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsRevisionNumber, (String)"baseContent.revisionNumber");
            Charset charset = virtualFile.getCharset();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"virtualFile.charset");
            ContentInfo newContentInfo = new ContentInfo(vcsRevisionNumber, charset);
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                block11: {
                    TrackerData data;
                    block10: {
                        boolean bl3 = false;
                        data = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                        if (data != null) break block10;
                        LineStatusTrackerManager.this.log("Loading cancelled: tracker not found", virtualFile);
                        Result result2 = new Result.Canceled();
                        return result2;
                    }
                    if (LineStatusTrackerManager.this.shouldBeUpdated(data.getContentInfo(), newContentInfo)) break block11;
                    LineStatusTrackerManager.this.log("Loading cancelled: no need to update", virtualFile);
                    Result result3 = new Result.Canceled();
                    return result3;
                }
                Unit unit = Unit.INSTANCE;
            }
            String lastUpToDateContent = baseContent.loadContent();
            if (lastUpToDateContent == null) {
                LineStatusTrackerManager.this.log("Loading error: provider failure", virtualFile);
                return new Result.Error();
            }
            String string = StringUtil.convertLineSeparators((String)lastUpToDateContent);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.convertLineSe\u2026tors(lastUpToDateContent)");
            String converted = string;
            LineStatusTrackerManager.this.log("Loading successful", virtualFile);
            return new Result.Success<RefreshData>(new RefreshData(converted, newContentInfo));
        }

        @Override
        protected void handleResult(@NotNull RefreshRequest request, @NotNull Result<RefreshData> result2) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Document document = request.getDocument();
            Result<RefreshData> result3 = result2;
            if (result3 instanceof Result.Canceled) {
                this.handleCanceled(document);
            } else if (result3 instanceof Result.Error) {
                this.handleError(document);
            } else if (result3 instanceof Result.Success) {
                this.handleSuccess(document, (RefreshData)((Result.Success)result2).getData());
            }
            LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleCanceled(Document document) {
            ChangelistsLocalLineStatusTracker.State state;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
            VirtualFile virtualFile2 = virtualFile;
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                ChangelistsLocalLineStatusTracker.State state2 = (ChangelistsLocalLineStatusTracker.State)LineStatusTrackerManager.this.fileStatesAwaitingRefresh.remove(virtualFile2);
                if (state2 == null) {
                    return;
                }
                ChangelistsLocalLineStatusTracker.State state3 = state2;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl18 : MonitorExitStatement: MONITOREXIT : var4_3
                state = state3;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"synchronized(LOCK) {\n   \u2026alFile) ?: return\n      }");
            ChangelistsLocalLineStatusTracker.State state4 = state;
            LineStatusTracker<?> tracker = LineStatusTrackerManager.this.getLineStatusTracker(document);
            if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state4);
                LineStatusTrackerManager.this.log("Loading canceled: state restored", virtualFile2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleError(Document document) {
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                if (trackerData == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)trackerData, (String)"trackers[document] ?: return");
                TrackerData data = trackerData;
                data.getTracker().dropBaseRevision();
                data.setContentInfo(null);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleSuccess(Document document, RefreshData refreshData) {
            ChangelistsLocalLineStatusTracker.State state;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"FileDocumentManager.getI\u2026nce().getFile(document)!!");
            VirtualFile virtualFile2 = virtualFile;
            LocalLineStatusTracker<?> tracker = null;
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                TrackerData data = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                if (data == null) {
                    LineStatusTrackerManager.this.log("Loading finished: tracker already released", virtualFile2);
                    return;
                }
                if (!LineStatusTrackerManager.this.shouldBeUpdated(data.getContentInfo(), refreshData.getInfo())) {
                    LineStatusTrackerManager.this.log("Loading finished: no need to update", virtualFile2);
                    return;
                }
                data.setContentInfo(refreshData.getInfo());
                tracker = data.getTracker();
                Unit unit = Unit.INSTANCE;
            }
            tracker.setBaseRevision(refreshData.getText());
            LineStatusTrackerManager.this.log("Loading finished: success", virtualFile2);
            if (tracker instanceof ChangelistsLocalLineStatusTracker && (state = (ChangelistsLocalLineStatusTracker.State)LineStatusTrackerManager.this.fileStatesAwaitingRefresh.remove(tracker.getVirtualFile())) != null) {
                ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state);
                LineStatusTrackerManager.this.log("Loading finished: state restored", virtualFile2);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener;", "Lcom/intellij/openapi/vcs/FileStatusListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "fileStatusChanged", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusesChanged", "intellij.platform.vcs.impl"})
    private final class MyFileStatusListener
    implements FileStatusListener {
        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.onEverythingChanged();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
            LineStatusTrackerManager.this.onFileChanged(virtualFile);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "install", "disposable", "Lcom/intellij/openapi/Disposable;", "isTrackedEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.vcs.impl"})
    private final class MyEditorFactoryListener
    implements EditorFactoryListener {
        public final void install(@NotNull Disposable disposable) {
            EditorFactory editorFactory;
            Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
            EditorFactory editorFactory2 = editorFactory = EditorFactory.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory2, (String)"editorFactory");
            Editor[] editorArray = editorFactory2.getAllEditors();
            int n = editorArray.length;
            for (int i = 0; i < n; ++i) {
                Editor editor;
                Editor editor2 = editor = editorArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
                if (!this.isTrackedEditor(editor2)) continue;
                Document document = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.requestTrackerFor(document, editor);
            }
            editorFactory.addEditorFactoryListener((EditorFactoryListener)this, disposable);
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"event.editor");
            Editor editor2 = editor;
            if (this.isTrackedEditor(editor2)) {
                Document document = editor2.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.requestTrackerFor(document, editor2);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"event.editor");
            Editor editor2 = editor;
            if (this.isTrackedEditor(editor2)) {
                Document document = editor2.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.releaseTrackerFor(document, editor2);
            }
        }

        private final boolean isTrackedEditor(Editor editor) {
            if (FileDocumentManager.getInstance().getFile(editor.getDocument()) == null) {
                return false;
            }
            return editor.getProject() == null || Intrinsics.areEqual((Object)editor.getProject(), (Object)LineStatusTrackerManager.this.project);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J$\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "forEachTrackerUnder", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "handleFileDeletion", "handleFileMovement", "intellij.platform.vcs.impl"})
    private final class MyVirtualFileListener
    implements BulkFileListener {
        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkParameterIsNotNull(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                VFileEvent vFileEvent2 = vFileEvent;
                if (!(vFileEvent2 instanceof VFileDeleteEvent)) continue;
                VirtualFile virtualFile = ((VFileDeleteEvent)vFileEvent).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                this.handleFileDeletion(virtualFile);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkParameterIsNotNull(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                VFileEvent vFileEvent2 = vFileEvent;
                if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                    if (Intrinsics.areEqual((Object)"encoding", (Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) {
                        VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                        LineStatusTrackerManager.this.onFileChanged(virtualFile);
                        continue;
                    }
                    if (!((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
                    VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                    this.handleFileMovement(virtualFile);
                    continue;
                }
                if (!(vFileEvent2 instanceof VFileMoveEvent)) continue;
                VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                this.handleFileMovement(virtualFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileMovement(VirtualFile file) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                this.forEachTrackerUnder(file, (Function1<? super TrackerData, Unit>)((Function1)new Function1<TrackerData, Unit>(this, file){
                    final /* synthetic */ MyVirtualFileListener this$0;
                    final /* synthetic */ VirtualFile $file$inlined;
                    {
                        this.this$0 = myVirtualFileListener;
                        this.$file$inlined = virtualFile;
                        super(1);
                    }

                    public final void invoke(@NotNull TrackerData data) {
                        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                        LineStatusTrackerManager.access$reregisterTrackerInCLM(this.this$0.LineStatusTrackerManager.this, data);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileDeletion(VirtualFile file) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                this.forEachTrackerUnder(file, (Function1<? super TrackerData, Unit>)((Function1)new Function1<TrackerData, Unit>(this, file){
                    final /* synthetic */ MyVirtualFileListener this$0;
                    final /* synthetic */ VirtualFile $file$inlined;
                    {
                        this.this$0 = myVirtualFileListener;
                        this.$file$inlined = virtualFile;
                        super(1);
                    }

                    public final void invoke(@NotNull TrackerData data) {
                        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                        LineStatusTrackerManager.access$releaseTracker(this.this$0.LineStatusTrackerManager.this, data.getTracker().getDocument());
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void forEachTrackerUnder(VirtualFile file, Function1<? super TrackerData, Unit> action) {
            if (file.isDirectory()) {
                void $this$filterTo$iv$iv;
                Collection collection = LineStatusTrackerManager.this.trackers.values();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"trackers.values");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TrackerData it = (TrackerData)element$iv$iv;
                    boolean bl = false;
                    if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)it.getTracker().getVirtualFile(), (boolean)false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List affected = (List)destination$iv$iv;
                Iterator iterator = affected.iterator();
                while (iterator.hasNext()) {
                    TrackerData data;
                    TrackerData trackerData = data = (TrackerData)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)trackerData, (String)"data");
                    action.invoke((Object)trackerData);
                }
            } else {
                Document document = FileDocumentManager.getInstance().getCachedDocument(file);
                if (document == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026dDocument(file) ?: return");
                Document document2 = document;
                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.this.trackers.get(document2);
                if (trackerData == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)trackerData, (String)"trackers[document] ?: return");
                TrackerData data = trackerData;
                action.invoke((Object)data);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.vcs.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isDispatchThread()) {
                return;
            }
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled || LineStatusTrackerManager.this.project.isDisposed()) {
                return;
            }
            Document document = event.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"event.document");
            Document document2 = document;
            if (LineStatusTrackerManager.this.documentsInDefaultChangeList.contains(document2)) {
                return;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            if (virtualFile == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
            VirtualFile virtualFile2 = virtualFile;
            if (LineStatusTrackerManager.this.getLineStatusTracker(document2) != null) {
                return;
            }
            if (!LineStatusTrackerManager.this.canGetBaseRevisionFor(virtualFile2)) {
                return;
            }
            if (!LineStatusTrackerManager.this.canCreatePartialTrackerFor(virtualFile2)) {
                return;
            }
            LocalChangeList changeList = ChangeListManagerImpl.getInstanceImpl(LineStatusTrackerManager.this.project).getChangeList(virtualFile2);
            if (changeList != null && !changeList.isDefault()) {
                LineStatusTrackerManager.this.log("Tracker install from DocumentListener: ", virtualFile2);
                LineStatusTracker tracker = LineStatusTrackerManager.this.doInstallTracker(virtualFile2, document2);
                if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                    ((ChangelistsLocalLineStatusTracker)tracker).replayChangesFromDocumentEvents(CollectionsKt.listOf((Object)event));
                }
                return;
            }
            LineStatusTrackerManager.this.documentsInDefaultChangeList.add(document2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.vcs.impl"})
    private final class MyApplicationListener
    implements ApplicationListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void afterWriteActionFinished(@NotNull Object action) {
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            LineStatusTrackerManager.this.documentsInDefaultChangeList.clear();
            Object object = LineStatusTrackerManager.this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                void $this$mapTo$iv$iv;
                boolean bl3 = false;
                Collection collection = LineStatusTrackerManager.this.trackers.values();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"trackers.values");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TrackerData trackerData = (TrackerData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    Document document = it.getTracker().getDocument();
                    collection2.add(document);
                }
                List documents = (List)destination$iv$iv;
                for (Document document : documents) {
                    LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyLineStatusTrackerSettingListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerSettingListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "settingsUpdated", "", "intellij.platform.vcs.impl"})
    private final class MyLineStatusTrackerSettingListener
    implements LineStatusTrackerSettingListener {
        public void settingsUpdated() {
            LineStatusTrackerManager.this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS;
            LineStatusTrackerManager.this.updateTrackingModes();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "defaultListChanged", "", "oldDefaultList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "newDefaultList", "intellij.platform.vcs.impl"})
    private final class MyChangeListListener
    extends ChangeListAdapter {
        public void defaultListChanged(@Nullable ChangeList oldDefaultList, @Nullable ChangeList newDefaultList) {
            Application app$iv;
            ModalityState modalityState$iv = ModalityState.any();
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                if (!LineStatusTrackerManager.this.project.isDisposed()) {
                    LineStatusTrackerManager.this.expireInactiveRangesDamagedNotifications();
                    EditorFactory editorFactory = EditorFactory.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
                    Object[] objectArray = editorFactory.getAllEditors();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"EditorFactory.getInstance().allEditors");
                    Iterable $this$forEach$iv = ArraysKt.filterIsInstance((Object[])objectArray, EditorEx.class);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        EditorEx it = (EditorEx)element$iv;
                        boolean bl2 = false;
                        it.getGutterComponentEx().repaint();
                    }
                }
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ MyChangeListListener this$0;
                    {
                        this.this$0 = myChangeListListener;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (!LineStatusTrackerManager.access$getProject$p(this.this$0.LineStatusTrackerManager.this).isDisposed()) {
                            LineStatusTrackerManager.access$expireInactiveRangesDamagedNotifications(this.this$0.LineStatusTrackerManager.this);
                            EditorFactory editorFactory = EditorFactory.getInstance();
                            Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
                            Object[] objectArray = editorFactory.getAllEditors();
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"EditorFactory.getInstance().allEditors");
                            Iterable $this$forEach$iv = ArraysKt.filterIsInstance((Object[])objectArray, EditorEx.class);
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                EditorEx it = (EditorEx)element$iv;
                                boolean bl2 = false;
                                it.getGutterComponentEx().repaint();
                            }
                        }
                    }
                };
                ModalityState modalityState = modalityState$iv;
                if (modalityState == null) {
                    modalityState = ModalityState.defaultModalityState();
                }
                application2.invokeLater(runnable, modalityState);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "commandFinished", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "intellij.platform.vcs.impl"})
    private final class MyCommandListener
    implements CommandListener {
        public void commandFinished(@NotNull CommandEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)commandProcessor, (String)"CommandProcessor.getInstance()");
            if (commandProcessor.getCurrentCommand() == null && !LineStatusTrackerManager.this.filesWithDamagedInactiveRanges.isEmpty()) {
                LineStatusTrackerManager.this.showInactiveRangesDamagedNotification();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$CheckinFactory;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "intellij.platform.vcs.impl"})
    public static final class CheckinFactory
    extends CheckinHandlerFactory {
        @NotNull
        public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
            Intrinsics.checkParameterIsNotNull((Object)panel2, (String)"panel");
            Intrinsics.checkParameterIsNotNull((Object)commitContext, (String)"commitContext");
            Project project = panel2.getProject();
            return new CheckinHandler(project, panel2){
                final /* synthetic */ Project $project;
                final /* synthetic */ CheckinProjectPanel $panel;

                public void checkinSuccessful() {
                    this.resetExcludedFromCommit();
                }

                public void checkinFailed(@Nullable List<VcsException> exception) {
                    this.resetExcludedFromCommit();
                }

                private final void resetExcludedFromCommit() {
                    Application app$iv;
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application application = app$iv = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                    if (application.isDispatchThread()) {
                        boolean bl = false;
                        Project project = this.$project;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        if (!project.isDisposed() && !AbstractCommitWorkflowHandlerKt.isNonModalCommit(this.$panel)) {
                            Project project2 = this.$project;
                            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                            LineStatusTrackerManager.Companion.getInstanceImpl(project2).resetExcludedFromCommitMarkers();
                        }
                    } else {
                        boolean $i$f$invokeLater = false;
                        ApplicationManager.getApplication().invokeLater(new Runnable(this){
                            final /* synthetic */ createHandler.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                Project project = this.this$0.$project;
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                                if (!project.isDisposed() && !AbstractCommitWorkflowHandlerKt.isNonModalCommit(this.this$0.$panel)) {
                                    Project project2 = this.this$0.$project;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                                    LineStatusTrackerManager.Companion.getInstanceImpl(project2).resetExcludedFromCommitMarkers();
                                }
                            }
                        }, ModalityState.defaultModalityState());
                    }
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$panel = $captured_local_variable$1;
                }
            };
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFreezeListener;", "Lcom/intellij/openapi/vcs/changes/VcsFreezingProcess$Listener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onFreeze", "", "onUnfreeze", "intellij.platform.vcs.impl"})
    private final class MyFreezeListener
    implements VcsFreezingProcess.Listener {
        @Override
        public void onFreeze() {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ MyFreezeListener this$0;
                {
                    this.this$0 = myFreezeListener;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T compute() {
                    boolean bl = false;
                    Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                    boolean bl2 = false;
                    int n = 0;
                    synchronized (object) {
                        boolean bl3 = false;
                        if (LineStatusTrackerManager.access$getClmFreezeCounter$p(this.this$0.LineStatusTrackerManager.this) == 0) {
                            for (TrackerData data : LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).values()) {
                                try {
                                    data.getTracker().freeze$intellij_platform_vcs_impl();
                                }
                                catch (Throwable e) {
                                    LineStatusTrackerManager.access$getLOG$cp().error(e);
                                }
                            }
                        }
                        LineStatusTrackerManager lineStatusTrackerManager = this.this$0.LineStatusTrackerManager.this;
                        int n2 = LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager);
                        LineStatusTrackerManager.access$setClmFreezeCounter$p(lineStatusTrackerManager, n2 + 1);
                        n = n2;
                    }
                    return (T)Integer.valueOf(n);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnfreeze() {
            Application app$iv;
            ModalityState modalityState$iv = ModalityState.any();
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                Object object = LineStatusTrackerManager.this.LOCK;
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (object) {
                    boolean bl4 = false;
                    LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
                    int n = lineStatusTrackerManager.clmFreezeCounter;
                    lineStatusTrackerManager.clmFreezeCounter = n + -1;
                    if (LineStatusTrackerManager.this.clmFreezeCounter == 0) {
                        for (TrackerData data : LineStatusTrackerManager.this.trackers.values()) {
                            try {
                                data.getTracker().unfreeze$intellij_platform_vcs_impl();
                            }
                            catch (Throwable e) {
                                LOG.error(e);
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ MyFreezeListener this$0;
                    {
                        this.this$0 = myFreezeListener;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        boolean bl = false;
                        Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        synchronized (object) {
                            boolean bl4 = false;
                            LineStatusTrackerManager lineStatusTrackerManager = this.this$0.LineStatusTrackerManager.this;
                            int n = LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager);
                            LineStatusTrackerManager.access$setClmFreezeCounter$p(lineStatusTrackerManager, n + -1);
                            if (LineStatusTrackerManager.access$getClmFreezeCounter$p(this.this$0.LineStatusTrackerManager.this) == 0) {
                                for (TrackerData data : LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).values()) {
                                    try {
                                        data.getTracker().unfreeze$intellij_platform_vcs_impl();
                                    }
                                    catch (Throwable e) {
                                        LineStatusTrackerManager.access$getLOG$cp().error(e);
                                    }
                                }
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                };
                ModalityState modalityState = modalityState$iv;
                if (modalityState == null) {
                    modalityState = ModalityState.defaultModalityState();
                }
                application2.invokeLater(runnable, modalityState);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "clmFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;Lcom/intellij/openapi/vcs/FilePath;)V", "getClmFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "setClmFilePath", "(Lcom/intellij/openapi/vcs/FilePath;)V", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "setContentInfo", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "intellij.platform.vcs.impl"})
    private static final class TrackerData {
        @NotNull
        private final LocalLineStatusTracker<?> tracker;
        @Nullable
        private ContentInfo contentInfo;
        @Nullable
        private FilePath clmFilePath;

        @NotNull
        public final LocalLineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        @Nullable
        public final ContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public final void setContentInfo(@Nullable ContentInfo contentInfo) {
            this.contentInfo = contentInfo;
        }

        @Nullable
        public final FilePath getClmFilePath() {
            return this.clmFilePath;
        }

        public final void setClmFilePath(@Nullable FilePath filePath) {
            this.clmFilePath = filePath;
        }

        public TrackerData(@NotNull LocalLineStatusTracker<?> tracker, @Nullable ContentInfo contentInfo, @Nullable FilePath clmFilePath) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            this.tracker = tracker;
            this.contentInfo = contentInfo;
            this.clmFilePath = clmFilePath;
        }

        public /* synthetic */ TrackerData(LocalLineStatusTracker localLineStatusTracker, ContentInfo contentInfo, FilePath filePath, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                contentInfo = null;
            }
            if ((n & 4) != 0) {
                filePath = null;
            }
            this(localLineStatusTracker, contentInfo, filePath);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "", "revision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "charset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getRevision", "()Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "intellij.platform.vcs.impl"})
    private static final class ContentInfo {
        @NotNull
        private final VcsRevisionNumber revision;
        @NotNull
        private final Charset charset;

        @NotNull
        public final VcsRevisionNumber getRevision() {
            return this.revision;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        public ContentInfo(@NotNull VcsRevisionNumber revision, @NotNull Charset charset) {
            Intrinsics.checkParameterIsNotNull((Object)revision, (String)"revision");
            Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
            this.revision = revision;
            this.charset = charset;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/editor/Document;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class RefreshRequest {
        @NotNull
        private final Document document;

        public boolean equals(@Nullable Object other) {
            return other instanceof RefreshRequest && Intrinsics.areEqual((Object)this.document, (Object)((RefreshRequest)other).document);
        }

        public int hashCode() {
            return this.document.hashCode();
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("RefreshRequest: ");
            Object object = FileDocumentManager.getInstance().getFile(this.document);
            if (object == null || (object = object.getPath()) == null) {
                object = "unknown";
            }
            return stringBuilder.append(object).toString();
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        public RefreshRequest(@NotNull Document document) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            this.document = document;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "", "text", "", "info", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "getText", "()Ljava/lang/String;", "intellij.platform.vcs.impl"})
    private static final class RefreshData {
        @NotNull
        private final String text;
        @NotNull
        private final ContentInfo info;

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final ContentInfo getInfo() {
            return this.info;
        }

        public RefreshData(@NotNull String text2, @NotNull ContentInfo info) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            this.text = text2;
            this.info = info;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getVirtualFiles", "()Ljava/util/Set;", "intellij.platform.vcs.impl"})
    private static final class InactiveRangesDamagedNotification
    extends Notification {
        @NotNull
        private final Set<VirtualFile> virtualFiles;

        @NotNull
        public final Set<VirtualFile> getVirtualFiles() {
            return this.virtualFiles;
        }

        public InactiveRangesDamagedNotification(final @NotNull Project project, @NotNull Set<? extends VirtualFile> virtualFiles) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(virtualFiles, (String)"virtualFiles");
            super(VcsNotifier.STANDARD_NOTIFICATION.getDisplayId(), AllIcons.Toolwindows.ToolWindowChanges, null, null, VcsBundle.getString((String)"lst.inactive.ranges.damaged.notification"), NotificationType.INFORMATION, null);
            this.virtualFiles = virtualFiles;
            this.addAction((AnAction)NotificationAction.createSimple((Supplier)1.INSTANCE, (Runnable)new Runnable(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void run() {
                    ToolWindow window;
                    void $this$filterTo$iv$iv;
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
                    LocalChangeList localChangeList = changeListManager.getDefaultChangeList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"ChangeListManager.getIns\u2026roject).defaultChangeList");
                    LocalChangeList defaultList = localChangeList;
                    Collection collection = defaultList.getChanges();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"defaultList.changes");
                    Iterable $this$filter$iv = collection;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Change it = (Change)element$iv$iv;
                        boolean bl = false;
                        Iterable iterable2 = this.getVirtualFiles();
                        Change change = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"it");
                        if (!CollectionsKt.contains((Iterable)iterable2, (Object)change.getVirtualFile())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    final List changes = (List)destination$iv$iv;
                    ToolWindow toolWindow = window = ChangesViewContentManager.Companion.getToolWindowFor(project, "Local Changes");
                    if (toolWindow != null) {
                        toolWindow.activate(new Runnable(){

                            @Override
                            public final void run() {
                                ChangesViewManager.getInstance(project).selectChanges(changes);
                            }
                        });
                    }
                    this.expire();
                }
            }));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(LineStatusTrackerManagerI.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
            return (LineStatusTrackerManagerI)object;
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            LineStatusTrackerManagerI lineStatusTrackerManagerI = this.getInstance(project);
            if (lineStatusTrackerManagerI == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
            }
            return (LineStatusTrackerManager)lineStatusTrackerManagerI;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

