/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.util.Version;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;

public class CmdCheckoutClient
extends BaseSvnClient
implements CheckoutClient {
    @Override
    public void checkout(@NotNull Target source, @NotNull File destination, @Nullable Revision revision, @Nullable Depth depth, boolean ignoreExternals, boolean force, @NotNull WorkingCopyFormat format, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            CmdCheckoutClient.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            CmdCheckoutClient.$$$reportNull$$$0(1);
        }
        if (format == null) {
            CmdCheckoutClient.$$$reportNull$$$0(2);
        }
        this.validateFormat(format, this.getSupportedFormats());
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CommandUtil.put(parameters, destination, false);
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, ignoreExternals, "--ignore-externals");
        CommandUtil.put(parameters, force, "--force");
        this.run(source, destination, handler, parameters);
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() throws VcsException {
        ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
        Version version = this.myFactory.createVersionClient().getVersion();
        result.add(WorkingCopyFormat.from(version));
        return result;
    }

    private void run(@NotNull Target source, @NotNull File destination, @Nullable ProgressTracker handler, @NotNull List<String> parameters) throws VcsException {
        if (source == null) {
            CmdCheckoutClient.$$$reportNull$$$0(3);
        }
        if (destination == null) {
            CmdCheckoutClient.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            CmdCheckoutClient.$$$reportNull$$$0(5);
        }
        BaseUpdateCommandListener listener2 = new BaseUpdateCommandListener(destination, handler);
        this.execute(this.myVcs, source, SvnCommandName.checkout, parameters, (LineCommandListener)listener2);
        listener2.throwWrappedIfException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/checkout/CmdCheckoutClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkout";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

