/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.update.AbstractSvnUpdateIntegrateEnvironment;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;
import org.jetbrains.idea.svn.update.AbstractUpdateIntegrateCrawler;
import org.jetbrains.idea.svn.update.SvnUpdateConfigurable;
import org.jetbrains.idea.svn.update.SvnUpdatePanel;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.jetbrains.idea.svn.update.UpdateRootInfo;

public class SvnUpdateEnvironment
extends AbstractSvnUpdateIntegrateEnvironment {
    public SvnUpdateEnvironment(SvnVcs vcs) {
        super(vcs);
    }

    @Override
    protected AbstractUpdateIntegrateCrawler createCrawler(UpdateEventHandler eventHandler, boolean totalUpdate, ArrayList<VcsException> exceptions, UpdatedFiles updatedFiles) {
        return new UpdateCrawler(this.myVcs, eventHandler, totalUpdate, exceptions, updatedFiles);
    }

    @Override
    public Configurable createConfigurable(final Collection<FilePath> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return new SvnUpdateConfigurable(this.myVcs.getProject()){

            public String getDisplayName() {
                return SvnBundle.message("update.switch.configurable.name", new Object[0]);
            }

            @Override
            protected AbstractSvnUpdatePanel createPanel() {
                return new SvnUpdatePanel(SvnUpdateEnvironment.this.myVcs, collection);
            }
        };
    }

    @Nullable
    private static Url getSourceUrl(SvnVcs vcs, File root) {
        Info svnInfo = vcs.getInfo(root);
        return svnInfo != null ? svnInfo.getUrl() : null;
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    private Revision correctRevision(@NotNull UpdateRootInfo value) throws SvnBindException {
        if (value == null) {
            SvnUpdateEnvironment.$$$reportNull$$$0(0);
        }
        if (Revision.HEAD.equals(value.getRevision())) {
            value.setRevision(SvnUtil.getHeadRevision(this.myVcs, value.getUrl()));
        }
        return value.getRevision();
    }

    private boolean checkAncestry(File sourceFile, Url targetUrl, Revision targetRevision) throws SvnBindException {
        Info sourceSvnInfo = this.myVcs.getInfo(sourceFile);
        Info targetSvnInfo = this.myVcs.getInfo(targetUrl, targetRevision);
        if (sourceSvnInfo == null || targetSvnInfo == null) {
            return true;
        }
        Url copyFromTarget = targetSvnInfo.getCopyFromUrl();
        Url copyFromSource = sourceSvnInfo.getCopyFromUrl();
        if ((copyFromSource != null || copyFromTarget != null) && (sourceSvnInfo.getUrl().equals(copyFromTarget) || targetUrl.equals(copyFromSource))) {
            return true;
        }
        int result = Messages.showYesNoDialog((Project)this.myVcs.getProject(), (String)SvnBundle.message("switch.target.not.copy.current", new Object[0]), (String)SvnBundle.message("switch.target.problem.title", new Object[0]), (Icon)Messages.getWarningIcon());
        return 0 == result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/update/SvnUpdateEnvironment", "correctRevision"));
    }

    protected static class UpdateCrawler
    extends AbstractUpdateIntegrateCrawler {
        public UpdateCrawler(SvnVcs vcs, UpdateEventHandler handler, boolean totalUpdate, Collection<VcsException> exceptions, UpdatedFiles postUpdateFiles) {
            super(totalUpdate, postUpdateFiles, exceptions, handler, vcs);
        }

        @Override
        protected void showProgressMessage(ProgressIndicator progress, File root) {
            progress.setText(SvnBundle.message("progress.text.updating", root.getAbsolutePath()));
        }

        @Override
        protected long doUpdate(File root) throws SvnBindException {
            long rev;
            Revision updateTo;
            SvnConfiguration configuration = this.myVcs.getSvnConfiguration();
            UpdateRootInfo rootInfo = configuration.getUpdateRootInfo(root, this.myVcs);
            Url sourceUrl = SvnUpdateEnvironment.getSourceUrl(this.myVcs, root);
            boolean isSwitch = rootInfo != null && rootInfo.getUrl() != null && !rootInfo.getUrl().equals(sourceUrl);
            Revision revision = updateTo = rootInfo != null && rootInfo.isUpdateToRevision() ? rootInfo.getRevision() : Revision.HEAD;
            if (isSwitch) {
                UpdateClient updateClient = this.createUpdateClient(configuration, root, true, sourceUrl);
                this.myHandler.addToSwitch(root, sourceUrl);
                rev = updateClient.doSwitch(root, rootInfo.getUrl(), Revision.UNDEFINED, updateTo, configuration.getUpdateDepth(), configuration.isForceUpdate(), false);
            } else {
                UpdateClient updateClient = this.createUpdateClient(configuration, root, false, sourceUrl);
                rev = updateClient.doUpdate(root, updateTo, configuration.getUpdateDepth(), configuration.isForceUpdate(), false);
            }
            return rev;
        }

        private UpdateClient createUpdateClient(SvnConfiguration configuration, File root, boolean isSwitch, Url sourceUrl) {
            UpdateClient updateClient = this.myVcs.getFactory(root).createUpdateClient();
            if (!isSwitch) {
                updateClient.setIgnoreExternals(configuration.isIgnoreExternals());
            }
            updateClient.setEventHandler(this.myHandler);
            return updateClient;
        }

        @Override
        protected boolean isMerge() {
            return false;
        }
    }
}

