/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitUtil;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitCompoundResult {
    private final MultiMap<GitRepository, GitCommandResult> resultsByRepos = new MultiMap();
    private final Project myProject;

    public GitCompoundResult(Project project) {
        this.myProject = project;
    }

    public void append(GitRepository repository, GitCommandResult result2) {
        this.resultsByRepos.putValue((Object)repository, (Object)result2);
    }

    public boolean totalSuccess() {
        boolean success = true;
        for (GitCommandResult result2 : this.resultsByRepos.values()) {
            success &= result2.success();
        }
        return success;
    }

    public boolean partialSuccess() {
        boolean successFound = false;
        boolean failureFound = false;
        for (GitCommandResult result2 : this.resultsByRepos.values()) {
            if (result2.success()) {
                successFound = true;
                continue;
            }
            failureFound = true;
        }
        return successFound && failureFound;
    }

    @NotNull
    public String getErrorOutputWithReposIndication() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.resultsByRepos.entrySet()) {
            GitRepository repository = (GitRepository)entry.getKey();
            List errors = ContainerUtil.filter((Collection)((Collection)entry.getValue()), it -> !it.success());
            if (errors.isEmpty()) continue;
            sb.append("<p>");
            if (!GitUtil.justOneGitRepository(this.myProject)) {
                sb.append("<code>" + repository.getPresentableUrl() + "</code>:<br/>");
            }
            for (int i2 = 0; i2 < errors.size(); ++i2) {
                if (i2 > 0) {
                    sb.append("<br/>");
                }
                sb.append(((GitCommandResult)errors.get(i2)).getErrorOutputAsHtmlString());
            }
            sb.append("</p>");
        }
        String string = sb.toString();
        if (string == null) {
            GitCompoundResult.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String toString() {
        return "GitCompoundResult: " + StringUtil.join((Collection)this.resultsByRepos.keySet(), repository -> repository.getRoot().getName() + ": " + this.resultsByRepos.get(repository).toString(), (String)"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCompoundResult", "getErrorOutputWithReposIndication"));
    }
}

