/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitFullDetailsCollector;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.InternedGitLogRecordBuilder;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GitLogUtil {
    private static final Logger LOG = Logger.getInstance(GitLogUtil.class);
    public static final String GRAFTED = "grafted";
    public static final String REPLACED = "replaced";
    public static final List<String> LOG_ALL = ContainerUtil.immutableList((Object[])new String[]{"HEAD", "--branches", "--remotes", "--tags"});
    public static final String STDIN = "--stdin";
    static final GitLogParser.GitLogOption[] COMMIT_METADATA_OPTIONS = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @Nullable Consumer<? super VcsUser> userConsumer, @Nullable Consumer<? super VcsRef> refConsumer, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(2);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(3);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
        ArrayList options = ContainerUtil.newArrayList((Object[])new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME});
        if (userConsumer != null) {
            options.add(GitLogParser.GitLogOption.AUTHOR_NAME);
            options.add(GitLogParser.GitLogOption.AUTHOR_EMAIL);
        }
        if (refConsumer != null) {
            options.add(GitLogParser.GitLogOption.REF_NAMES);
        }
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, options.toArray(new GitLogParser.GitLogOption[0]));
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--decorate=full");
        handler.addParameters(parameters);
        handler.endOptions();
        GitLogOutputSplitter<GitLogRecord> handlerListener = new GitLogOutputSplitter<GitLogRecord>(handler, parser, record -> {
            Hash hash = HashImpl.build((String)record.getHash());
            List parents = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
            commitConsumer.consume((Object)factory.createTimedCommit(hash, parents, record.getCommitTime()));
            if (refConsumer != null) {
                for (VcsRef ref : GitLogUtil.parseRefs(record.getRefs(), hash, factory, root)) {
                    refConsumer.consume((Object)ref);
                }
            }
            if (userConsumer != null) {
                userConsumer.consume((Object)factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(handler);
        handlerListener.reportErrors();
    }

    @NotNull
    public static List<? extends VcsCommitMetadata> collectMetadata(@NotNull Project project, @NotNull GitVcs vcs, @NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(4);
        }
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(5);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(6);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(7);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                GitLogUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        GitLineHandler h2 = GitLogUtil.createGitHandler(project, root);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, COMMIT_METADATA_OPTIONS);
        h2.setSilent(true);
        h2.addParameters(GitLogUtil.getNoWalkParameter(vcs));
        h2.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h2.addParameters(STDIN);
        h2.endOptions();
        GitLogUtil.sendHashesToStdin(vcs, hashes2, h2);
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        List<GitLogRecord> records = parser.parse(output);
        List list = ContainerUtil.map(records, record -> {
            SmartList parents = new SmartList();
            for (String parent : record.getParentsHashes()) {
                parents.add(HashImpl.build((String)parent));
            }
            record.setUsedHandler(h2);
            return factory.createCommitMetadata(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        });
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... params) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(10);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(11);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogUtil.$$$reportNull$$$0(12);
            }
            return logDataImpl;
        }
        OpenTHashSet refs = new OpenTHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        ArrayList commits2 = new ArrayList();
        Consumer recordConsumer = arg_0 -> GitLogUtil.lambda$collectMetadata$3(root, factory, commits2, (Set)refs, arg_0);
        try {
            GitLineHandler handler = GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
            GitLogParser.GitLogOption[] options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])COMMIT_METADATA_OPTIONS, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
            GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, options);
            handler.setStdoutSuppressed(true);
            handler.addParameters(params);
            handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
            handler.addParameters("--decorate=full");
            handler.endOptions();
            StopWatch sw = StopWatch.start((String)("loading commit metadata in [" + root.getName() + "]"));
            GitLogOutputSplitter<GitLogRecord> handlerListener = new GitLogOutputSplitter<GitLogRecord>(handler, parser, recordConsumer);
            Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
            handlerListener.reportErrors();
            sw.report();
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        return new LogDataImpl((Set)refs, commits2);
    }

    @Deprecated
    @NotNull
    public static List<GitCommit> collectFullDetails(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(14);
        }
        ArrayList<GitCommit> commits2 = new ArrayList<GitCommit>();
        try {
            GitLogUtil.readFullDetails(project, root, (Consumer<? super GitCommit>)((Consumer)commits2::add), parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        ArrayList<GitCommit> arrayList = commits2;
        if (arrayList == null) {
            GitLogUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public static void readFullDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(16);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(17);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(18);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(19);
        }
        new GitFullDetailsCollector(project, root, new InternedGitLogRecordBuilder()).readFullDetails(commitConsumer, GitCommitRequirements.DEFAULT, false, parameters);
    }

    public static void readFullDetailsForHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull GitCommitRequirements requirements, @NotNull Consumer<? super GitCommit> commitConsumer) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(21);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(22);
        }
        if (requirements == null) {
            GitLogUtil.$$$reportNull$$$0(23);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(24);
        }
        new GitFullDetailsCollector(project, root, new InternedGitLogRecordBuilder()).readFullDetailsForHashes(hashes2, requirements, false, commitConsumer);
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (refs == null) {
            GitLogUtil.$$$reportNull$$$0(25);
        }
        if (hash == null) {
            GitLogUtil.$$$reportNull$$$0(26);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(27);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(28);
        }
        List list = ContainerUtil.mapNotNull(refs, refName -> {
            if (refName.equals(GRAFTED) || refName.equals(REPLACED)) {
                return null;
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Nullable
    public static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(30);
        }
        return (VcsLogObjectsFactory)ReadAction.compute(() -> {
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    static VcsCommitMetadata createMetadata(@NotNull VirtualFile root, @NotNull GitLogRecord record, @NotNull VcsLogObjectsFactory factory) {
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(31);
        }
        if (record == null) {
            GitLogUtil.$$$reportNull$$$0(32);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(33);
        }
        List parents = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
        VcsCommitMetadata vcsCommitMetadata = factory.createCommitMetadata(factory.createHash(record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        if (vcsCommitMetadata == null) {
            GitLogUtil.$$$reportNull$$$0(34);
        }
        return vcsCommitMetadata;
    }

    static void sendHashesToStdin(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2, @NotNull GitHandler handler) {
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(35);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(36);
        }
        if (handler == null) {
            GitLogUtil.$$$reportNull$$$0(37);
        }
        handler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(hashes2, "\n", handler.getCharset(), true));
    }

    @NotNull
    static String getNoWalkParameter(@NotNull GitVcs vcs) {
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(38);
        }
        return GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(vcs) ? "--no-walk=unsorted" : "--no-walk";
    }

    @NotNull
    static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(39);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(40);
        }
        return GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
    }

    @NotNull
    static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, boolean lowPriorityProcess) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(41);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(42);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(43);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG, configParameters);
        if (lowPriorityProcess) {
            handler.withLowPriority();
        }
        handler.setWithMediator(false);
        GitLineHandler gitLineHandler = handler;
        if (gitLineHandler == null) {
            GitLogUtil.$$$reportNull$$$0(44);
        }
        return gitLineHandler;
    }

    private static /* synthetic */ void lambda$collectMetadata$3(VirtualFile root, VcsLogObjectsFactory factory, List commits2, Set refs, GitLogRecord record) {
        VcsCommitMetadata commit2 = GitLogUtil.createMetadata(root, record, factory);
        commits2.add(commit2);
        Collection<VcsRef> refsInRecord = GitLogUtil.parseRefs(record.getRefs(), (Hash)commit2.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + ref + " to the set containing " + otherRef);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 29: 
            case 34: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 29: 
            case 34: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 28: 
            case 31: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 5: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 7: 
            case 22: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 29: 
            case 34: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogUtil";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogUtil";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetadata";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFullDetails";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRefs";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createMetadata";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createGitHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readTimedCommits";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectMetadata";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 29: 
            case 34: 
            case 44: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectFullDetails";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetailsForHashes";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseRefs";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsFactoryWithDisposeCheck";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createMetadata";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sendHashesToStdin";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNoWalkParameter";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createGitHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 29: 
            case 34: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

