/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.DialogManager;
import git4idea.GitVcs;
import git4idea.commands.GitImplBase;
import git4idea.config.GitConfigUtil;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitInteractiveRebaseFile;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseEntryWithDetails;
import git4idea.rebase.interactive.GitRebaseTodoModel;
import git4idea.rebase.interactive.GitRebaseTodoModelConverterKt;
import git4idea.rebase.interactive.GitRewordedCommitMessageProvider;
import git4idea.rebase.interactive.RewordedCommitMessageMapping;
import git4idea.rebase.interactive.dialog.GitInteractiveRebaseDialog;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitInteractiveRebaseEditorHandler
implements GitRebaseEditorHandler {
    private static final Logger LOG = Logger.getInstance(GitInteractiveRebaseEditorHandler.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    protected boolean myRebaseEditorShown;
    private boolean myCommitListCancelled;
    private boolean myUnstructuredEditorCancelled;
    @NotNull
    private final GitRewordedCommitMessageProvider myRewordedCommitMessageProvider;

    public GitInteractiveRebaseEditorHandler(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(1);
        }
        this.myRebaseEditorShown = false;
        this.myProject = project;
        this.myRoot = root;
        this.myRewordedCommitMessageProvider = GitRewordedCommitMessageProvider.getInstance(project);
    }

    @Override
    public int editCommits(@NotNull File file) {
        if (file == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(2);
        }
        try {
            if (this.myRebaseEditorShown) {
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, this.myRoot);
                String originalMessage = FileUtil.loadFile((File)file, (String)encoding);
                String newMessage = this.myRewordedCommitMessageProvider.getRewordedCommitMessage(this.myProject, this.myRoot, originalMessage);
                if (newMessage == null) {
                    this.myUnstructuredEditorCancelled = !this.handleUnstructuredEditor(file);
                    return this.myUnstructuredEditorCancelled ? 2 : 0;
                }
                FileUtil.writeToFile((File)file, (byte[])newMessage.getBytes(Charset.forName(encoding)));
                return 0;
            }
            this.setRebaseEditorShown();
            boolean success = this.handleInteractiveEditor(file);
            if (success) {
                return 0;
            }
            this.myCommitListCancelled = true;
            return 2;
        }
        catch (VcsException e) {
            LOG.error("Failed to load commit details for commits from git rebase file: " + file, (Throwable)e);
            return 2;
        }
        catch (Exception e) {
            LOG.error("Failed to edit git rebase file: " + file, (Throwable)e);
            return 2;
        }
    }

    protected boolean handleUnstructuredEditor(@NotNull File file) throws IOException {
        if (file == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(3);
        }
        return GitImplBase.loadFileAndShowInSimpleEditor(this.myProject, this.myRoot, file, GitBundle.getString("rebase.interactive.edit.commit.message.dialog.title"), GitBundle.getString("rebase.interactive.edit.commit.message.ok.action.title"));
    }

    protected boolean handleInteractiveEditor(@NotNull File file) throws IOException, VcsException {
        if (file == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(4);
        }
        GitInteractiveRebaseFile rebaseFile = new GitInteractiveRebaseFile(this.myProject, this.myRoot, file);
        try {
            List<GitRebaseEntry> entries = rebaseFile.load();
            if (ContainerUtil.findInstance((Iterable)ContainerUtil.map(entries, it -> it.getAction()), GitRebaseEntry.Action.Other.class) != null) {
                return this.handleUnstructuredEditor(file);
            }
            List<? extends GitRebaseEntry> newEntries = this.collectNewEntries(entries);
            if (newEntries != null) {
                rebaseFile.save(newEntries);
                return true;
            }
            rebaseFile.cancel();
            return false;
        }
        catch (GitInteractiveRebaseFile.NoopException e) {
            return this.confirmNoopRebase();
        }
    }

    @Nullable
    protected List<? extends GitRebaseEntry> collectNewEntries(@NotNull List<GitRebaseEntry> entries) throws VcsException {
        if (entries == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(5);
        }
        Ref newText = Ref.create();
        List<GitRebaseEntryWithDetails> entriesWithDetails = this.loadDetailsForEntries(entries);
        ApplicationManager.getApplication().invokeAndWait(() -> newText.set(this.showInteractiveRebaseDialog(entriesWithDetails)));
        return (List)newText.get();
    }

    @Nullable
    private List<? extends GitRebaseEntry> showInteractiveRebaseDialog(List<GitRebaseEntryWithDetails> entriesWithDetails) {
        GitInteractiveRebaseDialog<GitRebaseEntryWithDetails> editor = new GitInteractiveRebaseDialog<GitRebaseEntryWithDetails>(this.myProject, this.myRoot, entriesWithDetails);
        DialogManager.show(editor);
        if (editor.isOK()) {
            GitRebaseTodoModel<GitRebaseEntryWithDetails> rebaseTodoModel = editor.getModel();
            this.processModel(rebaseTodoModel);
            return GitRebaseTodoModelConverterKt.convertToEntries(rebaseTodoModel);
        }
        return null;
    }

    protected void processModel(@NotNull GitRebaseTodoModel<? extends GitRebaseEntryWithDetails> rebaseTodoModel) {
        if (rebaseTodoModel == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(6);
        }
        this.processModel(rebaseTodoModel, entry -> entry.getCommitDetails().getFullMessage());
    }

    protected <T extends GitRebaseEntry> void processModel(@NotNull GitRebaseTodoModel<T> rebaseTodoModel, @NotNull Function<T, String> fullMessageGetter) {
        if (rebaseTodoModel == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(7);
        }
        if (fullMessageGetter == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(8);
        }
        ArrayList<RewordedCommitMessageMapping> messages = new ArrayList<RewordedCommitMessageMapping>();
        for (GitRebaseTodoModel.Element<T> element : rebaseTodoModel.getElements()) {
            if (!(element.getType() instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword)) continue;
            GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword type = (GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword)element.getType();
            messages.add(RewordedCommitMessageMapping.fromMapping(fullMessageGetter.apply(element.getEntry()), type.getNewMessage()));
        }
        this.myRewordedCommitMessageProvider.save(this.myProject, this.myRoot, messages);
    }

    @NotNull
    private List<GitRebaseEntryWithDetails> loadDetailsForEntries(@NotNull List<GitRebaseEntry> entries) throws VcsException {
        if (entries == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(9);
        }
        List<? extends VcsCommitMetadata> details = GitLogUtil.collectMetadata(this.myProject, GitVcs.getInstance(this.myProject), this.myRoot, ContainerUtil.map(entries, entry -> entry.getCommit()));
        ArrayList<GitRebaseEntryWithDetails> entriesWithDetails = new ArrayList<GitRebaseEntryWithDetails>();
        for (int i2 = 0; i2 < entries.size(); ++i2) {
            entriesWithDetails.add(new GitRebaseEntryWithDetails(entries.get(i2), details.get(i2)));
        }
        ArrayList<GitRebaseEntryWithDetails> arrayList = entriesWithDetails;
        if (arrayList == null) {
            GitInteractiveRebaseEditorHandler.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private boolean confirmNoopRebase() {
        LOG.info("Noop situation while rebasing " + this.myRoot);
        Ref result2 = Ref.create((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set((Object)(0 == DialogManager.showOkCancelDialog(this.myProject, GitBundle.message("rebase.interactive.noop.dialog.text", new Object[0]), GitBundle.getString("rebase.interactive.noop.dialog.title"), CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) ? 1 : 0)));
        return (Boolean)result2.get();
    }

    public void setRebaseEditorShown() {
        this.myRebaseEditorShown = true;
    }

    @Override
    public boolean wasCommitListEditorCancelled() {
        return this.myCommitListCancelled;
    }

    @Override
    public boolean wasUnstructuredEditorCancelled() {
        return this.myUnstructuredEditorCancelled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseTodoModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullMessageGetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitInteractiveRebaseEditorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitInteractiveRebaseEditorHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDetailsForEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "editCommits";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleUnstructuredEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleInteractiveEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectNewEntries";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadDetailsForEntries";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

