/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreFactory;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.BasePasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\n\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0010\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00070\u0007H\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"computeProvider", "Lcom/intellij/credentialStore/CredentialStore;", "settings", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "createKeePassStore", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "dbFile", "Ljava/nio/file/Path;", "masterPasswordFile", "createPersistentCredentialStore", "getDefaultKeePassDbFile", "kotlin.jvm.PlatformType", "toPasswordStoreable", "Lcom/intellij/credentialStore/CredentialAttributes;", "intellij.platform.credentialStore"})
public final class PasswordSafeImplKt {
    public static final Path getDefaultKeePassDbFile() {
        return KeePassCredentialStoreKt.getDefaultKeePassBaseDirectory().resolve("c.kdbx");
    }

    private static final CredentialStore computeProvider(PasswordSafeSettings settings) {
        block17: {
            computeProvider.1 $fun$showError$1;
            block14: {
                block13: {
                    block12: {
                        if (settings.getProviderType() == ProviderType.MEMORY_ONLY) break block12;
                        Application application = ApplicationManager.getApplication();
                        if (application == null) break block13;
                        if (!application.isUnitTestMode()) break block13;
                    }
                    return new InMemoryCredentialStore();
                }
                $fun$showError$1 = computeProvider.1.INSTANCE;
                if (settings.getProviderType() != ProviderType.KEEPASS) break block14;
                try {
                    Object dbFile;
                    Object object;
                    block16: {
                        block15: {
                            object = settings.getKeepassDb();
                            if (object == null) break block15;
                            String string = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string;
                            boolean bl3 = false;
                            object = Paths.get(it, new String[0]);
                            if (object != null) break block16;
                        }
                        object = PasswordSafeImplKt.getDefaultKeePassDbFile();
                    }
                    Object object2 = dbFile = object;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"dbFile");
                    Path path = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"getDefaultMasterPasswordFile()");
                    return new KeePassCredentialStore((Path)object2, path);
                }
                catch (IncorrectMasterPasswordException e) {
                    CredentialStoreKt.getLOG().warn((Throwable)e);
                    $fun$showError$1.invoke("KeePass master password is " + (e.isFileMissed() ? "missing" : "incorrect"));
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Throwable e) {
                    CredentialStoreKt.getLOG().error(e);
                    $fun$showError$1.invoke("Failed opening KeePass database");
                }
                break block17;
            }
            try {
                CredentialStore store = PasswordSafeImplKt.createPersistentCredentialStore();
                if (store != null) {
                    return store;
                }
                $fun$showError$1.invoke("Native keychain is not available");
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                CredentialStoreKt.getLOG().error(e);
                $fun$showError$1.invoke("Cannot use native keychain");
            }
        }
        settings.setProviderType(ProviderType.MEMORY_ONLY);
        return new InMemoryCredentialStore();
    }

    @Nullable
    public static final CredentialStore createPersistentCredentialStore() {
        ExtensionPointName<CredentialStoreFactory> extensionPointName = CredentialStoreFactory.CREDENTIAL_STORE_FACTORY;
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"CredentialStoreFactory.CREDENTIAL_STORE_FACTORY");
        for (CredentialStoreFactory factory : extensionPointName.getExtensionList()) {
            CredentialStore credentialStore = factory.create();
            if (credentialStore == null) {
                continue;
            }
            return credentialStore;
        }
        return null;
    }

    @NotNull
    public static final PasswordSafe createKeePassStore(@NotNull Path dbFile, @NotNull Path masterPasswordFile) {
        Intrinsics.checkParameterIsNotNull((Object)dbFile, (String)"dbFile");
        Intrinsics.checkParameterIsNotNull((Object)masterPasswordFile, (String)"masterPasswordFile");
        KeePassCredentialStore store = new KeePassCredentialStore(dbFile, masterPasswordFile);
        PasswordSafeSettings settings = new PasswordSafeSettings();
        PasswordSafeSettings.PasswordSafeOptions passwordSafeOptions = new PasswordSafeSettings.PasswordSafeOptions();
        PasswordSafeSettings passwordSafeSettings = settings;
        boolean bl = false;
        boolean bl2 = false;
        PasswordSafeSettings.PasswordSafeOptions $this$apply = passwordSafeOptions;
        boolean bl3 = false;
        $this$apply.setProvider(ProviderType.KEEPASS);
        $this$apply.setKeepassDb(((Object)store.getDbFile$intellij_platform_credentialStore()).toString());
        PasswordSafeSettings.PasswordSafeOptions passwordSafeOptions2 = passwordSafeOptions;
        passwordSafeSettings.loadState(passwordSafeOptions2);
        return new BasePasswordSafe(settings, store);
    }

    private static final CredentialAttributes toPasswordStoreable(@NotNull CredentialAttributes $this$toPasswordStoreable) {
        return $this$toPasswordStoreable.isPasswordMemoryOnly() ? new CredentialAttributes($this$toPasswordStoreable.getServiceName(), $this$toPasswordStoreable.getUserName(), $this$toPasswordStoreable.getRequestor(), false, 8, null) : $this$toPasswordStoreable;
    }

    public static final /* synthetic */ CredentialAttributes access$toPasswordStoreable(CredentialAttributes $this$access_u24toPasswordStoreable) {
        return PasswordSafeImplKt.toPasswordStoreable($this$access_u24toPasswordStoreable);
    }

    public static final /* synthetic */ CredentialStore access$computeProvider(PasswordSafeSettings settings) {
        return PasswordSafeImplKt.computeProvider(settings);
    }
}

