/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.FileNode;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.Problem;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/ProblemNode;", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "parent", "Lcom/intellij/analysis/problemsView/toolWindow/FileNode;", "problem", "Lcom/intellij/analysis/problemsView/toolWindow/Problem;", "(Lcom/intellij/analysis/problemsView/toolWindow/FileNode;Lcom/intellij/analysis/problemsView/toolWindow/Problem;)V", "<set-?>", "", "description", "getDescription", "()Ljava/lang/String;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "", "offset", "getOffset", "()I", "getProblem", "()Lcom/intellij/analysis/problemsView/toolWindow/Problem;", "severity", "getSeverity", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "update", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.lang.impl"})
public final class ProblemNode
extends Node {
    @NotNull
    private final VirtualFile file;
    private int offset;
    private int severity;
    @NotNull
    private String description;
    @NotNull
    private final Problem problem;

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getSeverity() {
        return this.severity;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.ALWAYS;
    }

    @Override
    @NotNull
    public String getName() {
        return this.description;
    }

    @Override
    protected void update(@NotNull Project project, @NotNull PresentationData presentation2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)presentation2, (String)"presentation");
        this.offset = this.problem.getOffset();
        this.severity = this.problem.getSeverity();
        this.description = this.problem.getDescription();
        presentation2.addText(this.description, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation2.setIcon(this.problem.getIcon());
        Document document = ProblemsView.getDocument(project, this.file);
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"ProblemsView.getDocument(project, file) ?: return");
        Document document2 = document;
        if (!DocumentUtil.isValidOffset(this.offset, document2)) {
            return;
        }
        int line = document2.getLineNumber(this.offset) + 1;
        presentation2.addText(" :" + line, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @NotNull
    public final Problem getProblem() {
        return this.problem;
    }

    public ProblemNode(@NotNull FileNode parent, @NotNull Problem problem) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)parent), (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)problem, (String)"problem");
        super(parent);
        this.problem = problem;
        this.file = parent.getFile();
        this.description = "";
    }
}

