/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.formatting.FormatConstants;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AutoHardWrapHandler {
    public static final Key<Boolean> AUTO_WRAP_LINE_IN_PROGRESS_KEY = new Key("AUTO_WRAP_LINE_IN_PROGRESS");
    private static final AutoHardWrapHandler INSTANCE = new AutoHardWrapHandler();
    private final Map<Document, AutoWrapChange> myAutoWrapChanges = ContainerUtil.createWeakMap();

    public static AutoHardWrapHandler getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapLineIfNecessary(@NotNull Editor editor, @NotNull DataContext dataContext, long modificationStampBeforeTyping) {
        if (editor == null) {
            AutoHardWrapHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            AutoHardWrapHandler.$$$reportNull$$$0(1);
        }
        Project project = editor.getProject();
        Document document = editor.getDocument();
        AutoWrapChange change = this.myAutoWrapChanges.get(document);
        if (change != null) {
            change.charTyped(editor, modificationStampBeforeTyping);
        }
        if (project == null || !editor.getSettings().isWrapWhenTypingReachesRightMargin(project) || TemplateManager.getInstance(project) != null && TemplateManager.getInstance(project).getActiveTemplate(editor) != null) {
            return;
        }
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        int line = document.getLineNumber(caretOffset);
        int startOffset = document.getLineStartOffset(line);
        int endOffset = document.getLineEndOffset(line);
        CharSequence endOfString = document.getCharsSequence().subSequence(caretOffset, endOffset);
        final boolean endsWithSpaces = StringUtil.isEmptyOrSpaces((String)String.valueOf(endOfString));
        int margin = editor.getSettings().getRightMargin(project);
        if (margin <= 0) {
            return;
        }
        LogicalPosition logEndLinePosition = editor.offsetToLogicalPosition(endOffset);
        if (margin >= logEndLinePosition.column) {
            if (change != null) {
                change.modificationStamp = document.getModificationStamp();
            }
            return;
        }
        LineWrapPositionStrategy strategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor(editor);
        if (change == null) {
            change = new AutoWrapChange();
            this.myAutoWrapChanges.put(document, change);
        } else {
            int start2 = change.change.getStart();
            int end = change.change.getEnd();
            if (!change.isEmpty() && start2 < end) {
                document.replaceString(start2, end, change.change.getText());
            }
            change.reset();
        }
        change.update(editor);
        int maxPreferredOffset = editor.logicalPositionToOffset(new LogicalPosition(caretModel.getLogicalPosition().line, Math.max(0, margin - FormatConstants.getReservedLineWrapWidthInColumns(editor))));
        int wrapOffset = strategy.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, true, false);
        if (wrapOffset < 0) {
            return;
        }
        WhiteSpaceFormattingStrategy formattingStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(editor);
        if (wrapOffset <= startOffset || wrapOffset > maxPreferredOffset || formattingStrategy.check(document.getCharsSequence(), startOffset, wrapOffset) >= wrapOffset) {
            return;
        }
        final int[] wrapIntroducedSymbolsNumber = new int[1];
        final int[] caretOffsetDiff = new int[1];
        final int baseCaretOffset = caretModel.getOffset();
        DocumentListener listener2 = new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getOffset() < baseCaretOffset + caretOffsetDiff[0]) {
                    caretOffsetDiff[0] = caretOffsetDiff[0] + (event.getNewLength() - event.getOldLength());
                }
                if (this.autoFormatted(event)) {
                    return;
                }
                wrapIntroducedSymbolsNumber[0] = wrapIntroducedSymbolsNumber[0] + (event.getNewLength() - event.getOldLength());
            }

            private boolean autoFormatted(DocumentEvent event) {
                return event.getNewLength() <= event.getOldLength() && endsWithSpaces;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/editorActions/AutoHardWrapHandler$1", "beforeDocumentChange"));
            }
        };
        caretModel.moveToOffset(wrapOffset);
        DataManager.getInstance().saveInDataContext(dataContext, AUTO_WRAP_LINE_IN_PROGRESS_KEY, (Object)true);
        document.addDocumentListener(listener2);
        try {
            EditorActionManager.getInstance().getActionHandler("EditorEnter").execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        finally {
            DataManager.getInstance().saveInDataContext(dataContext, AUTO_WRAP_LINE_IN_PROGRESS_KEY, null);
            document.removeDocumentListener(listener2);
        }
        change.modificationStamp = document.getModificationStamp();
        change.change.setStart(wrapOffset);
        change.change.setEnd(wrapOffset + wrapIntroducedSymbolsNumber[0]);
        caretModel.moveToOffset(baseCaretOffset + caretOffsetDiff[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/AutoHardWrapHandler";
        objectArray[2] = "wrapLineIfNecessary";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AutoWrapChange {
        final TextChangeImpl change = new TextChangeImpl("", 0, 0);
        int visualLine;
        int logicalLine;
        long modificationStamp;

        private AutoWrapChange() {
        }

        void reset() {
            this.visualLine = -1;
            this.logicalLine = -1;
            this.change.setStart(0);
            this.change.setEnd(0);
        }

        void update(Editor editor) {
            this.modificationStamp = editor.getDocument().getModificationStamp();
            CaretModel caretModel = editor.getCaretModel();
            this.visualLine = caretModel.getVisualPosition().line;
            this.logicalLine = caretModel.getLogicalPosition().line;
        }

        void charTyped(Editor editor, long modificationStamp) {
            if (this.matches(editor.getCaretModel(), modificationStamp)) {
                this.modificationStamp = editor.getDocument().getModificationStamp();
                this.change.advance(1);
            } else {
                this.reset();
            }
        }

        boolean isEmpty() {
            return this.change.getDiff() == 0;
        }

        private boolean matches(CaretModel caretModel, long modificationStamp) {
            return this.modificationStamp == modificationStamp && caretModel.getOffset() <= this.change.getStart() && this.visualLine == caretModel.getVisualPosition().line && this.logicalLine == caretModel.getLogicalPosition().line;
        }

        public String toString() {
            return "visual line: " + this.visualLine + ", logical line: " + this.logicalLine + ", modification stamp: " + this.modificationStamp + ", text change: " + this.change;
        }
    }
}

