/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class BraceHighlighter
implements StartupActivity.DumbAware {
    private final Alarm myAlarm = new Alarm();

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            BraceHighlighter.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        Disposable activityDisposable = ExtensionPointUtil.createExtensionDisposable((Object)this, (ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY);
        Disposer.register((Disposable)project, (Disposable)activityDisposable);
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                BraceHighlighter.this.onCaretUpdate(e.getEditor(), project);
            }

            public void caretAdded(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                BraceHighlighter.this.onCaretUpdate(e.getEditor(), project);
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                BraceHighlighter.this.onCaretUpdate(e.getEditor(), project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BraceHighlighter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, activityDisposable);
        SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                if (editor.getProject() != project) {
                    return;
                }
                TextRange oldRange = e.getOldRange();
                TextRange newRange = e.getNewRange();
                if (oldRange != null && newRange != null && oldRange.isEmpty() == newRange.isEmpty()) {
                    return;
                }
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BraceHighlighter$2", "selectionChanged"));
            }
        };
        eventMulticaster.addSelectionListener(selectionListener, activityDisposable);
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                EditorFactory.getInstance().editors(e.getDocument(), project).forEach(editor -> BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BraceHighlighter$3", "documentChanged"));
            }
        };
        eventMulticaster.addDocumentListener(documentListener, activityDisposable);
        project.getMessageBus().connect(activityDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                FileEditor newEditor;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                FileEditor oldEditor = e.getOldEditor();
                if (oldEditor instanceof TextEditor) {
                    BraceHighlighter.this.clearBraces(((TextEditor)oldEditor).getEditor());
                }
                if ((newEditor = e.getNewEditor()) instanceof TextEditor) {
                    BraceHighlighter.updateBraces(((TextEditor)newEditor).getEditor(), BraceHighlighter.this.myAlarm);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BraceHighlighter$4", "selectionChanged"));
            }
        });
    }

    private void onCaretUpdate(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            BraceHighlighter.$$$reportNull$$$0(1);
        }
        if (project == null) {
            BraceHighlighter.$$$reportNull$$$0(2);
        }
        this.myAlarm.cancelAllRequests();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (editor.getProject() != project || selectionModel.hasSelection()) {
            return;
        }
        BraceHighlighter.updateBraces(editor, this.myAlarm);
    }

    private static void updateBraces(@NotNull Editor editor, @NotNull Alarm alarm2) {
        if (editor == null) {
            BraceHighlighter.$$$reportNull$$$0(3);
        }
        if (alarm2 == null) {
            BraceHighlighter.$$$reportNull$$$0(4);
        }
        if (editor.getDocument().isInBulkUpdate()) {
            return;
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm2, (Processor<? super BraceHighlightingHandler>)((Processor)handler2 -> {
            handler2.updateBraces();
            return false;
        }));
    }

    private void clearBraces(@NotNull Editor editor) {
        if (editor == null) {
            BraceHighlighter.$$$reportNull$$$0(5);
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, this.myAlarm, (Processor<? super BraceHighlightingHandler>)((Processor)handler2 -> {
            handler2.clearBraceHighlighters();
            return false;
        }));
    }

    @NotNull
    public static Alarm getAlarm() {
        Alarm alarm2 = Objects.requireNonNull((BraceHighlighter)BraceHighlighter.POST_STARTUP_ACTIVITY.findExtension(BraceHighlighter.class)).myAlarm;
        if (alarm2 == null) {
            BraceHighlighter.$$$reportNull$$$0(6);
        }
        return alarm2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BraceHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BraceHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlarm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onCaretUpdate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateBraces";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "clearBraces";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

