/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TerminateRemoteProcessDialog {
    @Nullable
    public static GeneralSettings.ProcessCloseConfirmation show(Project project, @NotNull String sessionName, @NotNull ProcessHandler processHandler2) {
        if (sessionName == null) {
            TerminateRemoteProcessDialog.$$$reportNull$$$0(0);
        }
        if (processHandler2 == null) {
            TerminateRemoteProcessDialog.$$$reportNull$$$0(1);
        }
        if (processHandler2.isSilentlyDestroyOnClose() || Boolean.TRUE.equals(processHandler2.getUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE))) {
            return GeneralSettings.ProcessCloseConfirmation.TERMINATE;
        }
        final boolean canDisconnect = !Boolean.TRUE.equals(processHandler2.getUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY));
        GeneralSettings.ProcessCloseConfirmation confirmation = GeneralSettings.getInstance().getProcessCloseConfirmation();
        if (confirmation != GeneralSettings.ProcessCloseConfirmation.ASK) {
            if (confirmation == GeneralSettings.ProcessCloseConfirmation.DISCONNECT && !canDisconnect) {
                confirmation = GeneralSettings.ProcessCloseConfirmation.TERMINATE;
            }
            return confirmation;
        }
        ArrayList<String> options2 = new ArrayList<String>(3);
        options2.add(ExecutionBundle.message((String)"button.terminate", (Object[])new Object[0]));
        if (canDisconnect) {
            options2.add(ExecutionBundle.message((String)"button.disconnect", (Object[])new Object[0]));
        }
        options2.add(CommonBundle.getCancelButtonText());
        DialogWrapper.DoNotAskOption.Adapter doNotAskOption = new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                GeneralSettings.ProcessCloseConfirmation confirmation;
                if (isSelected && (confirmation = TerminateRemoteProcessDialog.getConfirmation(exitCode, canDisconnect)) != null) {
                    GeneralSettings.getInstance().setProcessCloseConfirmation(confirmation);
                }
            }
        };
        final AtomicBoolean alreadyGone = new AtomicBoolean(false);
        final Runnable dialogRemover = Messages.createMessageDialogRemover((Project)project);
        ProcessAdapter listener2 = new ProcessAdapter(){

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                alreadyGone.set(true);
                dialogRemover.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/TerminateRemoteProcessDialog$2", "processWillTerminate"));
            }
        };
        processHandler2.addProcessListener((ProcessListener)listener2);
        boolean defaultDisconnect = processHandler2.detachIsDefault();
        int exitCode = Messages.showDialog((Project)project, (String)ExecutionBundle.message((String)"terminate.process.confirmation.text", (Object[])new Object[]{sessionName}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{sessionName}), (String[])ArrayUtil.toStringArray(options2), (int)(canDisconnect && defaultDisconnect ? 1 : 0), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption);
        processHandler2.removeProcessListener((ProcessListener)listener2);
        if (alreadyGone.get()) {
            return GeneralSettings.ProcessCloseConfirmation.DISCONNECT;
        }
        return TerminateRemoteProcessDialog.getConfirmation(exitCode, canDisconnect);
    }

    private static GeneralSettings.ProcessCloseConfirmation getConfirmation(int button2, boolean withDisconnect) {
        if (button2 == 0) {
            return GeneralSettings.ProcessCloseConfirmation.TERMINATE;
        }
        if (button2 == 1 && withDisconnect) {
            return GeneralSettings.ProcessCloseConfirmation.DISCONNECT;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sessionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processHandler";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/TerminateRemoteProcessDialog";
        objectArray[2] = "show";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

