/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import kotlin.Metadata;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/featureStatistics/fusCollectors/EventsRateThrottle;", "", "amount", "", "perMillis", "", "(IJ)V", "currentSize", "lastIndex", "timestamps", "", "addTimestamp", "", "now", "clearTimestamps", "isTimestampApplicable", "", "timestamp", "tryPass", "intellij.platform.ide.impl"})
public final class EventsRateThrottle {
    private final long[] timestamps;
    private int currentSize;
    private int lastIndex;
    private final int amount;
    private final long perMillis;

    public final boolean tryPass(long now) {
        if (this.isTimestampApplicable(now)) {
            this.clearTimestamps(now);
            if (this.currentSize < this.amount) {
                this.addTimestamp(now);
                return true;
            }
        }
        return false;
    }

    private final void addTimestamp(long now) {
        this.lastIndex = (this.lastIndex + 1) % this.amount;
        this.timestamps[this.lastIndex] = now;
        if (this.currentSize < this.amount) {
            ++this.currentSize;
        }
    }

    private final void clearTimestamps(long now) {
        int headIndex = (this.amount + this.lastIndex + 1 - this.currentSize) % this.amount;
        while (this.currentSize > 0 && this.timestamps[headIndex] + this.perMillis <= now) {
            headIndex = (headIndex + 1) % this.amount;
            --this.currentSize;
        }
    }

    private final boolean isTimestampApplicable(long timestamp) {
        return this.currentSize == 0 || timestamp >= this.timestamps[this.lastIndex];
    }

    public EventsRateThrottle(int amount, long perMillis) {
        this.amount = amount;
        this.perMillis = perMillis;
        this.timestamps = new long[this.amount];
    }
}

