/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToLinkTargetAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GoToLinkTargetAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoToLinkTargetAction.$$$reportNull$$$0(0);
        }
        Project project = GoToLinkTargetAction.getEventProject((AnActionEvent)e);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabledAndVisible(project != null && GoToLinkTargetAction.underSymlink(file2));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GoToLinkTargetAction.$$$reportNull$$$0(1);
        }
        Project project = GoToLinkTargetAction.getEventProject((AnActionEvent)e);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && GoToLinkTargetAction.underSymlink(file2)) {
            VirtualFile target2 = file2.getCanonicalFile();
            PsiFileSystemItem psiFile = PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)target2);
            if (LOG.isDebugEnabled()) {
                LOG.debug(file2 + " -> " + target2 + " (" + psiFile + ")");
            }
            if (psiFile != null) {
                ProjectView.getInstance(project).select(psiFile, target2, false);
            }
        }
    }

    private static boolean underSymlink(@Nullable VirtualFile file2) {
        return file2 != null && (file2.is(VFileProperty.SYMLINK) || GoToLinkTargetAction.underSymlink(file2.getParent()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/GoToLinkTargetAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

