/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/actions/ToggleZenModeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "toggleDistractionFreeModeAction", "Lcom/intellij/ide/actions/ToggleDistractionFreeModeAction;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "applyZenMode", "state", "", "update", "Companion", "intellij.platform.ide.impl"})
public final class ToggleZenModeAction
extends DumbAwareAction {
    private final ToggleDistractionFreeModeAction toggleDistractionFreeModeAction = new ToggleDistractionFreeModeAction();
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!ToggleZenModeAction.Companion.isFullScreenApplicable()) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setVisible(false);
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
            presentation3.setEnabled(false);
            return;
        }
        Presentation presentation4 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation4, (String)"e.presentation");
        presentation4.setText(Companion.isZenModeEnabled(project) ? ActionsBundle.message((String)"action.ToggleZenMode.exit", (Object[])new Object[0]) : ActionsBundle.message((String)"action.ToggleZenMode.enter", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        this.applyZenMode(e, !Companion.isZenModeEnabled(project2));
    }

    private final void applyZenMode(AnActionEvent e, boolean state) {
        IdeFrameEx frame;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        if (ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled() != state) {
            this.toggleDistractionFreeModeAction.actionPerformed(e);
        }
        if (ToggleZenModeAction.Companion.isFullScreenApplicable() && (frame = ToggleZenModeAction.Companion.getFrame(project2)) != null && frame.isInFullScreen() != state) {
            frame.toggleFullScreen(state);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0013\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n*\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/actions/ToggleZenModeAction$Companion;", "", "()V", "isFullScreenApplicable", "", "isZenModeEnabled", "project", "Lcom/intellij/openapi/project/Project;", "getFrame", "Lcom/intellij/openapi/wm/ex/IdeFrameEx;", "Lorg/jetbrains/annotations/Nullable;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final boolean isFullScreenApplicable() {
            WindowManager windowManager = WindowManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)windowManager, (String)"WindowManager.getInstance()");
            return windowManager.isFullScreenSupportedInCurrentOS();
        }

        private final IdeFrameEx getFrame(@NotNull Project $this$getFrame) {
            return WindowManagerEx.getInstanceEx().findFrameHelper($this$getFrame);
        }

        public final boolean isZenModeEnabled(@NotNull Project project) {
            IdeFrameEx frame;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (!ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled()) {
                return false;
            }
            return !this.isFullScreenApplicable() || (frame = this.getFrame(project)) == null || frame.isInFullScreen();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

