/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.PrefixedTokenParser;
import com.intellij.psi.CustomHighlighterTokenType;

public class MultilineCommentParser
extends PrefixedTokenParser {
    private final char[] myEndDelimiter;

    private MultilineCommentParser(String startDelimiter, String endDelimiter) {
        super(startDelimiter, CustomHighlighterTokenType.MULTI_LINE_COMMENT);
        this.myEndDelimiter = endDelimiter.toCharArray();
    }

    @Override
    protected int getTokenEnd(int position) {
        while (position < this.myEndOffset) {
            int i2;
            int pos = position;
            for (i2 = 0; i2 < this.myEndDelimiter.length && pos < this.myEndOffset && this.myBuffer.charAt(pos) == this.myEndDelimiter[i2]; ++i2, ++pos) {
            }
            if (i2 == this.myEndDelimiter.length) {
                return pos;
            }
            ++position;
        }
        return position;
    }

    public static MultilineCommentParser create(String startDelimiter, String endDelimiter) {
        if (startDelimiter == null || endDelimiter == null) {
            return null;
        }
        String trimmedStart = startDelimiter.trim();
        String trimmedEnd = endDelimiter.trim();
        if (trimmedStart.length() > 0 && trimmedEnd.length() > 0) {
            return new MultilineCommentParser(trimmedStart, trimmedEnd);
        }
        return null;
    }
}

