/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditDropHandler;
import com.intellij.ide.lightEdit.LightEditFileTypeOverrider;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorInfoImpl;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditorManagerImpl
implements LightEditorManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(LightEditorManagerImpl.class);
    private final List<LightEditorInfo> myEditors = new CopyOnWriteArrayList<LightEditorInfo>();
    private final EventDispatcher<LightEditorListener> myEventDispatcher = EventDispatcher.create(LightEditorListener.class);
    private final LightEditServiceImpl myLightEditService;
    static final Key<Boolean> NO_IMPLICIT_SAVE = Key.create((String)"light.edit.no.implicit.save");
    private static final String DEFAULT_FILE_NAME = "untitled_";

    public LightEditorManagerImpl(LightEditServiceImpl service) {
        this.myLightEditService = service;
    }

    @Nullable
    private LightEditorInfo doCreateEditor(@NotNull VirtualFile file2) {
        Project project;
        Pair<FileEditorProvider, FileEditor> pair;
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(0);
        }
        if ((pair = LightEditorManagerImpl.createFileEditor(project = Objects.requireNonNull(LightEditUtil.getProject()), file2)) == null) {
            return null;
        }
        LightEditorInfoImpl editorInfo = new LightEditorInfoImpl((FileEditorProvider)pair.first, (FileEditor)pair.second, file2);
        ObjectUtils.consumeIfCast((Object)LightEditorInfoImpl.getEditor(editorInfo), EditorImpl.class, editorImpl -> editorImpl.setDropHandler(new LightEditDropHandler()));
        this.myEditors.add(editorInfo);
        ((FileEditorManagerListener)project.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened(FileEditorManager.getInstance((Project)project), file2);
        return editorInfo;
    }

    @Nullable
    private static Pair<FileEditorProvider, FileEditor> createFileEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        FileEditorProvider[] providers;
        FileEditorProvider[] fileEditorProviderArray;
        int n;
        int n2;
        if (project == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(2);
        }
        if ((n2 = 0) < (n = (fileEditorProviderArray = (providers = FileEditorProviderManager.getInstance().getProviders(project, file2))).length)) {
            FileEditorProvider provider = fileEditorProviderArray[n2];
            FileEditor editor = provider.createEditor(project, file2);
            return Pair.create((Object)provider, (Object)editor);
        }
        return null;
    }

    @NotNull
    public LightEditorInfo createEditor() {
        LightVirtualFile file2 = new LightVirtualFile(this.getUniqueName());
        file2.setFileType((FileType)PlainTextFileType.INSTANCE);
        LightEditorInfo lightEditorInfo = Objects.requireNonNull(this.doCreateEditor((VirtualFile)file2));
        if (lightEditorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(3);
        }
        return lightEditorInfo;
    }

    @Nullable
    public LightEditorInfo createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(4);
        }
        LightEditFileTypeOverrider.markUnknownFileTypeAsPlainText(file2);
        LightEditorManagerImpl.setImplicitSaveEnabled(file2, false);
        LightEditorInfo editorInfo = this.doCreateEditor(file2);
        Editor editor = LightEditorInfoImpl.getEditor(editorInfo);
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).setHighlighter(LightEditorManagerImpl.getHighlighter(file2, editor));
        }
        return editorInfo;
    }

    private static void setImplicitSaveEnabled(@NotNull VirtualFile file2, boolean isEnabled) {
        Document document;
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(5);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(file2)) != null) {
            document.putUserData(NO_IMPLICIT_SAVE, (Object)(isEnabled ? null : Boolean.valueOf(true)));
        }
    }

    public void dispose() {
        this.releaseEditors();
    }

    public void releaseEditors() {
        this.myEditors.forEach(editorInfo -> ((LightEditorInfoImpl)editorInfo).disposeEditor());
        this.myEditors.clear();
    }

    public void closeEditor(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(6);
        }
        this.myEditors.remove(editorInfo);
        LightEditorManagerImpl.setImplicitSaveEnabled(editorInfo.getFile(), true);
        ((LightEditorInfoImpl)editorInfo).disposeEditor();
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).afterClose(editorInfo);
    }

    public void addListener(@NotNull LightEditorListener listener2) {
        if (listener2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(7);
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LightEditorListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(9);
        }
        this.myEventDispatcher.addListener((EventListener)listener2, parent);
    }

    void fireEditorSelected(@Nullable LightEditorInfo editorInfo) {
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).afterSelect(editorInfo);
    }

    void fireAutosaveModeChanged(boolean autosaveMode) {
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).autosaveModeChanged(autosaveMode);
    }

    void fireFileStatusChanged(@NotNull Collection<LightEditorInfo> editorInfos) {
        if (editorInfos == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(10);
        }
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).fileStatusChanged(editorInfos);
    }

    @NotNull
    private static EditorHighlighter getHighlighter(@NotNull VirtualFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(12);
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file2, editor.getColorsScheme(), null);
        if (editorHighlighter == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(13);
        }
        return editorHighlighter;
    }

    int getEditorCount() {
        return this.myEditors.size();
    }

    @Nullable
    public LightEditorInfo findOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(14);
        }
        return this.myEditors.stream().filter(editorInfo -> file2.getPath().equals(editorInfo.getFile().getPath())).findFirst().orElse(null);
    }

    public boolean isImplicitSaveAllowed(@NotNull Document document) {
        if (document == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(15);
        }
        return LightEditService.getInstance().isAutosaveMode() || (Boolean)ObjectUtils.notNull((Object)((Boolean)document.getUserData(NO_IMPLICIT_SAVE)), (Object)false) == false;
    }

    @NotNull
    public Collection<VirtualFile> getOpenFiles() {
        Collection collection = this.myEditors.stream().map(info -> info.getFile()).collect(Collectors.toSet());
        if (collection == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(16);
        }
        return collection;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(17);
        }
        return this.myEditors.stream().anyMatch(editorInfo -> file2.equals(editorInfo.getFile()));
    }

    public boolean containsUnsavedDocuments() {
        return this.myEditors.stream().anyMatch(editorInfo -> editorInfo.isUnsaved());
    }

    @NotNull
    List<LightEditorInfo> getUnsavedEditors() {
        List list2 = ContainerUtil.filter(this.myEditors, editorInfo -> editorInfo.isUnsaved());
        if (list2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(18);
        }
        return list2;
    }

    private String getUniqueName() {
        int i2 = 1;
        while (true) {
            String candidate = DEFAULT_FILE_NAME + i2;
            if (this.myEditors.stream().noneMatch(editorInfo -> editorInfo.getFile().getName().equals(candidate))) {
                return candidate;
            }
            ++i2;
        }
    }

    @NotNull
    public LightEditorInfo saveAs(@NotNull LightEditorInfo info, @NotNull VirtualFile targetFile) {
        LightEditorInfo newInfo;
        if (info == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(19);
        }
        if (targetFile == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(20);
        }
        if ((newInfo = this.createEditor(targetFile)) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                FileDocumentManager manager = FileDocumentManager.getInstance();
                Document source = manager.getDocument(info.getFile());
                Document target2 = manager.getDocument(targetFile);
                if (source == null) {
                    LOG.error("Cannot save to " + targetFile + ": no document found for " + info.getFile());
                    return;
                }
                if (target2 == null) {
                    LOG.error("Cannot save to " + targetFile + ": no document found for " + targetFile);
                    return;
                }
                targetFile.refresh(false, false);
                target2.setText(source.getCharsSequence());
                manager.saveDocument(target2);
            });
            LightEditorInfo lightEditorInfo = newInfo;
            if (lightEditorInfo == null) {
                LightEditorManagerImpl.$$$reportNull$$$0(21);
            }
            return lightEditorInfo;
        }
        LightEditorInfo lightEditorInfo = info;
        if (lightEditorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(22);
        }
        return lightEditorInfo;
    }

    @Nullable
    LightEditorInfo getEditorInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(23);
        }
        return this.myEditors.stream().filter(editorInfo -> file2.equals(editorInfo.getFile())).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditorManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfos";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditorManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedEditors";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "saveAs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCreateEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFileEditor";
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setImplicitSaveEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "closeEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fireFileStatusChanged";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findOpen";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitSaveAllowed";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveAs";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getEditorInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

