/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.io.InputStream;
import javax.swing.UIManager;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class TempUIThemeBasedLookAndFeelInfo
extends UIThemeBasedLookAndFeelInfo {
    private final VirtualFile mySchemeFile;
    private UIManager.LookAndFeelInfo myPreviousLaf;
    private static final Logger LOG = Logger.getInstance(TempUIThemeBasedLookAndFeelInfo.class);

    public TempUIThemeBasedLookAndFeelInfo(UITheme theme, VirtualFile editorSchemeFile) {
        super(theme);
        this.mySchemeFile = editorSchemeFile;
        this.myPreviousLaf = LafManager.getInstance().getCurrentLookAndFeel();
        if (this.myPreviousLaf instanceof TempUIThemeBasedLookAndFeelInfo) {
            this.myPreviousLaf = ((TempUIThemeBasedLookAndFeelInfo)this.myPreviousLaf).getPreviousLaf();
        }
    }

    public UIManager.LookAndFeelInfo getPreviousLaf() {
        return this.myPreviousLaf;
    }

    @Override
    protected void installEditorScheme() {
        String name = this.getTheme().getEditorScheme();
        if (name != null && this.mySchemeFile != null) {
            final EditorColorsManagerImpl cm = (EditorColorsManagerImpl)EditorColorsManager.getInstance();
            AbstractColorsScheme tmpScheme = new DefaultColorsScheme();
            boolean loaded = false;
            try {
                Element xml = JDOMUtil.load((InputStream)this.mySchemeFile.getInputStream());
                String parentSchemeName = xml.getAttributeValue("parent_scheme", "Default");
                EditorColorsScheme parentScheme = EditorColorsManager.getInstance().getScheme(parentSchemeName);
                tmpScheme = new EditorColorsSchemeImpl(parentScheme);
                tmpScheme.readExternal(xml);
                loaded = true;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            if (loaded) {
                final DefaultColorsScheme scheme = tmpScheme;
                EditorColorsManagerImpl.setTempScheme(scheme, this.mySchemeFile);
                cm.setGlobalScheme(scheme);
                final MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
                connect.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

                    public void globalSchemeChange(@Nullable EditorColorsScheme editorColorsScheme) {
                        if (editorColorsScheme == scheme || editorColorsScheme == null) {
                            return;
                        }
                        cm.getSchemeManager().removeScheme(scheme);
                        connect.disconnect();
                    }
                });
            }
        }
    }
}

