/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaJBPopupComboPopup;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DarculaComboBoxUI
extends BasicComboBoxUI
implements Border,
ErrorBorderCapable {
    private static final Color NON_EDITABLE_BACKGROUND = JBColor.namedColor((String)"ComboBox.nonEditableBackground", (Color)JBColor.namedColor((String)"ComboBox.darcula.nonEditableBackground", (Color)new JBColor(0xFCFCFC, 3948353)));
    private float myArc = DarculaUIUtil.COMPONENT_ARC.getFloat();
    private Insets myBorderCompensation = JBUI.insets((int)1);
    private boolean myPaintArrowButton = true;
    private KeyListener editorKeyListener;
    private FocusListener editorFocusListener;
    private PropertyChangeListener propertyListener;

    public DarculaComboBoxUI() {
    }

    public DarculaComboBoxUI(float arc, Insets borderCompensation, boolean paintArrowButton) {
        this.myArc = arc;
        this.myBorderCompensation = borderCompensation;
        this.myPaintArrowButton = paintArrowButton;
    }

    @Deprecated
    public DarculaComboBoxUI(JComboBox c) {
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaComboBoxUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installDarculaDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.uninstallDarculaDefaults();
    }

    protected void installDarculaDefaults() {
        this.comboBox.setBorder(this);
    }

    protected void uninstallDarculaDefaults() {
        this.comboBox.setBorder(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyListener = this.createPropertyListener();
        this.comboBox.addPropertyChangeListener(this.propertyListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this.propertyListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
    }

    @Override
    protected ComboPopup createPopup() {
        if (this.comboBox.getClientProperty("ComboBox.jbPopup") != null) {
            return new DarculaJBPopupComboPopup(this.comboBox);
        }
        return new CustomComboPopup(this.comboBox);
    }

    protected PropertyChangeListener createPropertyListener() {
        return e -> {
            EditorTextField etf;
            if ("enabled".equals(e.getPropertyName()) && (etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class))) != null) {
                boolean enabled = e.getNewValue() == Boolean.TRUE;
                Color color = UIManager.getColor(enabled ? "TextField.background" : "ComboBox.disabledBackground");
                etf.setBackground(color);
            }
        };
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.comboBox.getBackground();
        Color fg = this.comboBox.getForeground();
        BasicArrowButton button2 = new BasicArrowButton(5, bg, fg, fg, fg){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                Rectangle r = new Rectangle(this.getSize());
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1, (int)0, (int)1, (int)1));
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    g2.translate(r.x, r.y);
                    if (DarculaComboBoxUI.this.myPaintArrowButton) {
                        float bw = DarculaUIUtil.BW.getFloat();
                        float lw = DarculaUIUtil.LW.getFloat();
                        float arc = DarculaComboBoxUI.this.myArc;
                        arc = arc > bw + lw ? arc - bw - lw : 0.0f;
                        Path2D.Float innerShape = new Path2D.Float();
                        ((Path2D)innerShape).moveTo(lw, bw + lw);
                        ((Path2D)innerShape).lineTo((float)r.width - bw - lw - arc, bw + lw);
                        ((Path2D)innerShape).quadTo((float)r.width - bw - lw, bw + lw, (float)r.width - bw - lw, bw + lw + arc);
                        ((Path2D)innerShape).lineTo((float)r.width - bw - lw, (float)r.height - bw - lw - arc);
                        ((Path2D)innerShape).quadTo((float)r.width - bw - lw, (float)r.height - bw - lw, (float)r.width - bw - lw - arc, (float)r.height - bw - lw);
                        ((Path2D)innerShape).lineTo(lw, (float)r.height - bw - lw);
                        innerShape.closePath();
                        g2.setColor(JBUI.CurrentTheme.Arrow.backgroundColor((boolean)DarculaComboBoxUI.this.comboBox.isEnabled(), (boolean)DarculaComboBoxUI.this.comboBox.isEditable()));
                        g2.fill(innerShape);
                        if (DarculaComboBoxUI.this.comboBox.isEditable()) {
                            g2.setColor(DarculaUIUtil.getOutlineColor(DarculaComboBoxUI.this.comboBox.isEnabled(), false));
                            g2.fill(new Rectangle2D.Float(0.0f, bw + lw, DarculaUIUtil.LW.getFloat(), (float)r.height - (bw + lw) * 2.0f));
                        }
                    }
                    DarculaComboBoxUI.this.paintArrow(g2, this);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return DarculaComboBoxUI.getArrowButtonPreferredSize(DarculaComboBoxUI.this.comboBox);
            }
        };
        button2.setBorder((Border)JBUI.Borders.empty());
        button2.setOpaque(false);
        return button2;
    }

    protected void paintArrow(Graphics2D g2, JButton btn) {
        g2.setColor(JBUI.CurrentTheme.Arrow.foregroundColor((boolean)this.comboBox.isEnabled()));
        g2.fill(DarculaComboBoxUI.getArrowShape(btn));
    }

    @Deprecated
    protected Color getArrowButtonFillColor(Color defaultColor) {
        return JBUI.CurrentTheme.Arrow.backgroundColor((boolean)this.comboBox.isEnabled(), (boolean)this.comboBox.isEditable());
    }

    @NotNull
    static Dimension getArrowButtonPreferredSize(@Nullable JComboBox comboBox2) {
        Object i2 = comboBox2 != null ? comboBox2.getInsets() : DarculaComboBoxUI.getDefaultComboBoxInsets();
        int height = (DarculaUIUtil.isCompact(comboBox2) ? DarculaUIUtil.COMPACT_HEIGHT.get() : DarculaUIUtil.MINIMUM_HEIGHT.get()) + i2.top + i2.bottom;
        return new Dimension(DarculaUIUtil.ARROW_BUTTON_WIDTH.get() + i2.left, height);
    }

    static Shape getArrowShape(Component button2) {
        Rectangle r = new Rectangle(button2.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1, (int)0, (int)1, (int)1));
        int tW = JBUIScale.scale((int)9);
        int tH = JBUIScale.scale((int)5);
        int xU = (r.width - tW) / 2 - JBUIScale.scale((int)1);
        int yU = (r.height - tH) / 2 + JBUIScale.scale((int)1);
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(xU, yU);
        ((Path2D)path).lineTo(xU + tW, yU);
        ((Path2D)path).lineTo((float)xU + (float)tW / 2.0f, yU + tH);
        ((Path2D)path).lineTo(xU, yU);
        path.closePath();
        return path;
    }

    @NotNull
    private static JBInsets getDefaultComboBoxInsets() {
        JBInsets jBInsets = JBUI.insets((int)3);
        if (jBInsets == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(0);
        }
        return jBInsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (parent != null) {
            g.setColor(DarculaUIUtil.isTableCellEditor(c) && this.editor != null ? this.editor.getBackground() : parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)this.myBorderCompensation);
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float bw = DarculaUIUtil.BW.getFloat();
            g2.setColor(this.getBackgroundColor());
            g2.fill(this.getOuterShape(r, bw, this.myArc));
        }
        finally {
            g2.dispose();
        }
        if (!this.comboBox.isEditable()) {
            this.checkFocus();
            this.paintCurrentValue(g, this.rectangleForCurrentValue(), this.hasFocus);
        }
        this.currentValuePane.removeAll();
    }

    private Color getBackgroundColor() {
        Color coloredItemColor;
        Color bg = this.comboBox.getBackground();
        if (this.comboBox.isEditable() && this.editor != null) {
            return this.comboBox.isEnabled() ? this.editor.getBackground() : (this.comboBox.isBackgroundSet() && !(bg instanceof UIResource) ? bg : UIUtil.getComboBoxDisabledBackground());
        }
        Object value2 = this.comboBox.getSelectedItem();
        Color color = coloredItemColor = value2 instanceof ColoredItem ? ((ColoredItem)value2).getColor() : null;
        return (Color)ObjectUtils.notNull((Object)coloredItemColor, (Object)(this.comboBox.isBackgroundSet() && !(bg instanceof UIResource) ? bg : (this.comboBox.isEnabled() ? NON_EDITABLE_BACKGROUND : UIUtil.getComboBoxDisabledBackground())));
    }

    @Deprecated
    protected static boolean isTableCellEditor(JComponent c) {
        return DarculaUIUtil.isTableCellEditor(c);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds2, boolean hasFocus) {
        Object cc;
        boolean changeOpaque;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Object value2 = this.comboBox.getSelectedItem();
        Component c = renderer.getListCellRendererComponent(this.listBox, value2, -1, false, false);
        c.setFont(this.comboBox.getFont());
        c.setBackground(this.getBackgroundColor());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getForeground());
        } else {
            c.setForeground(this.comboBox.isEnabled() ? this.comboBox.getForeground() : JBColor.namedColor((String)"ComboBox.disabledForeground", (Color)this.comboBox.getForeground()));
        }
        boolean bl = changeOpaque = c instanceof JComponent && DarculaUIUtil.isTableCellEditor(this.comboBox) && c.isOpaque();
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        Rectangle r = new Rectangle(bounds2);
        Icon icon2 = null;
        Insets iPad = null;
        Border border = null;
        if (c instanceof SimpleColoredComponent) {
            cc = (SimpleColoredComponent)c;
            iPad = cc.getIpad();
            border = cc.getBorder();
            cc.setBorder((Border)JBUI.Borders.empty());
            cc.setIpad((Insets)JBUI.emptyInsets());
            icon2 = cc.getIcon();
            if (!cc.isIconOnTheRight()) {
                cc.setIcon(OffsetIcon.getOriginalIcon((Icon)icon2));
            }
        } else if (c instanceof JLabel) {
            cc = (JLabel)c;
            border = ((JComponent)cc).getBorder();
            ((JComponent)cc).setBorder((Border)JBUI.Borders.empty());
            icon2 = ((JLabel)cc).getIcon();
            ((JLabel)cc).setIcon(OffsetIcon.getOriginalIcon((Icon)icon2));
            String text = ((JLabel)cc).getText();
            int maxWidth = bounds2.width - (this.padding == null || StartupUiUtil.isUnderDarcula() ? 0 : this.padding.right);
            if (StringUtil.isNotEmpty((String)text) && ((JComponent)cc).getPreferredSize().width > maxWidth) {
                int max;
                int max0 = ObjectUtils.binarySearch((int)7, (int)(text.length() - 1), arg_0 -> DarculaComboBoxUI.lambda$paintCurrentValue$1((JLabel)cc, text, maxWidth, arg_0));
                int n = max = max0 < 0 ? -max0 - 2 : max0;
                if (max > 7 && max < text.length()) {
                    ((JLabel)cc).setText(StringUtil.trimMiddle((String)text, (int)max));
                }
            }
        } else if (c instanceof JComponent) {
            cc = (JComponent)c;
            border = ((JComponent)cc).getBorder();
            ((JComponent)cc).setBorder((Border)JBUI.Borders.empty());
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
        if (c instanceof SimpleColoredComponent) {
            cc = (SimpleColoredComponent)c;
            cc.setIpad(iPad);
            cc.setIcon(icon2);
            cc.setBorder(border);
        } else if (c instanceof JLabel) {
            cc = (JLabel)c;
            ((JComponent)cc).setBorder(border);
            ((JLabel)cc).setIcon(icon2);
        } else if (c instanceof JComponent) {
            cc = (JComponent)c;
            ((JComponent)cc).setBorder(border);
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        if (comboBoxEditor instanceof BasicComboBoxEditor) {
            JTextField tf = (JTextField)comboBoxEditor.getEditorComponent();
            tf.setColumns(0);
        }
        return comboBoxEditor;
    }

    protected void installEditorKeyListener(@NotNull ComboBoxEditor cbe) {
        Component ec;
        if (cbe == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(1);
        }
        if ((ec = cbe.getEditorComponent()) != null) {
            this.editorKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code = e.getKeyCode();
                    if ((code == 38 || code == 40) && e.getModifiers() == 0) {
                        DarculaComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }
            };
            ec.addKeyListener(this.editorKeyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JComponent)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        float bw = DarculaUIUtil.BW.getFloat();
        Rectangle r = new Rectangle(x, y, width, height);
        try {
            this.checkFocus();
            if (!DarculaUIUtil.isTableCellEditor(c)) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                JBInsets.removeFrom((Rectangle)r, (Insets)this.myBorderCompensation);
                g2.translate(r.x, r.y);
                float lw = DarculaUIUtil.LW.getFloat();
                Object op = this.comboBox.getClientProperty("JComponent.outline");
                if (this.comboBox.isEnabled() && op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, this.myArc, true, this.hasFocus, DarculaUIUtil.Outline.valueOf(op.toString()));
                } else {
                    if (this.hasFocus) {
                        DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, this.myArc, true, true, DarculaUIUtil.Outline.focus);
                    }
                    this.paintBorder(c, g2, bw, r, lw, this.myArc);
                }
            } else {
                DarculaUIUtil.paintCellEditorBorder(g2, c, r, this.hasFocus);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected void paintBorder(Component c, Graphics2D g2, float bw, Rectangle r, float lw, float arc) {
        Path2D.Float border = new Path2D.Float(0);
        border.append(this.getOuterShape(r, bw, arc), false);
        arc = arc > lw ? arc - lw : 0.0f;
        border.append(this.getInnerShape(r, bw, lw, arc), false);
        g2.setColor(DarculaUIUtil.getOutlineColor(c.isEnabled(), this.hasFocus));
        g2.fill(border);
    }

    protected RectangularShape getOuterShape(Rectangle r, float bw, float arc) {
        return new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc);
    }

    protected RectangularShape getInnerShape(Rectangle r, float bw, float lw, float arc) {
        return new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc, arc);
    }

    protected void checkFocus() {
        this.hasFocus = false;
        if (!this.comboBox.isEnabled()) {
            this.hasFocus = false;
            return;
        }
        this.hasFocus = DarculaComboBoxUI.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        ComboBoxEditor ed = this.comboBox.getEditor();
        if (ed != null) {
            this.hasFocus = DarculaComboBoxUI.hasFocus(ed.getEditorComponent());
        }
    }

    protected static boolean hasFocus(Component c) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return DarculaUIUtil.isTableCellEditor(c) || DarculaUIUtil.isCompact(c) ? JBInsets.create((int)2, (int)3) : DarculaComboBoxUI.getDefaultComboBoxInsets();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    protected Dimension getSizeWithButton(Dimension size, Dimension editorSize) {
        Insets i2 = this.getInsets();
        Dimension abSize = DarculaComboBoxUI.getArrowButtonPreferredSize(this.comboBox);
        if (DarculaUIUtil.isCompact(this.comboBox) && size != null) {
            JBInsets.removeFrom((Dimension)size, (Insets)this.padding);
        }
        int editorHeight = editorSize != null ? editorSize.height + i2.top + i2.bottom : 0;
        int editorWidth = editorSize != null ? editorSize.width + i2.left + this.padding.left + this.padding.right : 0;
        editorWidth = Math.max(editorWidth, DarculaUIUtil.MINIMUM_WIDTH.get() + i2.left);
        int width = size != null ? size.width : 0;
        int height = size != null ? size.height : 0;
        width = Math.max(editorWidth + abSize.width, width + this.padding.left);
        height = Math.max(Math.max(editorHeight, Math.max(abSize.height, height)), (DarculaUIUtil.isCompact(this.comboBox) ? DarculaUIUtil.COMPACT_HEIGHT.get() : DarculaUIUtil.MINIMUM_HEIGHT.get()) + i2.top + i2.bottom);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getSizeWithButton(super.getMinimumSize(c), this.editor != null ? this.editor.getPreferredSize() : null);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension minSize = super.getMinimumSize(c);
        Insets i2 = c.getInsets();
        minSize.width = DarculaUIUtil.MINIMUM_WIDTH.get() + DarculaUIUtil.ARROW_BUTTON_WIDTH.get() + i2.left + i2.right;
        return this.getSizeWithButton(minSize, this.editor != null ? this.editor.getMinimumSize() : null);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        this.installEditorKeyListener(this.comboBox.getEditor());
        if (this.editor instanceof JComponent) {
            JComponent jEditor = (JComponent)this.editor;
            jEditor.setOpaque(false);
            jEditor.setBorder((Border)JBUI.Borders.empty());
            this.editorFocusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.update();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.update();
                }

                private void update() {
                    if (DarculaComboBoxUI.this.comboBox != null) {
                        DarculaComboBoxUI.this.comboBox.repaint();
                    }
                }
            };
            if (this.editor instanceof JTextComponent) {
                this.editor.addFocusListener(this.editorFocusListener);
            } else {
                EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
                if (etf != null) {
                    etf.addFocusListener(this.editorFocusListener);
                    Color c = UIManager.getColor(this.comboBox.isEnabled() ? "TextField.background" : "ComboBox.disabledBackground");
                    etf.setBackground(c);
                }
            }
        }
        if (this.editor instanceof JPanel) {
            this.editor.setFocusable(false);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editorKeyListener != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
        }
        if (this.editor instanceof JTextComponent) {
            if (this.editorFocusListener != null) {
                this.editor.removeFocusListener(this.editorFocusListener);
            }
        } else {
            EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
            if (etf != null && this.editorFocusListener != null) {
                etf.removeFocusListener(this.editorFocusListener);
            }
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                if (DarculaComboBoxUI.this.arrowButton != null) {
                    Dimension aps = DarculaComboBoxUI.this.arrowButton.getPreferredSize();
                    if (cb.getComponentOrientation().isLeftToRight()) {
                        DarculaComboBoxUI.this.arrowButton.setBounds(cb.getWidth() - aps.width, 0, aps.width, cb.getHeight());
                    } else {
                        DarculaComboBoxUI.this.arrowButton.setBounds(0, 0, aps.width, cb.getHeight());
                    }
                }
                DarculaComboBoxUI.this.layoutEditor();
            }
        };
    }

    protected void layoutEditor() {
        if (this.comboBox.isEditable() && this.editor != null) {
            Rectangle er = this.rectangleForCurrentValue();
            Dimension eps = this.editor.getPreferredSize();
            if (eps.height < er.height) {
                int delta = (er.height - eps.height) / 2;
                er.y += delta;
            }
            er.height = eps.height;
            this.editor.setBounds(er);
        }
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle rect = new Rectangle(this.comboBox.getSize());
        Insets i2 = this.getInsets();
        JBInsets.removeFrom((Rectangle)rect, (Insets)i2);
        rect.width = rect.width - (this.arrowButton != null ? this.arrowButton.getWidth() - i2.left : rect.height);
        JBInsets.removeFrom((Rectangle)rect, (Insets)this.padding);
        rect.width = rect.width + (this.comboBox.isEditable() ? 0 : this.padding.right);
        return rect;
    }

    private static /* synthetic */ int lambda$paintCurrentValue$1(JLabel cc, String text, int maxWidth, int idx) {
        cc.setText(StringUtil.trimMiddle((String)text, (int)idx));
        return Comparing.compare((int)cc.getPreferredSize().width, (int)maxWidth);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cbe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultComboBoxInsets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installEditorKeyListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class CustomComboPopup
    extends BasicComboPopup {
        public CustomComboPopup(JComboBox combo) {
            super(combo);
        }

        @Override
        protected void configurePopup() {
            super.configurePopup();
            Border border = UIManager.getBorder("ComboPopup.border");
            this.setBorder((Border)(border != null ? border : (SystemInfo.isMac ? JBUI.Borders.empty() : IdeBorderFactory.createBorder())));
            this.putClientProperty("JComboBox.isCellEditor", DarculaUIUtil.isTableCellEditor(this.comboBox));
        }

        @Override
        public void updateUI() {
            this.setUI(new BasicPopupMenuUI(){

                @Override
                public void uninstallDefaults() {
                }

                @Override
                public void installDefaults() {
                    if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
                        this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
                    }
                    this.popupMenu.setOpaque(true);
                    LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
                }
            });
        }

        @Override
        public void show(Component invoker, int x, int y) {
            if (this.comboBox instanceof ComboBoxWithWidePopup) {
                Dimension popupSize = this.comboBox.getSize();
                int minPopupWidth = ((ComboBoxWithWidePopup)this.comboBox).getMinimumPopupWidth();
                Insets insets = this.getInsets();
                popupSize.width = Math.max(popupSize.width, minPopupWidth);
                popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                this.scroller.setMaximumSize(popupSize);
                this.scroller.setPreferredSize(popupSize);
                this.scroller.setMinimumSize(popupSize);
                this.list.revalidate();
            }
            super.show(invoker, x, y);
        }

        @Override
        protected void configureList() {
            super.configureList();
            this.list.setCellRenderer(new MyDelegateRenderer());
        }

        protected void customizeListRendererComponent(JComponent component2) {
            component2.setBorder((Border)JBUI.Borders.empty((int)2, (int)8));
        }

        @Override
        protected PropertyChangeListener createPropertyChangeListener() {
            final PropertyChangeListener listener2 = super.createPropertyChangeListener();
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    listener2.propertyChange(evt);
                    if ("renderer".equals(evt.getPropertyName()) && !(list.getCellRenderer() instanceof MyDelegateRenderer)) {
                        list.setCellRenderer(new MyDelegateRenderer());
                    }
                }
            };
        }

        @Override
        protected int getPopupHeightForRowCount(int maxRowCount) {
            Insets insets;
            Border border;
            int minRowCount = Math.min(maxRowCount, this.comboBox.getItemCount());
            int height = 0;
            ListCellRenderer renderer = this.list.getCellRenderer();
            for (int i2 = 0; i2 < minRowCount; ++i2) {
                Object value2 = this.list.getModel().getElementAt(i2);
                Component c = renderer.getListCellRendererComponent(this.list, value2, i2, false, false);
                height += UIUtil.updateListRowHeight((Dimension)c.getPreferredSize()).height;
            }
            if (height == 0) {
                height = this.comboBox.getHeight();
            }
            if ((border = this.scroller.getViewportBorder()) != null) {
                insets = border.getBorderInsets(null);
                height += insets.top + insets.bottom;
            }
            if ((border = this.scroller.getBorder()) != null) {
                insets = border.getBorderInsets(null);
                height += insets.top + insets.bottom;
            }
            return height;
        }

        private class MyDelegateRenderer
        implements ListCellRenderer {
            private MyDelegateRenderer() {
            }

            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component component2 = CustomComboPopup.this.comboBox.getRenderer().getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                if (component2 instanceof JComponent) {
                    CustomComboPopup.this.customizeListRendererComponent((JComponent)component2);
                }
                return component2;
            }
        }
    }
}

