/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupUtil;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.DirectoryChooserView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryChooserModuleTreeView
implements DirectoryChooserView {
    private static final Comparator<DefaultMutableTreeNode> NODE_COMPARATOR = (node1, node2) -> {
        Object o1 = node1.getUserObject();
        Object o2 = node2.getUserObject();
        if (o1 instanceof Module && o2 instanceof Module) {
            return ((Module)o1).getName().compareToIgnoreCase(((Module)o2).getName());
        }
        if (o1 instanceof ModuleGroup && o2 instanceof ModuleGroup) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
        if (o1 instanceof ModuleGroup) {
            return -1;
        }
        if (o1 instanceof DirectoryChooser.ItemWrapper && o2 instanceof DirectoryChooser.ItemWrapper) {
            VirtualFile virtualFile1 = ((DirectoryChooser.ItemWrapper)o1).getDirectory().getVirtualFile();
            VirtualFile virtualFile2 = ((DirectoryChooser.ItemWrapper)o2).getDirectory().getVirtualFile();
            return Comparing.compare((Comparable)((Object)virtualFile1.getPath()), (Comparable)((Object)virtualFile2.getPath()));
        }
        return 1;
    };
    private final Tree myTree;
    private final List<DirectoryChooser.ItemWrapper> myItems;
    private final Map<DirectoryChooser.ItemWrapper, DefaultMutableTreeNode> myItemNodes;
    private final Map<Module, DefaultMutableTreeNode> myModuleNodes;
    private final Map<ModuleGroup, DefaultMutableTreeNode> myModuleGroupNodes;
    private final DefaultMutableTreeNode myRootNode;
    private final ProjectFileIndex myFileIndex;
    private final ModuleGrouper myModuleGrouper;

    DirectoryChooserModuleTreeView(@NotNull Project project) {
        if (project == null) {
            DirectoryChooserModuleTreeView.$$$reportNull$$$0(0);
        }
        this.myItems = new ArrayList<DirectoryChooser.ItemWrapper>();
        this.myItemNodes = new HashMap<DirectoryChooser.ItemWrapper, DefaultMutableTreeNode>();
        this.myModuleNodes = new HashMap<Module, DefaultMutableTreeNode>();
        this.myModuleGroupNodes = new HashMap<ModuleGroup, DefaultMutableTreeNode>();
        this.myRootNode = new DefaultMutableTreeNode();
        this.myTree = new Tree((TreeNode)this.myRootNode);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myModuleGrouper = ModuleGrouper.instanceFor((Project)project);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        new TreeSpeedSearch(this.myTree, (Convertor<? super TreePath, String>)((Convertor)o -> {
            Object userObject = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
            if (userObject instanceof Module) {
                return ((Module)userObject).getName();
            }
            if (userObject == null) {
                return "";
            }
            return userObject.toString();
        }), true);
    }

    @Override
    public void clearItems() {
        this.myRootNode.removeAllChildren();
        this.myItems.clear();
        this.myItemNodes.clear();
        this.myModuleNodes.clear();
        this.myModuleGroupNodes.clear();
        this.myRootNode.removeAllChildren();
        ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged(this.myRootNode);
    }

    @Override
    public JComponent getComponent() {
        return this.myTree;
    }

    @Override
    public void onSelectionChange(Runnable runnable2) {
        this.myTree.getSelectionModel().addTreeSelectionListener(e -> runnable2.run());
    }

    @Override
    public DirectoryChooser.ItemWrapper getItemByIndex(int i2) {
        return this.myItems.get(i2);
    }

    @Override
    public void clearSelection() {
        this.myTree.clearSelection();
    }

    @Override
    public void selectItemByIndex(int selectionIndex) {
        if (selectionIndex < 0) {
            this.myTree.clearSelection();
        } else {
            DirectoryChooser.ItemWrapper itemWrapper = this.myItems.get(selectionIndex);
            DefaultMutableTreeNode node = this.myItemNodes.get(itemWrapper);
            TreePath treePath = this.expandNode(node);
            this.myTree.setSelectionPath(treePath);
            this.myTree.scrollPathToVisible(treePath);
        }
    }

    private TreePath expandNode(DefaultMutableTreeNode node) {
        TreePath treePath;
        Object[] path = node.getPath();
        TreePath expandPath = treePath = new TreePath(path);
        if (this.myTree.getModel().isLeaf(expandPath.getLastPathComponent())) {
            expandPath = expandPath.getParentPath();
        }
        this.myTree.expandPath(expandPath);
        return treePath;
    }

    @Override
    public void addItem(DirectoryChooser.ItemWrapper itemWrapper) {
        this.myItems.add(itemWrapper);
        PsiDirectory directory = itemWrapper.getDirectory();
        Module module = this.myFileIndex.getModuleForFile(directory.getVirtualFile());
        DefaultMutableTreeNode node = this.myModuleNodes.get(module);
        if (node == null) {
            List groupPath;
            node = new DefaultMutableTreeNode(module, true);
            List list2 = groupPath = module != null ? this.myModuleGrouper.getGroupPath(module) : null;
            if (groupPath == null || groupPath.isEmpty()) {
                this.insertNode(node, this.myRootNode);
            } else {
                DefaultMutableTreeNode parentNode = ModuleGroupUtil.buildModuleGroupPath(new ModuleGroup(groupPath), this.myRootNode, this.myModuleGroupNodes, parentChildRelation -> this.insertNode((DefaultMutableTreeNode)parentChildRelation.getChild(), (DefaultMutableTreeNode)parentChildRelation.getParent()), moduleGroup -> new DefaultMutableTreeNode(moduleGroup, true));
                this.insertNode(node, parentNode);
            }
            this.myModuleNodes.put(module, node);
        }
        DefaultMutableTreeNode itemNode = new DefaultMutableTreeNode(itemWrapper, false);
        this.myItemNodes.put(itemWrapper, itemNode);
        this.insertNode(itemNode, node);
        ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged(node);
    }

    private void insertNode(DefaultMutableTreeNode nodeToInsert, DefaultMutableTreeNode parentNode) {
        TreeUtil.insertNode((MutableTreeNode)nodeToInsert, (MutableTreeNode)parentNode, (DefaultTreeModel)((DefaultTreeModel)this.myTree.getModel()), NODE_COMPARATOR);
    }

    @Override
    public void listFilled() {
        Iterator<DefaultMutableTreeNode> iterator2;
        if (this.myModuleNodes.size() == 1 && (iterator2 = this.myItemNodes.values().iterator()).hasNext()) {
            DefaultMutableTreeNode node = iterator2.next();
            this.expandNode(node);
        }
    }

    @Override
    public int getItemsSize() {
        return this.myItems.size();
    }

    @Override
    @Nullable
    public DirectoryChooser.ItemWrapper getSelectedItem() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        return node.getUserObject() instanceof DirectoryChooser.ItemWrapper ? (DirectoryChooser.ItemWrapper)node.getUserObject() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/DirectoryChooserModuleTreeView", "<init>"));
    }

    private class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object nodeValue, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object value2;
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if ((value2 = ((DefaultMutableTreeNode)nodeValue).getUserObject()) instanceof DirectoryChooser.ItemWrapper) {
                DirectoryChooser.PathFragment[] fragments;
                DirectoryChooser.ItemWrapper wrapper2 = (DirectoryChooser.ItemWrapper)value2;
                for (DirectoryChooser.PathFragment fragment : fragments = wrapper2.getFragments()) {
                    this.append(fragment.getText(), fragment.isCommon() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
                this.setIcon(wrapper2.getIcon((FileIndex)DirectoryChooserModuleTreeView.this.myFileIndex));
            } else if (value2 instanceof Module) {
                Module module = (Module)value2;
                this.append(DirectoryChooserModuleTreeView.this.myModuleGrouper.getShortenedName(module), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(ModuleType.get((Module)module).getIcon());
            } else if (value2 instanceof ModuleGroup) {
                this.append(value2.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(PlatformIcons.CLOSED_MODULE_GROUP_ICON);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/DirectoryChooserModuleTreeView$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

