/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkupModelWindow
extends UserDataHolderBase
implements MarkupModelEx {
    private final DocumentWindow myDocument;
    private final MarkupModelEx myHostModel;

    public MarkupModelWindow(MarkupModelEx editorMarkupModel, DocumentWindow document) {
        this.myDocument = document;
        this.myHostModel = editorMarkupModel;
    }

    @NotNull
    public Document getDocument() {
        DocumentWindow documentWindow = this.myDocument;
        if (documentWindow == null) {
            MarkupModelWindow.$$$reportNull$$$0(0);
        }
        return documentWindow;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            MarkupModelWindow.$$$reportNull$$$0(1);
        }
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeHighlighter rangeHighlighter = this.myHostModel.addRangeHighlighter(textAttributesKey, hostRange.getStartOffset(), hostRange.getEndOffset(), layer, targetArea);
        if (rangeHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(2);
        }
        return rangeHighlighter;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, @Nullable TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            MarkupModelWindow.$$$reportNull$$$0(3);
        }
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeHighlighter rangeHighlighter = this.myHostModel.addRangeHighlighter(hostRange.getStartOffset(), hostRange.getEndOffset(), layer, textAttributes, targetArea);
        if (rangeHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(4);
        }
        return rangeHighlighter;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, @Nullable Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            MarkupModelWindow.$$$reportNull$$$0(5);
        }
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeHighlighterEx rangeHighlighterEx = this.myHostModel.addRangeHighlighterAndChangeAttributes(textAttributesKey, hostRange.getStartOffset(), hostRange.getEndOffset(), layer, targetArea, isPersistent, changeAttributesAction);
        if (rangeHighlighterEx == null) {
            MarkupModelWindow.$$$reportNull$$$0(6);
        }
        return rangeHighlighterEx;
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(7);
        }
        if (changeAttributesAction == null) {
            MarkupModelWindow.$$$reportNull$$$0(8);
        }
        this.myHostModel.changeAttributesInBatch(highlighter, changeAttributesAction);
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(@Nullable TextAttributesKey textAttributesKey, int line, int layer) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        RangeHighlighter rangeHighlighter = this.myHostModel.addLineHighlighter(textAttributesKey, hostLine, layer);
        if (rangeHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(9);
        }
        return rangeHighlighter;
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, @Nullable TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        RangeHighlighter rangeHighlighter = this.myHostModel.addLineHighlighter(hostLine, layer, textAttributes);
        if (rangeHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(10);
        }
        return rangeHighlighter;
    }

    public void removeHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        if (rangeHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(11);
        }
        this.myHostModel.removeHighlighter(rangeHighlighter);
    }

    public void removeAllHighlighters() {
        this.myHostModel.removeAllHighlighters();
    }

    public RangeHighlighter @NotNull [] getAllHighlighters() {
        RangeHighlighter[] rangeHighlighterArray = this.myHostModel.getAllHighlighters();
        if (rangeHighlighterArray == null) {
            MarkupModelWindow.$$$reportNull$$$0(12);
        }
        return rangeHighlighterArray;
    }

    @Override
    public void dispose() {
        this.myHostModel.dispose();
    }

    @Override
    public RangeHighlighterEx addPersistentLineHighlighter(@Nullable TextAttributesKey textAttributesKey, int line, int layer) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        return this.myHostModel.addPersistentLineHighlighter(textAttributesKey, hostLine, layer);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, @Nullable TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(lineNumber);
        return this.myHostModel.addPersistentLineHighlighter(hostLine, layer, textAttributes);
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(13);
        }
        return this.myHostModel.containsHighlighter(highlighter);
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        if (parentDisposable == null) {
            MarkupModelWindow.$$$reportNull$$$0(14);
        }
        if (listener2 == null) {
            MarkupModelWindow.$$$reportNull$$$0(15);
        }
        this.myHostModel.addMarkupModelListener(parentDisposable, listener2);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        if (highlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(16);
        }
        if (textAttributes == null) {
            MarkupModelWindow.$$$reportNull$$$0(17);
        }
        this.myHostModel.setRangeHighlighterAttributes(highlighter, textAttributes);
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            MarkupModelWindow.$$$reportNull$$$0(18);
        }
        return false;
    }

    @Override
    public boolean processRangeHighlightersOutside(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            MarkupModelWindow.$$$reportNull$$$0(19);
        }
        return false;
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        MarkupIterator<RangeHighlighterEx> markupIterator = this.myHostModel.overlappingIterator(startOffset, endOffset);
        if (markupIterator == null) {
            MarkupModelWindow.$$$reportNull$$$0(20);
        }
        return markupIterator;
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset, boolean onlyRenderedInGutter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged, boolean fontStyleChanged) {
        if (segmentHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(21);
        }
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(22);
        }
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(23);
        }
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (marker == null) {
            MarkupModelWindow.$$$reportNull$$$0(24);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/injected/editor/MarkupModelWindow";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetArea";
                break;
            }
            case 7: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeAttributesAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeHighlighter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentHighlighter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/injected/editor/MarkupModelWindow";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineHighlighter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHighlighters";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "overlappingIterator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeAttributesInBatch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsHighlighter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addMarkupModelListener";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setRangeHighlighterAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOverlappingWith";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOutside";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fireAttributesChanged";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterAdded";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeRemoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

