/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.ide.actions.ToolWindowMoveAction;
import com.intellij.ide.actions.ToolWindowViewModeAction;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAllowlistEP;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowCollector {
    private static final ToolWindowInfo UNKNOWN = new ToolWindowInfo("unknown", PluginInfoDetectorKt.getUnknownPlugin());
    private static final Map<String, ToolWindowInfo> ourToolwindowWhitelist = new HashMap<String, ToolWindowInfo>();

    public static ToolWindowCollector getInstance() {
        return (ToolWindowCollector)ServiceManager.getService(ToolWindowCollector.class);
    }

    private ToolWindowCollector() {
        for (ToolWindowAllowlistEP extension : ToolWindowAllowlistEP.EP_NAME.getExtensionList()) {
            ToolWindowCollector.addToolwindowToWhitelist(extension);
        }
        ToolWindowAllowlistEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ToolWindowAllowlistEP>(){

            public void extensionAdded(@NotNull ToolWindowAllowlistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ToolWindowCollector.addToolwindowToWhitelist(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    private static void addToolwindowToWhitelist(ToolWindowAllowlistEP extension) {
        PluginInfo info;
        PluginDescriptor pluginDescriptor = extension == null ? null : extension.getPluginDescriptor();
        PluginInfo pluginInfo = info = pluginDescriptor != null ? PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor) : null;
        if (info != null && info.isDevelopedByJetBrains()) {
            ourToolwindowWhitelist.put(extension.id, new ToolWindowInfo(extension.id, info));
        }
    }

    public void recordActivation(@Nullable String toolWindowId, @Nullable WindowInfoImpl info) {
        ToolWindowCollector.record(toolWindowId, ToolWindowEventType.ACTIVATED, info);
    }

    public void recordHidden(@NotNull WindowInfoImpl info) {
        if (info == null) {
            ToolWindowCollector.$$$reportNull$$$0(0);
        }
        ToolWindowCollector.record(info.getId(), ToolWindowEventType.HIDDEN, info);
    }

    public void recordShown(@NotNull WindowInfoImpl info) {
        if (info == null) {
            ToolWindowCollector.$$$reportNull$$$0(1);
        }
        ToolWindowCollector.record(info.getId(), ToolWindowEventType.SHOWN, info);
    }

    public void recordClick(String toolWindowId, @Nullable WindowInfoImpl info) {
        ToolWindowCollector.record(toolWindowId, ToolWindowEventType.CLICKED, info);
    }

    private static void record(@Nullable String toolWindowId, @NotNull ToolWindowEventType eventType, @Nullable WindowInfoImpl windowInfo) {
        if (eventType == null) {
            ToolWindowCollector.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)toolWindowId)) {
            return;
        }
        ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId);
        FeatureUsageData data2 = new FeatureUsageData().addData("id", info.myRecordedId).addPluginInfo(info.myPluginInfo);
        if (windowInfo != null) {
            data2.addData("ViewMode", ToolWindowViewModeAction.ViewMode.fromWindowInfo(windowInfo).toString());
            data2.addData("Location", ToolWindowMoveAction.Anchor.fromWindowInfo(windowInfo).toString());
        }
        FUCounterUsageLogger.getInstance().logEvent("toolwindow", StringUtil.toLowerCase((String)eventType.name()), data2);
    }

    @NotNull
    private static ToolWindowInfo getToolWindowInfo(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(3);
        }
        if (ourToolwindowWhitelist.containsKey(toolWindowId)) {
            ToolWindowInfo toolWindowInfo = ourToolwindowWhitelist.get(toolWindowId);
            if (toolWindowInfo == null) {
                ToolWindowCollector.$$$reportNull$$$0(4);
            }
            return toolWindowInfo;
        }
        ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions());
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        ToolWindowInfo toolWindowInfo = info != null ? info : UNKNOWN;
        if (toolWindowInfo == null) {
            ToolWindowCollector.$$$reportNull$$$0(5);
        }
        return toolWindowInfo;
    }

    @Nullable
    public static ToolWindowInfo getToolWindowInfo(@NotNull String toolWindowId, ToolWindowEP @NotNull [] toolWindows) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(6);
        }
        if (toolWindows == null) {
            ToolWindowCollector.$$$reportNull$$$0(7);
        }
        for (ToolWindowEP ep2 : toolWindows) {
            if (!StringUtil.equals((CharSequence)toolWindowId, (CharSequence)ep2.id)) continue;
            PluginDescriptor pluginDescriptor = ep2.getPluginDescriptor();
            return new ToolWindowInfo(ep2.id, PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor));
        }
        return null;
    }

    static {
        ourToolwindowWhitelist.put("Messages", new ToolWindowInfo("Messages"));
        ourToolwindowWhitelist.put("Debug", new ToolWindowInfo("Debug"));
        ourToolwindowWhitelist.put("Run", new ToolWindowInfo("Run"));
        ourToolwindowWhitelist.put("Build", new ToolWindowInfo("Build"));
        ourToolwindowWhitelist.put("Find", new ToolWindowInfo("Find"));
        ourToolwindowWhitelist.put("CVS", new ToolWindowInfo("CVS"));
        ourToolwindowWhitelist.put("Hierarchy", new ToolWindowInfo("Hierarchy"));
        ourToolwindowWhitelist.put("Inspection Results", new ToolWindowInfo("Inspection_Results"));
        ourToolwindowWhitelist.put("Dependency Viewer", new ToolWindowInfo("Dependency_Viewer"));
        ourToolwindowWhitelist.put("Module Dependencies", new ToolWindowInfo("Module_Dependencies"));
        ourToolwindowWhitelist.put("Duplicates", new ToolWindowInfo("Duplicates"));
        ourToolwindowWhitelist.put("Extract Method", new ToolWindowInfo("Extract_Method"));
        ourToolwindowWhitelist.put("Documentation", new ToolWindowInfo("Documentation"));
        ourToolwindowWhitelist.put("Preview", new ToolWindowInfo("Preview"));
        ourToolwindowWhitelist.put("Run Dashboard", new ToolWindowInfo("Run_Dashboard"));
        ourToolwindowWhitelist.put("Services", new ToolWindowInfo("Services"));
        ourToolwindowWhitelist.put("Endpoints", new ToolWindowInfo("Endpoints"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recordHidden";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordShown";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowInfo";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToolWindowInfo {
        private final String myRecordedId;
        private final PluginInfo myPluginInfo;

        private ToolWindowInfo(@NotNull String recordedId) {
            if (recordedId == null) {
                ToolWindowInfo.$$$reportNull$$$0(0);
            }
            this(recordedId, PluginInfoDetectorKt.getPlatformPlugin());
        }

        private ToolWindowInfo(@NotNull String recordedId, @NotNull PluginInfo info) {
            if (recordedId == null) {
                ToolWindowInfo.$$$reportNull$$$0(1);
            }
            if (info == null) {
                ToolWindowInfo.$$$reportNull$$$0(2);
            }
            this.myRecordedId = recordedId;
            this.myPluginInfo = info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "recordedId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToolWindowUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "toolwindow".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(1);
            }
            if ("unknown".equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ToolWindowUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ToolWindowUtilValidator.acceptWhenReportedByJetBrainsPlugin((EventContext)context);
            if (validationResultType == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum ToolWindowEventType {
        ACTIVATED,
        CLICKED,
        SHOWN,
        HIDDEN;

    }
}

