/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a8\u0006\u0010"}, d2={"addExternalSystemId", "", "data", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "anonymizeSystemId", "", "getAnonymizedSystemId", "importActivityStarted", "Lcom/intellij/internal/statistic/IdeActivity;", "project", "Lcom/intellij/openapi/project/Project;", "externalSystemId", "dataConsumer", "Ljava/util/function/Consumer;", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemStatUtilKt {
    @NotNull
    public static final String getAnonymizedSystemId(@NotNull ProjectSystemId systemId) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)systemId, (String)"systemId");
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)systemId);
        if (externalSystemManager == null) {
            return "undefined.system";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)externalSystemManager, (String)"ExternalSystemApiUtil.ge\u2026return \"undefined.system\"");
        ExternalSystemManager manager = externalSystemManager;
        if (PluginInfoDetectorKt.getPluginInfo(manager.getClass()).isDevelopedByJetBrains()) {
            String string2 = systemId.getReadableName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"systemId.readableName");
        } else {
            string = "third.party";
        }
        return string;
    }

    public static final void addExternalSystemId(@NotNull FeatureUsageData data2, @Nullable ProjectSystemId systemId) {
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        data2.addData("system_id", ExternalSystemStatUtilKt.anonymizeSystemId(systemId));
    }

    @NotNull
    public static final String anonymizeSystemId(@Nullable ProjectSystemId systemId) {
        Object object;
        block3: {
            block2: {
                object = systemId;
                if (object == null) break block2;
                ProjectSystemId projectSystemId = object;
                boolean bl = false;
                boolean bl2 = false;
                ProjectSystemId it = projectSystemId;
                boolean bl3 = false;
                object = ExternalSystemStatUtilKt.getAnonymizedSystemId(it);
                if (object != null) break block3;
            }
            object = "undefined.system";
        }
        return object;
    }

    @NotNull
    public static final IdeActivity importActivityStarted(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull Consumer<FeatureUsageData> dataConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)externalSystemId, (String)"externalSystemId");
        Intrinsics.checkParameterIsNotNull(dataConsumer, (String)"dataConsumer");
        return new IdeActivity(project, "project.import", null, 4, null).startedWithData((Consumer)new Consumer<FeatureUsageData>(externalSystemId, dataConsumer){
            final /* synthetic */ ProjectSystemId $externalSystemId;
            final /* synthetic */ Consumer $dataConsumer;

            public final void accept(@NotNull FeatureUsageData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ExternalSystemStatUtilKt.addExternalSystemId(it, this.$externalSystemId);
                this.$dataConsumer.accept(it);
            }
            {
                this.$externalSystemId = projectSystemId;
                this.$dataConsumer = consumer;
            }
        });
    }
}

