/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.util.CrcCache;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a'\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001a\u0010\u000e\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u000e\u001a\u00020\u0004*\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006\u001a#\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u001b\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a3\u0010\u0014\u001a\u00020\u0004\"\b\b\u0000\u0010\u0015*\u00020\u0016*\u0002H\u00152\u0006\u0010\u0017\u001a\u00020\u00042\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0019H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\u001b\u0010\u001b\u001a\u0004\u0018\u00010\u0004*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u001c\u001a\u001c\u0010\u001d\u001a\u00020\u001e*\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u001a$\u0010 \u001a\u00020\u001e*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0014\u0010 \u001a\u00020\u001e*\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"CRC_CACHE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/externalSystem/util/CrcCache;", "doCalculateCrc", "", "project", "Lcom/intellij/openapi/project/Project;", "charSequence", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/CharSequence;Lcom/intellij/openapi/fileTypes/FileType;)Ljava/lang/Long;", "getParserDefinition", "Lcom/intellij/lang/ParserDefinition;", "calculateCrc", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileTypes/FileType;)Ljava/lang/Long;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Ljava/lang/Long;", "findOrCalculateCrc", "T", "Lcom/intellij/openapi/util/UserDataHolder;", "modificationStamp", "calculate", "Lkotlin/Function0;", "(Lcom/intellij/openapi/util/UserDataHolder;JLkotlin/jvm/functions/Function0;)J", "getCachedCrc", "(Lcom/intellij/openapi/util/UserDataHolder;J)Ljava/lang/Long;", "setCachedCrc", "", "value", "update", "Ljava/util/zip/CRC32;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "tokenText", "ignoredTokens", "Lcom/intellij/psi/tree/TokenSet;", "intellij.platform.externalSystem.impl"})
@JvmName(name="CrcUtils")
public final class CrcUtils {
    private static final Key<CrcCache> CRC_CACHE = new Key("com.intellij.openapi.externalSystem.util.CRC_CACHE");

    public static final long calculateCrc(@NotNull Document $this$calculateCrc, @NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$calculateCrc, (String)"$this$calculateCrc");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Long l = CrcUtils.getCachedCrc((UserDataHolder)file2, $this$calculateCrc.getModificationStamp());
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            return it;
        }
        return CrcUtils.findOrCalculateCrc((UserDataHolder)$this$calculateCrc, $this$calculateCrc.getModificationStamp(), (Function0<Long>)((Function0)new Function0<Long>($this$calculateCrc, project, file2){
            final /* synthetic */ Document $this_calculateCrc;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;

            @Nullable
            public final Long invoke() {
                FileType fileType = this.$file.getFileType();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"file.fileType");
                return CrcUtils.access$doCalculateCrc(this.$this_calculateCrc, this.$project, fileType);
            }
            {
                this.$this_calculateCrc = document;
                this.$project = project;
                this.$file = virtualFile;
                super(0);
            }
        }));
    }

    public static final long calculateCrc(@NotNull VirtualFile $this$calculateCrc, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$this$calculateCrc, (String)"$this$calculateCrc");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return CrcUtils.findOrCalculateCrc((UserDataHolder)$this$calculateCrc, $this$calculateCrc.getModificationStamp(), (Function0<Long>)((Function0)new Function0<Long>($this$calculateCrc, project){
            final /* synthetic */ VirtualFile $this_calculateCrc;
            final /* synthetic */ Project $project;

            @Nullable
            public final Long invoke() {
                return CrcUtils.access$doCalculateCrc(this.$this_calculateCrc, this.$project);
            }
            {
                this.$this_calculateCrc = virtualFile;
                this.$project = project;
                super(0);
            }
        }));
    }

    private static final <T extends UserDataHolder> long findOrCalculateCrc(@NotNull T $this$findOrCalculateCrc, long modificationStamp, Function0<Long> calculate) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Long cachedCrc = CrcUtils.getCachedCrc($this$findOrCalculateCrc, modificationStamp);
        if (cachedCrc != null) {
            return cachedCrc;
        }
        Long l = (Long)calculate.invoke();
        long crc = l != null ? l : modificationStamp;
        CrcUtils.setCachedCrc($this$findOrCalculateCrc, crc, modificationStamp);
        return crc;
    }

    private static final Long doCalculateCrc(Project project, CharSequence charSequence, FileType fileType) {
        ParserDefinition parserDefinition = CrcUtils.getParserDefinition(fileType);
        if (parserDefinition == null) {
            return null;
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        Lexer lexer = parserDefinition2.createLexer(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)lexer, (String)"parserDefinition.createLexer(project)");
        Lexer lexer2 = lexer;
        TokenSet tokenSet = parserDefinition2.getWhitespaceTokens();
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"parserDefinition.whitespaceTokens");
        TokenSet whiteSpaceTokens = tokenSet;
        TokenSet tokenSet2 = parserDefinition2.getCommentTokens();
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"parserDefinition.commentTokens");
        TokenSet commentTokens = tokenSet2;
        TokenSet tokenSet3 = TokenSet.orSet((TokenSet[])new TokenSet[]{commentTokens, whiteSpaceTokens});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet3, (String)"TokenSet.orSet(commentTokens, whiteSpaceTokens)");
        TokenSet ignoredTokens = tokenSet3;
        CRC32 crc32 = new CRC32();
        lexer2.start(charSequence);
        ProgressManager.checkCanceled();
        while (lexer2.getTokenType() != null) {
            IElementType tokenType;
            Intrinsics.checkExpressionValueIsNotNull((Object)tokenType, (String)"lexer.tokenType ?: break");
            CharSequence tokenText = charSequence.subSequence(lexer2.getTokenStart(), lexer2.getTokenEnd());
            CrcUtils.update(crc32, tokenType, tokenText, ignoredTokens);
            lexer2.advance();
            ProgressManager.checkCanceled();
        }
        return crc32.getValue();
    }

    private static final void update(@NotNull CRC32 $this$update, IElementType tokenType, CharSequence tokenText, TokenSet ignoredTokens) {
        if (ignoredTokens.contains(tokenType)) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)tokenText)) {
            return;
        }
        CrcUtils.update($this$update, tokenText);
    }

    private static final void update(@NotNull CRC32 $this$update, CharSequence charSequence) {
        $this$update.update(charSequence.length());
        CharSequence charSequence2 = charSequence;
        for (int j = 0; j < charSequence2.length(); ++j) {
            char ch = charSequence2.charAt(j);
            $this$update.update(ch);
        }
    }

    private static final ParserDefinition getParserDefinition(FileType fileType) {
        FileType fileType2 = fileType;
        return fileType2 instanceof LanguageFileType ? (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage()) : null;
    }

    private static final Long doCalculateCrc(@NotNull Document $this$doCalculateCrc, Project project, FileType fileType) {
        Long l;
        if (fileType.isBinary()) {
            l = null;
        } else {
            CharSequence charSequence = $this$doCalculateCrc.getImmutableCharSequence();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"immutableCharSequence");
            l = CrcUtils.doCalculateCrc(project, charSequence, fileType);
        }
        return l;
    }

    private static final Long doCalculateCrc(@NotNull VirtualFile $this$doCalculateCrc, Project project) {
        Long l;
        if ($this$doCalculateCrc.isDirectory()) {
            l = null;
        } else {
            FileType fileType = $this$doCalculateCrc.getFileType();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"fileType");
            if (fileType.isBinary()) {
                l = null;
            } else {
                CharSequence charSequence = LoadTextUtil.loadText($this$doCalculateCrc);
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"LoadTextUtil.loadText(this)");
                FileType fileType2 = $this$doCalculateCrc.getFileType();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileType2, (String)"fileType");
                l = CrcUtils.doCalculateCrc(project, charSequence, fileType2);
            }
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private static final Long getCachedCrc(@NotNull UserDataHolder $this$getCachedCrc, long modificationStamp) {
        CrcCache crcCache = (CrcCache)$this$getCachedCrc.getUserData(CRC_CACHE);
        if (crcCache == null) {
            return null;
        }
        CrcCache crcCache2 = crcCache;
        long l = crcCache2.component1();
        long stamp = crcCache2.component2();
        if (stamp == modificationStamp) {
            void value2;
            return (long)value2;
        }
        return null;
    }

    private static final void setCachedCrc(@NotNull UserDataHolder $this$setCachedCrc, long value2, long modificationStamp) {
        $this$setCachedCrc.putUserData(CRC_CACHE, (Object)new CrcCache(value2, modificationStamp));
    }

    public static final /* synthetic */ Long access$doCalculateCrc(Document $this$access_u24doCalculateCrc, Project project, FileType fileType) {
        return CrcUtils.doCalculateCrc($this$access_u24doCalculateCrc, project, fileType);
    }

    public static final /* synthetic */ Long access$doCalculateCrc(VirtualFile $this$access_u24doCalculateCrc, Project project) {
        return CrcUtils.doCalculateCrc($this$access_u24doCalculateCrc, project);
    }
}

