/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude.ui;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MarkAsOriginalTypeAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            MarkAsOriginalTypeAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        JBIterable selectedFiles = JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file2 -> EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && typeManager.isMarkedAsPlainText((VirtualFile)file2));
        typeManager.resetOriginalFileType(project, VfsUtilCore.toVirtualFileArray((Collection)selectedFiles.toList()));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkAsOriginalTypeAction.$$$reportNull$$$0(1);
        }
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        JBIterable selectedFiles = JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file2 -> EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && typeManager.isMarkedAsPlainText((VirtualFile)file2));
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        boolean enabled = e.getProject() != null && !selectedFiles.isEmpty();
        Set fileTypes = selectedFiles.map(file2 -> fileTypeManager.getFileTypeByFileName(file2.getNameSequence())).toSet();
        if (fileTypes.size() == 1) {
            FileType original = (FileType)fileTypes.iterator().next();
            String originalName = StringUtil.defaultIfEmpty((String)original.getDescription(), (String)original.getName());
            String text = ActionsBundle.actionText((String)"MarkAsOriginalTypeAction").replace("Original File Type", originalName);
            e.getPresentation().setText(text);
            e.getPresentation().setIcon(original.getIcon());
        }
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/file/exclude/ui/MarkAsOriginalTypeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

