/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Producer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promises;

final class TrackedEdtActivityService {
    private final Project myProject;
    private volatile ModalityState myDumbStartModality;
    private final BlockingQueue<TrackedEdtActivity> myTrackedEdtActivities;

    TrackedEdtActivityService(@NotNull Project project) {
        if (project == null) {
            TrackedEdtActivityService.$$$reportNull$$$0(0);
        }
        this.myTrackedEdtActivities = new LinkedBlockingQueue<TrackedEdtActivity>();
        this.myProject = project;
    }

    void executeAllQueuedActivities() {
        while (!this.myTrackedEdtActivities.isEmpty()) {
            ((TrackedEdtActivity)this.myTrackedEdtActivities.poll()).run();
        }
    }

    private void invokeLater(@NotNull Runnable action2) {
        if (action2 == null) {
            TrackedEdtActivityService.$$$reportNull$$$0(1);
        }
        new TrackedEdtActivity(action2).invokeLater();
    }

    void invokeLaterIfProjectNotDisposed(@NotNull Runnable action2) {
        if (action2 == null) {
            TrackedEdtActivityService.$$$reportNull$$$0(2);
        }
        new TrackedEdtActivity(action2).invokeLaterIfProjectNotDisposed();
    }

    void invokeLaterAfterProjectInitialized(@NotNull Runnable action2) {
        if (action2 == null) {
            TrackedEdtActivityService.$$$reportNull$$$0(3);
        }
        new TrackedEdtActivity(action2).invokeLaterAfterProjectInitialized();
    }

    public void setDumbStartModality(@NotNull ModalityState modality) {
        if (modality == null) {
            TrackedEdtActivityService.$$$reportNull$$$0(4);
        }
        this.myDumbStartModality = modality;
    }

    public <T> T computeInEdt(@NotNull Producer<T> task2) {
        if (task2 == null) {
            TrackedEdtActivityService.$$$reportNull$$$0(5);
        }
        AsyncPromise promise = new AsyncPromise();
        this.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                promise.setError((Throwable)new ProcessCanceledException());
                return;
            }
            Promises.compute((AsyncPromise)promise, () -> ((Producer)task2).produce());
        });
        try {
            return (T)promise.get();
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof ProcessCanceledException)) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)cause);
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/TrackedEdtActivityService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLater";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLaterIfProjectNotDisposed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLaterAfterProjectInitialized";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setDumbStartModality";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computeInEdt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class TrackedEdtActivity
    implements Runnable {
        @NotNull
        private final Runnable myRunnable;

        TrackedEdtActivity(Runnable runnable2) {
            if (runnable2 == null) {
                TrackedEdtActivity.$$$reportNull$$$0(0);
            }
            this.myRunnable = runnable2;
            TrackedEdtActivityService.this.myTrackedEdtActivities.add(this);
        }

        void invokeLater() {
            ApplicationManager.getApplication().invokeLater((Runnable)this, this.getActivityExpirationCondition());
        }

        void invokeLaterIfProjectNotDisposed() {
            ApplicationManager.getApplication().invokeLater((Runnable)this, this.getProjectActivityExpirationCondition());
        }

        void invokeLaterAfterProjectInitialized() {
            StartupManager.getInstance((Project)TrackedEdtActivityService.this.myProject).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater((Runnable)this, TrackedEdtActivityService.this.myDumbStartModality, this.getProjectActivityExpirationCondition()));
        }

        @Override
        public void run() {
            TrackedEdtActivityService.this.myTrackedEdtActivities.remove(this);
            this.myRunnable.run();
        }

        @NotNull
        private Condition getProjectActivityExpirationCondition() {
            Condition condition = Conditions.or((Condition)TrackedEdtActivityService.this.myProject.getDisposed(), this.getActivityExpirationCondition());
            if (condition == null) {
                TrackedEdtActivity.$$$reportNull$$$0(1);
            }
            return condition;
        }

        @NotNull
        Condition<?> getActivityExpirationCondition() {
            Condition condition = __ -> !TrackedEdtActivityService.this.myTrackedEdtActivities.contains(this);
            if (condition == null) {
                TrackedEdtActivity.$$$reportNull$$$0(2);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/project/TrackedEdtActivityService$TrackedEdtActivity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/project/TrackedEdtActivityService$TrackedEdtActivity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectActivityExpirationCondition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActivityExpirationCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

