/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurerKt;
import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectFrameAllocator;
import com.intellij.openapi.project.impl.ProjectFrameAllocatorKt;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectUiFrameAllocator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.platform.ProjectSelfieUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.scale.ScaleContext;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.EOFException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J)\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/project/impl/ProjectUiFrameAllocator;", "Lcom/intellij/openapi/project/impl/ProjectFrameAllocator;", "options", "Lcom/intellij/ide/impl/OpenProjectTask;", "projectStoreBaseDir", "Ljava/nio/file/Path;", "(Lcom/intellij/ide/impl/OpenProjectTask;Ljava/nio/file/Path;)V", "cancelled", "", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "isFrameBoundsCorrect", "createFrameIfNeeded", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "getProgressTitle", "", "initNewFrame", "", "frame", "projectLoaded", "project", "Lcom/intellij/openapi/project/Project;", "projectNotLoaded", "error", "Lcom/intellij/conversion/CannotConvertException;", "projectOpened", "run", "T", "", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
public final class ProjectUiFrameAllocator
extends ProjectFrameAllocator {
    private ProjectFrameHelper frameHelper;
    private boolean isFrameBoundsCorrect;
    private volatile boolean cancelled;
    private OpenProjectTask options;
    private final Path projectStoreBaseDir;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <T> T run(@NotNull Function0<? extends T> task2) {
        void result2;
        Intrinsics.checkParameterIsNotNull(task2, (String)"task");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        String progressTitle = this.getProgressTitle();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, (Ref.ObjectRef)result2, task2, progressTitle){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function0 $task;
            final /* synthetic */ String $progressTitle;

            public final void run() {
                if (ProjectUiFrameAllocator.access$getOptions$p(this.this$0).isNewProject() && ProjectUiFrameAllocator.access$getOptions$p(this.this$0).getUseDefaultProjectAsTemplate() && ProjectUiFrameAllocator.access$getOptions$p(this.this$0).getProject() == null) {
                    SaveAndSyncHandler saveAndSyncHandler = SaveAndSyncHandler.Companion.getInstance();
                    ProjectManager projectManager = ProjectManager.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
                    Project project = projectManager.getDefaultProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ProjectManager.getInstance().defaultProject");
                    saveAndSyncHandler.saveSettingsUnderModalProgress((ComponentManager)project);
                }
                IdeFrameImpl frame = ProjectUiFrameAllocator.access$createFrameIfNeeded(this.this$0);
                Task.Modal progressTask2 = new Task.Modal(this, frame, null, this.$progressTitle, true){
                    final /* synthetic */ run.1 this$0;
                    final /* synthetic */ IdeFrameImpl $frame;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        if (ProjectUiFrameAllocator.access$getFrameHelper$p(this.this$0.this$0) == null) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                                final /* synthetic */ run.progressTask.1 this$0;

                                public final void run() {
                                    if (ProjectUiFrameAllocator.access$getCancelled$p(this.this$0.this$0.this$0)) {
                                        return;
                                    }
                                    String name$iv = "project frame initialization";
                                    ActivityCategory category$iv = ActivityCategory.APP_INIT;
                                    boolean $i$f$runActivity = false;
                                    Activity activity$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv);
                                    boolean bl = false;
                                    ProjectUiFrameAllocator.access$initNewFrame(this.this$0.this$0.this$0, this.this$0.$frame);
                                    Unit result$iv = Unit.INSTANCE;
                                    activity$iv.end();
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        }
                        this.this$0.$result.element = this.this$0.$task.invoke();
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        if (error instanceof StartupAbortedException || error instanceof PluginException) {
                            StartupAbortedException.logAndExit((Throwable)error);
                        } else {
                            boolean $i$f$logger = false;
                            Logger logger = Logger.getInstance(ProjectFrameAllocator.class);
                            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                            logger.error(error);
                            ProjectUiFrameAllocator projectUiFrameAllocator = this.this$0.this$0;
                            Throwable throwable = error;
                            if (!(throwable instanceof CannotConvertException)) {
                                throwable = null;
                            }
                            projectUiFrameAllocator.projectNotLoaded((CannotConvertException)throwable);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$frame = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                    }
                };
                ProgressManager progressManager = ProgressManager.getInstance();
                if (progressManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.progress.impl.CoreProgressManager");
                }
                if (!((CoreProgressManager)progressManager).runProcessWithProgressSynchronously((Task)progressTask2, frame.getRootPane())) {
                    this.$result.element = null;
                }
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$result = objectRef;
                this.$task = function0;
                this.$progressTitle = string;
            }
        });
        return (T)result2.element;
    }

    private final String getProgressTitle() {
        String string = this.options.getProjectName();
        if (string == null) {
            Path path = this.projectStoreBaseDir.getFileName();
            if (path == null) {
                path = this.projectStoreBaseDir;
            }
            string = ((Object)path).toString();
        }
        String projectName = string;
        String string2 = IdeUICustomization.getInstance().projectMessage("progress.title.project.loading.name", new Object[]{projectName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeUICustomization.getIn\u2026ading.name\", projectName)");
        return string2;
    }

    private final void initNewFrame(IdeFrameImpl frame) {
        FrameInfo frameInfo;
        Image projectSelfie;
        block11: {
            RecentProjectMetaInfo info;
            RecentProjectsManager recentProjectManager;
            if (frame.isVisible()) {
                ProjectFrameHelper frameHelper = new ProjectFrameHelper(frame, null);
                frameHelper.init();
                frame.validate();
                this.frameHelper = frameHelper;
                this.isFrameBoundsCorrect = true;
                return;
            }
            FrameInfo frameInfo2 = this.options.getFrame();
            if ((frameInfo2 != null ? frameInfo2.getBounds() : null) == null && (recentProjectManager = RecentProjectsManager.getInstance()) instanceof RecentProjectsManagerBase && (info = ((RecentProjectsManagerBase)recentProjectManager).getProjectMetaInfo(this.projectStoreBaseDir)) != null) {
                this.options = OpenProjectTask.copy$default(this.options, false, null, false, false, null, null, false, null, info.getFrame(), 0, 0, false, false, false, info.getProjectWorkspaceId(), false, false, null, null, null, 1031935, null);
            }
            projectSelfie = null;
            if (this.options.getProjectWorkspaceId$intellij_platform_ide_impl() != null && Registry.is((String)"ide.project.loading.show.last.state")) {
                try {
                    String string = this.options.getProjectWorkspaceId$intellij_platform_ide_impl();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    projectSelfie = ProjectSelfieUtil.readProjectSelfie(string, ScaleContext.create((Component)frame));
                }
                catch (Throwable e) {
                    if (e.getCause() instanceof EOFException) break block11;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ProjectFrameAllocator.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn(e);
                }
            }
        }
        ProjectFrameHelper frameHelper = new ProjectFrameHelper(frame, projectSelfie);
        FrameInfo frameInfo3 = frameInfo = this.options.getFrame();
        if ((frameInfo3 != null ? frameInfo3.getBounds() : null) == null) {
            this.isFrameBoundsCorrect = false;
            WindowManager windowManager = WindowManager.getInstance();
            if (windowManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
            }
            frameInfo = ((WindowManagerImpl)windowManager).getDefaultFrameInfoHelper$intellij_platform_ide_impl().getInfo();
        } else {
            this.isFrameBoundsCorrect = true;
        }
        if (frameInfo != null) {
            ProjectFrameAllocatorKt.access$restoreFrameState(frameHelper, frameInfo);
        }
        if (this.options.getSendFrameBack$intellij_platform_ide_impl() && frame.isAutoRequestFocus()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ProjectFrameAllocator.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("isAutoRequestFocus must be false");
        }
        frame.setVisible(true);
        frameHelper.init();
        this.frameHelper = frameHelper;
    }

    private final IdeFrameImpl createFrameIfNeeded() {
        WindowManager windowManager = WindowManager.getInstance();
        if (windowManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
        }
        ProjectFrameHelper freeRootFrame = ((WindowManagerImpl)windowManager).removeAndGetRootFrame$intellij_platform_ide_impl();
        if (freeRootFrame != null) {
            this.isFrameBoundsCorrect = true;
            this.frameHelper = freeRootFrame;
            IdeFrameImpl ideFrameImpl = freeRootFrame.getFrame();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideFrameImpl, (String)"freeRootFrame.frame");
            return ideFrameImpl;
        }
        String name$iv = "create a frame";
        boolean $i$f$runMainActivity = false;
        ActivityCategory category$iv$iv = ActivityCategory.MAIN;
        boolean $i$f$runActivity = false;
        Activity activity$iv$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv$iv);
        boolean bl = false;
        IdeFrameImpl ideFrameImpl = (IdeFrameImpl)SplashManager.getAndUnsetProjectFrame();
        if (ideFrameImpl == null) {
            ideFrameImpl = ProjectFrameAllocatorKt.createNewProjectFrame(this.options.getSendFrameBack$intellij_platform_ide_impl());
        }
        return ideFrameImpl;
    }

    @Override
    public void projectLoaded(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ApplicationManager.getApplication().invokeLater(new Runnable(this, project){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                ProjectFrameHelper projectFrameHelper = ProjectUiFrameAllocator.access$getFrameHelper$p(this.this$0);
                if (projectFrameHelper == null) {
                    return;
                }
                ProjectFrameHelper frameHelper = projectFrameHelper;
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
                }
                WindowManagerImpl windowManager2 = (WindowManagerImpl)windowManager;
                String name$iv = "project frame assigning";
                ActivityCategory category$iv = ActivityCategory.APP_INIT;
                boolean $i$f$runActivity = false;
                Activity activity$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv);
                boolean bl = false;
                ProjectFrameBounds projectFrameBounds = ProjectFrameBounds.Companion.getInstance(this.$project);
                if (ProjectUiFrameAllocator.access$isFrameBoundsCorrect$p(this.this$0)) {
                    Rectangle rectangle;
                    IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ideFrameImpl, (String)"frameHelper.frame");
                    if (FrameInfoHelper.Companion.isMaximized(ideFrameImpl.getExtendedState())) {
                        rectangle = null;
                    } else {
                        IdeFrameImpl ideFrameImpl2 = frameHelper.getFrame();
                        Intrinsics.checkExpressionValueIsNotNull((Object)ideFrameImpl2, (String)"frameHelper.frame");
                        rectangle = ideFrameImpl2.getBounds();
                    }
                    projectFrameBounds.markDirty(rectangle);
                } else {
                    FrameInfo frameInfo;
                    FrameInfo frameInfo2 = frameInfo = projectFrameBounds.getFrameInfoInDeviceSpace();
                    if ((frameInfo2 != null ? frameInfo2.getBounds() : null) != null) {
                        ProjectFrameAllocatorKt.access$restoreFrameState(frameHelper, frameInfo);
                    }
                }
                windowManager2.assignFrame(frameHelper, this.$project);
                Unit result$iv = Unit.INSTANCE;
                activity$iv.end();
                name$iv = "tool window pane creation";
                category$iv = ActivityCategory.APP_INIT;
                $i$f$runActivity = false;
                activity$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv);
                boolean bl2 = false;
                ToolWindowsPane result$iv2 = ToolWindowManagerEx.getInstanceEx(this.$project).init(frameHelper);
                activity$iv.end();
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$project = project;
            }
        }, project.getDisposed());
    }

    @Override
    public void projectNotLoaded(@Nullable CannotConvertException error) {
        this.cancelled = true;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, error){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ CannotConvertException $error;

            public final void run() {
                ProjectFrameHelper frame = ProjectUiFrameAllocator.access$getFrameHelper$p(this.this$0);
                ProjectUiFrameAllocator.access$setFrameHelper$p(this.this$0, null);
                if (this.$error != null) {
                    ProjectFrameHelper projectFrameHelper = frame;
                    ProjectManagerImpl.showCannotConvertMessage(this.$error, projectFrameHelper != null ? projectFrameHelper.getFrame() : null);
                }
                if (frame != null) {
                    Disposer.dispose((Disposable)frame);
                }
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$error = cannotConvertException;
            }
        });
    }

    @Override
    public void projectOpened(@NotNull Project project) {
        block0: {
            IdeFrame ideFrame;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (!this.options.getSendFrameBack$intellij_platform_ide_impl() || (ideFrame = this.frameHelper) == null || (ideFrame = ideFrame.getFrame()) == null) break block0;
            ideFrame.setAutoRequestFocus(true);
        }
    }

    public ProjectUiFrameAllocator(@NotNull OpenProjectTask options2, @NotNull Path projectStoreBaseDir) {
        Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
        super(options2);
        this.options = options2;
        this.projectStoreBaseDir = projectStoreBaseDir;
    }

    public static final /* synthetic */ OpenProjectTask access$getOptions$p(ProjectUiFrameAllocator $this) {
        return $this.options;
    }

    public static final /* synthetic */ void access$setOptions$p(ProjectUiFrameAllocator $this, OpenProjectTask openProjectTask) {
        $this.options = openProjectTask;
    }

    public static final /* synthetic */ IdeFrameImpl access$createFrameIfNeeded(ProjectUiFrameAllocator $this) {
        return $this.createFrameIfNeeded();
    }

    public static final /* synthetic */ ProjectFrameHelper access$getFrameHelper$p(ProjectUiFrameAllocator $this) {
        return $this.frameHelper;
    }

    public static final /* synthetic */ void access$setFrameHelper$p(ProjectUiFrameAllocator $this, ProjectFrameHelper projectFrameHelper) {
        $this.frameHelper = projectFrameHelper;
    }

    public static final /* synthetic */ boolean access$getCancelled$p(ProjectUiFrameAllocator $this) {
        return $this.cancelled;
    }

    public static final /* synthetic */ void access$setCancelled$p(ProjectUiFrameAllocator $this, boolean bl) {
        $this.cancelled = bl;
    }

    public static final /* synthetic */ void access$initNewFrame(ProjectUiFrameAllocator $this, IdeFrameImpl frame) {
        $this.initNewFrame(frame);
    }

    public static final /* synthetic */ boolean access$isFrameBoundsCorrect$p(ProjectUiFrameAllocator $this) {
        return $this.isFrameBoundsCorrect;
    }

    public static final /* synthetic */ void access$setFrameBoundsCorrect$p(ProjectUiFrameAllocator $this, boolean bl) {
        $this.isFrameBoundsCorrect = bl;
    }
}

