/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkDownloader;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownInvalidSdk
implements UnknownSdk {
    private static final Logger LOG = Logger.getInstance(UnknownInvalidSdk.class);
    @NotNull
    final Sdk mySdk;
    @NotNull
    final SdkType mySdkType;
    @Nullable
    UnknownSdkLocalSdkFix myLocalSdkFix;
    @Nullable
    UnknownSdkDownloadableSdkFix myDownloadableSdkFix;

    UnknownInvalidSdk(@NotNull Sdk sdk2, @NotNull SdkType sdkType) {
        if (sdk2 == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(0);
        }
        if (sdkType == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(1);
        }
        this.myLocalSdkFix = null;
        this.myDownloadableSdkFix = null;
        this.mySdk = sdk2;
        this.mySdkType = sdkType;
    }

    @Override
    @NotNull
    public SdkType getSdkType() {
        SdkType sdkType = this.mySdkType;
        if (sdkType == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(2);
        }
        return sdkType;
    }

    @Override
    @NotNull
    public String getSdkName() {
        String string = this.mySdk.getName();
        if (string == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public String getExpectedVersionString() {
        return this.mySdk.getVersionString();
    }

    void applyLocalFix(@NotNull Project project) {
        if (project == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(4);
        }
        if (this.myLocalSdkFix == null) {
            return;
        }
        String sdkFixVersionString = this.myLocalSdkFix.getVersionString();
        String sdkHome = this.myLocalSdkFix.getExistingSdkHome();
        this.copySdk(project, sdkFixVersionString, sdkHome);
    }

    private void copySdk(@NotNull Project project, @NotNull String sdkFixVersionString, @NotNull String sdkHome) {
        if (project == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(5);
        }
        if (sdkFixVersionString == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(6);
        }
        if (sdkHome == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(7);
        }
        WriteAction.run(() -> {
            SdkModificator mod = this.mySdk.getSdkModificator();
            mod.setVersionString(sdkFixVersionString);
            mod.setHomePath(sdkHome);
            mod.commitChanges();
            this.mySdkType.setupSdkPaths(this.mySdk);
        });
        UnknownSdkTracker.getInstance(project).updateUnknownSdksNow();
    }

    void applyDownloadFix(@NotNull Project project) {
        if (project == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(8);
        }
        if (this.myDownloadableSdkFix == null) {
            return;
        }
        UnknownSdkDownloader.downloadFix(project, this, this.myDownloadableSdkFix, __ -> this.mySdk, (Consumer<? super Sdk>)((Consumer)__ -> {}), (Consumer<? super Sdk>)((Consumer)sdk2 -> UnknownSdkTracker.getInstance(project).updateUnknownSdksNow()));
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler createSdkSelectionPopup(@NotNull Project project) {
        if (project == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(9);
        }
        String sdkName = this.mySdk.getName();
        EditorNotificationPanel.ActionHandler actionHandler = SdkPopupFactory.newBuilder().withProject(project).withSdkFilter((Condition<Sdk>)((Condition)sdk2 -> !Objects.equals(sdk2.getName(), sdkName))).withSdkTypeFilter((Condition<SdkTypeId>)((Condition)type -> Objects.equals(type, this.mySdkType))).onSdkSelected(sdk2 -> {
            String homePath = sdk2.getHomePath();
            String versionString = sdk2.getVersionString();
            if (homePath != null && versionString != null) {
                this.copySdk(project, versionString, homePath);
            } else {
                LOG.warn("Newly added SDK has invalid home or version: " + sdk2 + ", home=" + homePath + " version=" + versionString);
            }
        }).buildEditorNotificationPanelHandler();
        if (actionHandler == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(10);
        }
        return actionHandler;
    }

    static void removeAndUpdate(@NotNull List<UnknownInvalidSdk> invalidSdks, @NotNull List<UnknownSdk> fixable, @NotNull Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes, @NotNull Map<UnknownSdk, UnknownSdkDownloadableSdkFix> downloadFixes) {
        if (invalidSdks == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(11);
        }
        if (fixable == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(12);
        }
        if (localFixes == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(13);
        }
        if (downloadFixes == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(14);
        }
        fixable.removeAll(invalidSdks);
        for (UnknownInvalidSdk invalidSdk : invalidSdks) {
            invalidSdk.myLocalSdkFix = localFixes.remove(invalidSdk);
            invalidSdk.myDownloadableSdkFix = downloadFixes.remove(invalidSdk);
        }
    }

    @NotNull
    static List<UnknownInvalidSdk> resolveInvalidSdks(@NotNull List<Sdk> usedSdks) {
        if (usedSdks == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(15);
        }
        ArrayList<UnknownInvalidSdk> result2 = new ArrayList<UnknownInvalidSdk>();
        for (Sdk sdk2 : usedSdks) {
            UnknownInvalidSdk invalidSdk;
            if (SdkDownloadTracker.getInstance().isDownloading(sdk2) || (invalidSdk = UnknownInvalidSdk.resolveInvalidSdk(sdk2)) == null) continue;
            result2.add(invalidSdk);
        }
        ArrayList<UnknownInvalidSdk> arrayList = result2;
        if (arrayList == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    private static UnknownInvalidSdk resolveInvalidSdk(@NotNull Sdk sdk2) {
        SdkTypeId type;
        if (sdk2 == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(17);
        }
        if (!((type = sdk2.getSdkType()) instanceof SdkType)) {
            return null;
        }
        SdkType sdkType = (SdkType)type;
        if (ApplicationManager.getApplication().isUnitTestMode() && sdk2 instanceof MockSdk) {
            return null;
        }
        try {
            String homePath = sdk2.getHomePath();
            if (homePath != null && sdkType.isValidSdkHome(homePath)) {
                return null;
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Failed to validate SDK " + sdk2 + ". " + e.getMessage(), (Throwable)e);
            return null;
        }
        return new UnknownInvalidSdk(sdk2, sdkType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdk";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkFixVersionString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSdks";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFixes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadFixes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkSelectionPopup";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInvalidSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyLocalFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copySdk";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyDownloadFix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSdkSelectionPopup";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeAndUpdate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveInvalidSdks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveInvalidSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

