/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class UnknownSdkDownloader {
    private static final Logger LOG = Logger.getInstance(UnknownSdkDownloader.class);

    @ApiStatus.Internal
    public static void downloadFix(@Nullable Project project, @NotNull UnknownSdk info, final @NotNull UnknownSdkDownloadableSdkFix fix, @NotNull Function<SdkDownloadTask, Sdk> createSdk, @NotNull Consumer<? super Sdk> onSdkNameReady, @NotNull Consumer<? super Sdk> onCompleted) {
        SdkDownloadTask task2;
        if (info == null) {
            UnknownSdkDownloader.$$$reportNull$$$0(0);
        }
        if (fix == null) {
            UnknownSdkDownloader.$$$reportNull$$$0(1);
        }
        if (createSdk == null) {
            UnknownSdkDownloader.$$$reportNull$$$0(2);
        }
        if (onSdkNameReady == null) {
            UnknownSdkDownloader.$$$reportNull$$$0(3);
        }
        if (onCompleted == null) {
            UnknownSdkDownloader.$$$reportNull$$$0(4);
        }
        String title = ProjectBundle.message((String)"progress.title.downloading.sdk", (Object[])new Object[0]);
        try {
            task2 = (SdkDownloadTask)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<SdkDownloadTask, RuntimeException>(project, title, true){

                protected SdkDownloadTask compute(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return fix.createTask(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/projectRoots/impl/UnknownSdkDownloader$1", "compute"));
                }
            });
        }
        catch (ProcessCanceledException e) {
            onCompleted.consume(null);
            throw e;
        }
        catch (Exception error) {
            LOG.warn("Failed to download " + info.getSdkType().getPresentableName() + " " + fix.getDownloadDescription() + " for " + info + ". " + error.getMessage(), (Throwable)error);
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)ProjectBundle.message((String)"dialog.message.failed.to.download.0.1", (Object[])new Object[]{fix.getDownloadDescription(), error.getMessage()}), (String)title));
            onCompleted.consume(null);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                Disposable lifetime = Disposer.newDisposable();
                Sdk sdk2 = (Sdk)createSdk.apply(task2);
                SdkDownloadTracker downloadTracker = SdkDownloadTracker.getInstance();
                downloadTracker.registerSdkDownload(sdk2, task2);
                downloadTracker.tryRegisterDownloadingListener(sdk2, lifetime, new ProgressIndicatorBase(), (Consumer<Boolean>)((Consumer)success -> {
                    Disposer.dispose((Disposable)lifetime);
                    onCompleted.consume(success != false ? sdk2 : null);
                }));
                onSdkNameReady.consume((Object)sdk2);
                downloadTracker.startSdkDownloadIfNeeded(sdk2);
            }
            catch (Exception error) {
                LOG.warn("Failed to download " + info.getSdkType().getPresentableName() + " " + fix.getDownloadDescription() + " for " + info + ". " + error.getMessage(), (Throwable)error);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)ProjectBundle.message((String)"dialog.message.failed.to.download.0.1", (Object[])new Object[]{fix.getDownloadDescription(), error.getMessage()}), (String)title));
                onCompleted.consume(null);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "createSdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "onSdkNameReady";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "onCompleted";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkDownloader";
        objectArray[2] = "downloadFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

