/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.CustomLibraryTableImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.CustomLibraryTableDescription;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LibraryTablesRegistrarImpl
extends LibraryTablesRegistrar
implements Disposable {
    private static final ExtensionPointName<CustomLibraryTableDescription> CUSTOM_TABLES_EP = new ExtensionPointName("com.intellij.customLibraryTable");
    private final Map<String, LibraryTableBase> myCustomLibraryTables = new ConcurrentHashMap<String, LibraryTableBase>();
    private volatile boolean myExtensionsLoaded = false;
    private final Object myExtensionsLoadingLock = new Object();

    LibraryTablesRegistrarImpl() {
    }

    @NotNull
    public LibraryTable getLibraryTable() {
        ApplicationLibraryTable applicationLibraryTable = ApplicationLibraryTable.getApplicationTable();
        if (applicationLibraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(0);
        }
        return applicationLibraryTable;
    }

    @NotNull
    public LibraryTable getLibraryTable(@NotNull Project project) {
        if (project == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(1);
        }
        LibraryTable libraryTable = (LibraryTable)project.getService(ProjectLibraryTable.class);
        if (libraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(2);
        }
        return libraryTable;
    }

    public LibraryTable getLibraryTableByLevel(String level, @NotNull Project project) {
        if (project == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(3);
        }
        switch (level) {
            case "project": {
                return this.getLibraryTable(project);
            }
            case "application": {
                return this.getLibraryTable();
            }
        }
        return this.getCustomLibraryTableByLevel(level);
    }

    @Nullable
    public LibraryTable getCustomLibraryTableByLevel(String level) {
        return this.getCustomLibrariesMap().get(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, LibraryTableBase> getCustomLibrariesMap() {
        if (this.myExtensionsLoaded) {
            Map<String, LibraryTableBase> map2 = this.myCustomLibraryTables;
            if (map2 == null) {
                LibraryTablesRegistrarImpl.$$$reportNull$$$0(4);
            }
            return map2;
        }
        Object object = this.myExtensionsLoadingLock;
        synchronized (object) {
            if (!this.myExtensionsLoaded) {
                CUSTOM_TABLES_EP.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CustomLibraryTableDescription>(){

                    public void extensionAdded(@NotNull CustomLibraryTableDescription extension, @NotNull PluginDescriptor pluginDescriptor) {
                        if (extension == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (pluginDescriptor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        CustomLibraryTableImpl table = new CustomLibraryTableImpl(extension.getTableLevel(), extension.getPresentation());
                        LibraryTablesRegistrarImpl.this.myCustomLibraryTables.put(extension.getTableLevel(), table);
                    }

                    public void extensionRemoved(@NotNull CustomLibraryTableDescription extension, @NotNull PluginDescriptor pluginDescriptor) {
                        LibraryTableBase table;
                        if (extension == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (pluginDescriptor == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if ((table = (LibraryTableBase)LibraryTablesRegistrarImpl.this.myCustomLibraryTables.remove(extension.getTableLevel())) != null) {
                            Disposer.dispose((Disposable)table);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "extension";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "pluginDescriptor";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "extensionAdded";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "extensionRemoved";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, true, null);
                this.myExtensionsLoaded = true;
            }
        }
        Map<String, LibraryTableBase> map3 = this.myCustomLibraryTables;
        if (map3 == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(5);
        }
        return map3;
    }

    public void registerLibraryTable(@NotNull LibraryTable libraryTable) {
        String tableLevel;
        LibraryTable oldTable;
        if (libraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(6);
        }
        if ((oldTable = (LibraryTable)this.myCustomLibraryTables.put(tableLevel = libraryTable.getTableLevel(), (LibraryTableBase)libraryTable)) != null) {
            throw new IllegalArgumentException("Library table '" + tableLevel + "' already registered.");
        }
    }

    @NotNull
    public List<LibraryTable> getCustomLibraryTables() {
        return new SmartList(this.getCustomLibrariesMap().values());
    }

    public void dispose() {
        for (LibraryTableBase value2 : this.myCustomLibraryTables.values()) {
            Disposer.dispose((Disposable)value2);
        }
        this.myCustomLibraryTables.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryTable";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLibrariesMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTableByLevel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerLibraryTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

