/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MigrateToNewDiffUtil {
    @NotNull
    public static DiffRequest convertRequest(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        if (oldRequest == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(0);
        }
        com.intellij.openapi.diff.DiffContent[] contents = oldRequest.getContents();
        String[] titles = oldRequest.getContentTitles();
        ArrayList<DiffContent> newContents = new ArrayList<DiffContent>(contents.length);
        for (com.intellij.openapi.diff.DiffContent content2 : contents) {
            newContents.add(MigrateToNewDiffUtil.convertContent(oldRequest.getProject(), content2));
        }
        return new SimpleDiffRequest(oldRequest.getWindowTitle(), newContents, Arrays.asList(titles));
    }

    @NotNull
    private static DiffContent convertContent(@Nullable Project project, @NotNull com.intellij.openapi.diff.DiffContent oldContent) {
        if (oldContent == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(1);
        }
        DiffContentFactory factory2 = DiffContentFactory.getInstance();
        if (oldContent.isEmpty()) {
            EmptyContent emptyContent = factory2.createEmpty();
            if (emptyContent == null) {
                MigrateToNewDiffUtil.$$$reportNull$$$0(2);
            }
            return emptyContent;
        }
        if (oldContent instanceof FileContent) {
            VirtualFile file2 = Objects.requireNonNull(oldContent.getFile());
            DiffContent diffContent = factory2.create(project, file2);
            if (diffContent == null) {
                MigrateToNewDiffUtil.$$$reportNull$$$0(3);
            }
            return diffContent;
        }
        if (oldContent instanceof SimpleContent) {
            DocumentContent documentContent = factory2.create(project, ((SimpleContent)oldContent).getText(), oldContent.getContentType());
            if (documentContent == null) {
                MigrateToNewDiffUtil.$$$reportNull$$$0(4);
            }
            return documentContent;
        }
        Document document = Objects.requireNonNull(oldContent.getDocument());
        DocumentContent documentContent = factory2.create(project, document, oldContent.getContentType());
        if (documentContent == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(5);
        }
        return documentContent;
    }

    @NotNull
    public static MergeRequest convertMergeRequest(@NotNull MergeRequestImpl request2) throws InvalidDiffRequestException {
        if (request2 == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(6);
        }
        MergeRequestImpl.MergeContent mergeContent = Objects.requireNonNull(request2.getMergeContent());
        MergeVersion.MergeDocumentVersion mergeVersion = (MergeVersion.MergeDocumentVersion)mergeContent.getMergeVersion();
        SimpleContent leftContent = (SimpleContent)request2.getContents()[0];
        SimpleContent rightContent = (SimpleContent)request2.getContents()[2];
        List<String> contents = Arrays.asList(leftContent.getText(), mergeVersion.getOriginalText(), rightContent.getText());
        Document document = mergeContent.getDocument();
        String windowTitle = request2.getWindowTitle();
        List<String> titles = Arrays.asList(request2.getContentTitles());
        Consumer callback2 = result2 -> request2.setResult(result2 == MergeResult.CANCEL ? 1 : 0);
        MergeRequest mergeRequest = DiffRequestFactory.getInstance().createMergeRequest(request2.getProject(), mergeContent.getContentType(), document, contents, windowTitle, titles, callback2);
        if (mergeRequest == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(7);
        }
        return mergeRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRequest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMergeRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertRequest";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertMergeRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

