/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.TitleInfoProvider;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.util.io.SuperUserStatus;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ProjectFrameHelper
implements IdeFrameEx,
AccessibleContextAccessor,
DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(IdeFrameImpl.class);
    private static boolean ourUpdatingTitle;
    private String myTitle;
    private String myFileTitle;
    private Path myCurrentFile;
    private Project myProject;
    private IdeRootPane myRootPane;
    private BalloonLayout myBalloonLayout;
    @Nullable
    private IdeFrameDecorator myFrameDecorator;
    private volatile Image selfie;
    private IdeFrameImpl myFrame;
    private List<TitleInfoProvider> myTitleInfoExtensions;

    public ProjectFrameHelper(@NotNull IdeFrameImpl frame, @Nullable Image selfie) {
        if (frame == null) {
            ProjectFrameHelper.$$$reportNull$$$0(0);
        }
        this.myTitleInfoExtensions = null;
        this.myFrame = frame;
        this.selfie = selfie;
        this.setupCloseAction();
        this.preInit();
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
    }

    @Nullable
    public static ProjectFrameHelper getFrameHelper(@Nullable Window window) {
        IdeFrameImpl projectFrame;
        if (window == null) {
            return null;
        }
        if (window instanceof IdeFrameImpl) {
            projectFrame = (IdeFrameImpl)window;
        } else {
            projectFrame = (IdeFrameImpl)SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window);
            if (projectFrame == null) {
                return null;
            }
        }
        IdeFrameImpl.FrameHelper frameLightHelper = projectFrame.getFrameHelper();
        return frameLightHelper == null ? null : (ProjectFrameHelper)frameLightHelper.getHelper();
    }

    private void preInit() {
        this.updateTitle();
        this.myRootPane = this.createIdeRootPane();
        this.myFrame.setRootPane(this.myRootPane);
        this.myFrameDecorator = IdeFrameDecorator.decorate(this.myFrame, this);
        this.myFrame.setFrameHelper(new IdeFrameImpl.FrameHelper(){

            @Nullable
            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ProjectFrameHelper.this.getData(dataId);
            }

            @Override
            public String getAccessibleName() {
                StringBuilder builder2 = new StringBuilder();
                if (ProjectFrameHelper.this.myProject != null) {
                    builder2.append(ProjectFrameHelper.this.myProject.getName());
                    builder2.append(" - ");
                }
                builder2.append(ApplicationNamesInfo.getInstance().getFullProductName());
                return builder2.toString();
            }

            @Override
            public void dispose() {
                if (ProjectFrameHelper.isTemporaryDisposed(ProjectFrameHelper.this.myFrame)) {
                    ProjectFrameHelper.this.myFrame.doDispose();
                    return;
                }
                Disposer.dispose((Disposable)ProjectFrameHelper.this);
            }

            @Override
            public void updateView() {
                ProjectFrameHelper.this.updateView();
            }

            @Override
            @Nullable
            public Project getProject() {
                return ProjectFrameHelper.this.myProject;
            }

            @Override
            @NotNull
            public IdeFrame getHelper() {
                ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.this;
                if (projectFrameHelper == null) {
                    1.$$$reportNull$$$0(1);
                }
                return projectFrameHelper;
            }

            @Override
            public void setTitle(String title) {
                if (ourUpdatingTitle) {
                    ProjectFrameHelper.this.myFrame.doSetTitle(title);
                } else {
                    ProjectFrameHelper.this.myTitle = title;
                }
                ProjectFrameHelper.this.updateTitle();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/wm/impl/ProjectFrameHelper$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/wm/impl/ProjectFrameHelper$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHelper";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, this.myFrameDecorator);
        this.myBalloonLayout = new BalloonLayoutImpl(this.myRootPane, (Insets)JBUI.insets((int)8));
        this.myFrame.setBackground(UIUtil.getPanelBackground());
    }

    @NotNull
    protected IdeRootPane createIdeRootPane() {
        return new IdeRootPane(this.myFrame, this, this);
    }

    public void releaseFrame() {
        this.myRootPane.removeToolbar();
        WindowManagerEx.getInstanceEx().releaseFrame(this);
    }

    public void init() {
        this.myRootPane.init(this, this);
        MnemonicHelper.init((Component)this.myFrame);
        this.myFrame.setFocusTraversalPolicy(new IdeFocusTraversalPolicy());
        if (SystemInfo.isMac) {
            this.myFrame.setIconImage(null);
        }
        IdeMenuBar.installAppMenuIfNeeded(this.myFrame);
        AppUIUtil.updateWindowIcon(this.myFrame);
        MouseGestureManager.getInstance().add(this);
    }

    public JComponent getComponent() {
        return this.myFrame.getRootPane();
    }

    private void setupCloseAction() {
        this.myFrame.setDefaultCloseOperation(0);
        final CloseProjectWindowHelper helper = this.createCloseProjectWindowHelper();
        this.myFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(@NotNull WindowEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ProjectFrameHelper.isTemporaryDisposed(ProjectFrameHelper.this.myFrame) || LaterInvocator.isInModalContext()) {
                    return;
                }
                Application app = ApplicationManager.getApplication();
                if (app != null && !app.isDisposed()) {
                    helper.windowClosing(ProjectFrameHelper.this.myProject);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ProjectFrameHelper$2", "windowClosing"));
            }
        });
    }

    @NotNull
    protected CloseProjectWindowHelper createCloseProjectWindowHelper() {
        return new CloseProjectWindowHelper();
    }

    @Nullable
    public IdeStatusBarImpl getStatusBar() {
        return this.myRootPane == null ? null : this.myRootPane.getStatusBar();
    }

    @Deprecated
    public void setTitle(@NotNull String title) {
        if (title == null) {
            ProjectFrameHelper.$$$reportNull$$$0(1);
        }
        this.myFrame.setTitle(title);
    }

    public void setFrameTitle(String text) {
        this.myFrame.setTitle(text);
    }

    @Override
    public void setFileTitle(@Nullable String fileTitle, @Nullable Path file2) {
        this.myFileTitle = fileTitle;
        this.myCurrentFile = file2;
        this.updateTitle();
    }

    @Override
    @Nullable
    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return this.myRootPane.findByName(key);
    }

    private void updateTitle() {
        ProjectFrameHelper.updateTitle(this.myFrame, this.myTitle, this.myFileTitle, this.myCurrentFile, this.myTitleInfoExtensions);
    }

    @Nullable
    public static String getSuperUserSuffix() {
        return !SuperUserStatus.isSuperUser() ? null : (SystemInfo.isWindows ? "Administrator" : "ROOT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTitle(@NotNull JFrame frame, @Nullable String title, @Nullable String fileTitle, @Nullable Path currentFile, @Nullable List<TitleInfoProvider> extensions2) {
        if (frame == null) {
            ProjectFrameHelper.$$$reportNull$$$0(2);
        }
        if (ourUpdatingTitle) {
            return;
        }
        try {
            ourUpdatingTitle = true;
            if (Registry.is((String)"ide.show.fileType.icon.in.titleBar")) {
                File ioFile = currentFile != null ? currentFile.toFile() : null;
                frame.getRootPane().putClientProperty("Window.documentFile", ioFile);
            }
            Builder builder2 = new Builder().append(title).append(fileTitle);
            if (extensions2 != null && !extensions2.isEmpty()) {
                for (TitleInfoProvider extension : extensions2) {
                    String it;
                    if (!extension.isActive() || (it = extension.getValue()).isEmpty()) continue;
                    builder2.append(it, " ");
                }
            }
            frame.setTitle(builder2.toString());
        }
        finally {
            ourUpdatingTitle = false;
        }
    }

    public void updateView() {
        this.myRootPane.updateToolbar();
        this.myRootPane.updateMainMenuActions();
        this.myRootPane.updateNorthComponents();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.myFrame.getAccessibleContext();
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ProjectFrameHelper.$$$reportNull$$$0(3);
        }
        if (CommonDataKeys.PROJECT.is(dataId) && this.myProject != null) {
            return this.myProject.isInitialized() ? this.myProject : null;
        }
        if (IdeFrame.KEY.getName().equals(dataId)) {
            return this;
        }
        return null;
    }

    public void setProject(@Nullable Project project) {
        if (this.myProject == project) {
            return;
        }
        this.myProject = project;
        if (project == null) {
            if (this.myRootPane != null) {
                this.myRootPane.deinstallNorthComponents();
            }
            return;
        }
        if (this.myRootPane != null) {
            this.myRootPane.setProject(project);
            this.myRootPane.installNorthComponents(project);
            IdeStatusBarImpl statusBar = this.myRootPane.getStatusBar();
            if (statusBar != null) {
                project.getMessageBus().connect().subscribe(StatusBar.Info.TOPIC, (Object)statusBar);
            }
        }
        this.installDefaultProjectStatusBarWidgets(this.myProject);
        this.initTitleInfoProviders(project);
        if (this.selfie != null) {
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
                this.selfie = null;
            }));
        }
    }

    protected void initTitleInfoProviders(@NotNull Project project) {
        if (project == null) {
            ProjectFrameHelper.$$$reportNull$$$0(4);
        }
        this.myTitleInfoExtensions = TitleInfoProvider.getProviders(project, (Function1<? super TitleInfoProvider, Unit>)((Function1)it -> {
            this.updateTitle();
            return Unit.INSTANCE;
        }));
    }

    protected void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        if (project == null) {
            ProjectFrameHelper.$$$reportNull$$$0(5);
        }
        ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateAllWidgets();
        PopupHandler.installPopupHandler((JComponent)Objects.requireNonNull(this.getStatusBar()), (String)"ViewStatusBarWidgetsGroup", (String)"StatusBarPlace");
    }

    public Project getProject() {
        return this.myProject;
    }

    public void dispose() {
        MouseGestureManager.getInstance().remove(this);
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        if (this.myRootPane != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.myRootPane.removeNotify();
            }
            this.myFrame.setRootPane(new JRootPane());
            this.myRootPane = null;
        }
        if (this.myFrame != null) {
            this.myFrame.doDispose();
            this.myFrame.setFrameHelper(null, null);
            this.myFrame = null;
        }
        this.myFrameDecorator = null;
    }

    private static boolean isTemporaryDisposed(@Nullable RootPaneContainer frame) {
        return UIUtil.isClientPropertyTrue((Object)(frame == null ? null : frame.getRootPane()), (Object)"dispose.temporary");
    }

    @NotNull
    public IdeFrameImpl getFrame() {
        IdeFrameImpl ideFrameImpl = this.myFrame;
        if (ideFrameImpl == null) {
            ProjectFrameHelper.$$$reportNull$$$0(6);
        }
        return ideFrameImpl;
    }

    @ApiStatus.Internal
    @Nullable
    public IdeFrameImpl getFrameOrNullIfDisposed() {
        return this.myFrame;
    }

    @ApiStatus.Internal
    @Nullable
    IdeRootPane getRootPane() {
        return this.myRootPane;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle b = this.myFrame.getBounds();
        b.x += 100;
        b.width -= 200;
        b.y += 100;
        b.height -= 200;
        Rectangle rectangle = b;
        if (rectangle == null) {
            ProjectFrameHelper.$$$reportNull$$$0(7);
        }
        return rectangle;
    }

    @Nullable
    public final BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    public boolean isInFullScreen() {
        return this.myFrameDecorator != null && this.myFrameDecorator.isInFullScreen();
    }

    @Override
    @NotNull
    public Promise<?> toggleFullScreen(boolean state) {
        if (this.temporaryFixForIdea156004(state) || this.myFrameDecorator == null) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                ProjectFrameHelper.$$$reportNull$$$0(8);
            }
            return promise;
        }
        Promise<Boolean> promise = this.myFrameDecorator.toggleFullScreen(state);
        if (promise == null) {
            ProjectFrameHelper.$$$reportNull$$$0(9);
        }
        return promise;
    }

    private boolean temporaryFixForIdea156004(boolean state) {
        if (!SystemInfo.isMac) {
            return false;
        }
        try {
            Field modalBlockerField = Window.class.getDeclaredField("modalBlocker");
            modalBlockerField.setAccessible(true);
            Window modalBlocker = (Window)modalBlockerField.get(this.myFrame);
            if (modalBlocker != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.toggleFullScreen(state), ModalityState.NON_MODAL);
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/ProjectFrameHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/ProjectFrameHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestChildFrameBounds";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleFullScreen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateTitle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initTitleInfoProviders";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installDefaultProjectStatusBarWidgets";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Builder {
        private final StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        Builder append(@Nullable String s) {
            return this.append(s, " \u2013 ");
        }

        Builder append(@Nullable String s, String separator) {
            if (!StringUtil.isEmptyOrSpaces((String)s)) {
                if (this.sb.length() > 0) {
                    this.sb.append(separator);
                }
                this.sb.append(s);
            }
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

