/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NonNls;

public abstract class VisibilityWatcher
extends ComponentAdapter
implements PropertyChangeListener {
    @NonNls
    protected static final String ANCESTOR_PROPERTY_NAME = "ancestor";

    @Override
    public final void componentHidden(ComponentEvent e) {
        this.visibilityChanged();
    }

    @Override
    public final void componentShown(ComponentEvent e) {
        this.visibilityChanged();
    }

    @Override
    public final void propertyChange(PropertyChangeEvent e) {
        if (!ANCESTOR_PROPERTY_NAME.equals(e.getPropertyName())) {
            throw new IllegalArgumentException("unknown propertyName: " + e.getPropertyName());
        }
        Component oldAncestor = (Component)e.getOldValue();
        this.deinstall(oldAncestor);
        Component newAncestor = (Component)e.getNewValue();
        this.install(newAncestor);
        this.visibilityChanged();
    }

    public final void install(Component component2) {
        while (component2 != null) {
            component2.removePropertyChangeListener(ANCESTOR_PROPERTY_NAME, this);
            component2.addPropertyChangeListener(ANCESTOR_PROPERTY_NAME, this);
            component2.removeComponentListener(this);
            component2.addComponentListener(this);
            component2 = component2.getParent();
        }
    }

    public void deinstall(Component component2) {
        while (component2 != null) {
            component2.removePropertyChangeListener(ANCESTOR_PROPERTY_NAME, this);
            component2.removeComponentListener(this);
            component2 = component2.getParent();
        }
    }

    public abstract void visibilityChanged();
}

