/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.ProgressButton;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineProgressIndicator
extends ProgressIndicatorBase
implements Disposable {
    protected TextPanel myText;
    private TextPanel myText2;
    private JBIterable<ProgressButton> myEastButtons;
    protected JProgressBar myProgress;
    protected JPanel myComponent;
    private final boolean myCompact;
    private TaskInfo myInfo;
    private TextPanel myProcessName;
    private boolean myDisposed;

    public InlineProgressIndicator(boolean compact, @NotNull TaskInfo processInfo) {
        if (processInfo == null) {
            InlineProgressIndicator.$$$reportNull$$$0(0);
        }
        this.myEastButtons = JBIterable.empty();
        this.myCompact = compact;
        this.myInfo = processInfo;
        this.myProgress = new JProgressBar(0);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myProgress);
        this.createComponent();
    }

    protected void createComponent() {
        this.myText = new TextPanel();
        this.myText2 = new TextPanel();
        this.myProcessName = new TextPanel();
        this.myComponent = new MyComponent(this.myCompact, (JComponent)((Object)this.myProcessName));
        this.myEastButtons = this.createEastButtons();
        if (this.myCompact) {
            this.myComponent.setLayout(new BorderLayout(2, 0));
            this.createCompactTextAndProgress();
            this.myComponent.add((Component)InlineProgressIndicator.createButtonPanel((Iterable<? extends JComponent>)this.myEastButtons.map(b -> b.button)), "East");
            this.myComponent.setToolTipText(this.myInfo.getTitle() + ". " + IdeBundle.message((String)"progress.text.clickToViewProgressWindow", (Object[])new Object[0]));
        } else {
            this.myComponent.setLayout(new BorderLayout());
            this.myProcessName.setText(this.myInfo.getTitle());
            this.myComponent.add((Component)((Object)this.myProcessName), "North");
            this.myProcessName.setForeground(UIUtil.getPanelBackground().brighter().brighter());
            this.myProcessName.setBorder(JBUI.Borders.empty((int)2));
            NonOpaquePanel content2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            content2.setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)(this.myInfo.isCancellable() ? 2 : 4)));
            this.myComponent.add((Component)content2, "Center");
            content2.add((Component)InlineProgressIndicator.createButtonPanel((Iterable<? extends JComponent>)this.myEastButtons.map(b -> InlineProgressIndicator.withBorder(b.button))), (Object)"East");
            content2.add((Component)((Object)this.myText), (Object)"North");
            content2.add((Component)this.myProgress, (Object)"Center");
            content2.add((Component)((Object)this.myText2), (Object)"South");
            this.myComponent.setBorder(JBUI.Borders.empty((int)2));
        }
        UIUtil.uiTraverser((Component)this.myComponent).forEach(o -> ((JComponent)o).setOpaque(false));
        if (!this.myCompact) {
            this.myProcessName.recomputeSize();
            this.myText.recomputeSize();
            this.myText2.recomputeSize();
        }
    }

    protected void createCompactTextAndProgress() {
        NonOpaquePanel textAndProgress = new NonOpaquePanel((LayoutManager)new BorderLayout());
        textAndProgress.add((Component)((Object)this.myText), "Center");
        NonOpaquePanel progressWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        progressWrapper.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        progressWrapper.add((Component)this.myProgress, (Object)"Center");
        textAndProgress.add((Component)progressWrapper, "East");
        this.myComponent.add((Component)textAndProgress, "Center");
    }

    static JPanel createButtonPanel(Iterable<? extends JComponent> components) {
        NonOpaquePanel iconsPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        GridBag gb = new GridBag().setDefaultFill(1);
        for (JComponent jComponent : components) {
            iconsPanel.add((Component)jComponent, gb.next());
        }
        return iconsPanel;
    }

    private static Wrapper withBorder(InplaceButton button2) {
        Wrapper wrapper2 = new Wrapper((JComponent)button2);
        wrapper2.setBorder((Border)JBUI.Borders.empty((int)0, (int)3, (int)0, (int)2));
        return wrapper2;
    }

    protected JBIterable<ProgressButton> createEastButtons() {
        return JBIterable.of((Object)this.createCancelButton());
    }

    protected final ProgressButton createCancelButton() {
        InplaceButton cancelButton = new InplaceButton(new IconButton(this.myInfo.getCancelTooltipText(), this.myCompact ? AllIcons.Process.StopSmall : AllIcons.Process.Stop, this.myCompact ? AllIcons.Process.StopSmallHovered : AllIcons.Process.StopHovered), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InlineProgressIndicator.this.cancelRequest();
            }
        }).setFillBg(false);
        cancelButton.setVisible(this.myInfo.isCancellable());
        return new ProgressButton(cancelButton, () -> cancelButton.setPainting(!this.isStopping()));
    }

    protected void cancelRequest() {
        this.cancel();
    }

    protected void updateProgress() {
        this.queueProgressUpdate();
    }

    protected void updateAndRepaint() {
        if (this.isDisposed()) {
            return;
        }
        this.updateProgressNow();
        this.myComponent.repaint();
    }

    public void updateProgressNow() {
        if (this.isPaintingIndeterminate()) {
            this.myProgress.setIndeterminate(true);
        } else {
            this.myProgress.setIndeterminate(false);
            this.myProgress.setMinimum(0);
            this.myProgress.setMaximum(100);
        }
        if (this.getFraction() > 0.0) {
            this.myProgress.setValue((int)(this.getFraction() * 99.0 + 1.0));
        }
        this.setTextValue(this.getText() != null ? this.getText() : "");
        this.setText2Value(this.getText2() != null ? this.getText2() : "");
        if (this.myCompact && StringUtil.isEmpty((String)this.getTextValue())) {
            this.setTextValue(this.myInfo.getTitle());
        }
        if (this.isStopping()) {
            if (this.myCompact) {
                this.setTextValue("Stopping - " + this.getTextValue());
            } else {
                this.setProcessNameValue("Stopping - " + this.myInfo.getTitle());
                this.setTextEnabled(false);
                this.setText2Enabled(false);
            }
            this.myProgress.setEnabled(false);
        } else {
            this.setTextEnabled(true);
            this.setText2Enabled(true);
            this.myProgress.setEnabled(true);
        }
        this.myEastButtons.forEach(b -> b.updateAction.run());
    }

    @Nullable
    protected String getTextValue() {
        return this.myText.getText();
    }

    protected void setTextValue(@NotNull String text) {
        if (text == null) {
            InlineProgressIndicator.$$$reportNull$$$0(1);
        }
        this.myText.setText(text);
    }

    protected void setTextEnabled(boolean value2) {
        this.myText.setEnabled(value2);
    }

    protected void setText2Value(@NotNull String text) {
        if (text == null) {
            InlineProgressIndicator.$$$reportNull$$$0(2);
        }
        this.myText2.setText(text);
    }

    protected void setText2Enabled(boolean value2) {
        this.myText2.setEnabled(value2);
    }

    protected void setProcessNameValue(@NotNull String text) {
        if (text == null) {
            InlineProgressIndicator.$$$reportNull$$$0(3);
        }
        this.myProcessName.setText(text);
    }

    protected boolean isPaintingIndeterminate() {
        return this.isIndeterminate() || this.getFraction() == 0.0;
    }

    protected boolean isStopping() {
        return this.wasStarted() && (this.isCanceled() || !this.isRunning()) && !this.isFinished();
    }

    protected boolean isFinished() {
        return false;
    }

    protected void queueProgressUpdate() {
        this.updateAndRepaint();
    }

    protected void queueRunningUpdate(@NotNull Runnable update2) {
        if (update2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(4);
        }
        update2.run();
    }

    @Override
    protected void onProgressChange() {
        this.updateProgress();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public TaskInfo getInfo() {
        return this.myInfo;
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myComponent.removeAll();
        this.myComponent = null;
        if (this.myProgress != null) {
            UIUtil.disposeProgress((JProgressBar)this.myProgress);
        }
        this.myProgress = null;
        this.myInfo = null;
    }

    private boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/InlineProgressIndicator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTextValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setText2Value";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setProcessNameValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "queueRunningUpdate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyComponent
    extends JPanel {
        private final boolean myCompact;
        private final JComponent myProcessName;

        private MyComponent(boolean compact, JComponent processName) {
            this.myCompact = compact;
            this.myProcessName = processName;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (UIUtil.isCloseClick((MouseEvent)e) && MyComponent.this.getBounds().contains(e.getX(), e.getY())) {
                        InlineProgressIndicator.this.cancelRequest();
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.myCompact) {
                super.paintComponent(g);
                return;
            }
            GraphicsConfig c = GraphicsUtil.setupAAPainting((Graphics)g);
            UISettings.setupAntialiasing((Graphics)g);
            int arc = 8;
            Color bg = this.getBackground();
            Rectangle bounds2 = this.myProcessName.getBounds();
            Rectangle label2 = SwingUtilities.convertRectangle(this.myProcessName.getParent(), bounds2, this);
            g.setColor(UIUtil.getPanelBackground());
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            if (!StartupUiUtil.isUnderDarcula()) {
                bg = ColorUtil.toAlpha((Color)bg.darker().darker(), (int)230);
                g.setColor(bg);
                g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
                g.setColor(UIUtil.getPanelBackground());
                g.fillRoundRect(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2, arc, arc);
                g.fillRect(0, (int)label2.getMaxY() + 1, this.getWidth() - 1, this.getHeight() / 2);
            } else {
                bg = bg.brighter();
                g.setColor(bg);
                g.drawLine(0, (int)label2.getMaxY() + 1, this.getWidth() - 1, (int)label2.getMaxY() + 1);
            }
            g.setColor(bg);
            g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            c.restore();
        }
    }
}

